/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Voyetra Technologies, 1990-1993                             */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*     Voyetra Technologies
*     5 Odell Plaza
*     Yonkers, NY 10701
*     Tel: 914-966-0600
*******************************************************************************
*
* assign2.c
*
* This file was adapted by Media Vision from source of Voyetra Technologies.
*
*/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#include <meerror.h>
#define DRV_16
#include "os2mixer.h"

#include "mvprodd.h"
#include "parse.cdf"
#include "adlib.h"
#include "parse.ext"
#include "findpas.h"
#include "globals.h"
#include "pasdef.h"
#include "proto.h"

#define MAX_NUMBER_OF_DRUM_OPERATORS 3

/////#pragma message("this allocation wastes space..")
/* MAX_NUMBER_OF_OPERATORS is the total possible number of voices */
/* MAX_NUMBER_OF_DRUM_OPERATORS is a subset of all the voices */
/* and are treated different here but not in other array with */
/* MAX_NUMBER_OF_OPERATORS entries in them */

static OFF_ENTRY near   note_q_data[MAX_NUMBER_OF_OPERATORS] = {0};
static OFF_ENTRY near   drum_q_data[MAX_NUMBER_OF_DRUM_OPERATORS] = {0};

static VOICE_STATUS_ENTRY note_op_stats[MAX_NUMBER_OF_OPERATORS] = {0};
static VOICE_STATUS_ENTRY drum_op_stats[MAX_NUMBER_OF_DRUM_OPERATORS] = {0};

ALLOC_Q note_q = {0, 0, 0, 0, note_q_data, note_op_stats};
ALLOC_Q drum_q = {0, 0, 0, 0, drum_q_data, drum_op_stats};



static char is_sused[MAX_NUMBER_OF_OPERATORS];

/* do_sus_off(op)
 *      Shut off operator op if sustaining. the little guy
 */
void do_sus_off(int op)
{
   if (is_sused[op])
      {
      shut_off_chan_voice(op);
      is_sused[op] = 0;
       }
}


static void add_q_sub(int p, int chan, int * op, NPALLOC_Q q, int limit);
static int  remove_target_sub(int p, int chan, int * op, NPALLOC_Q q);
static void remove_next_q(int * op, NPALLOC_Q q);
static void shut_off_oldest(NPALLOC_Q q);
static void near init_q_sub(NPALLOC_Q q, int size, int limit);
static void near shut_off_all_sub( NPALLOC_Q q);

/* for_all_ops_on_chan(function)
 *      Calls supplied function address for each operator which is currently
 *      playing and is on given channel
 * called only for note_q!
 */
void for_all_ops_on_chan(int m_chan, int (*function)(int op))
{
   int  curptr;

   curptr = note_q.usedlist;
   while (curptr >= 0)
      {
      register int tptr = curptr;
      curptr = note_q_data[curptr].next;
      if (note_op_stats[tptr].cur_chan == (BYTE) m_chan)
           (*function)(tptr);   /* call passed addr if operator is on the current chan */
      }
}

/* init_q()
 *      Initialize the note off queue structure.
 */
void  init_q(void)
{
   init_q_sub(&note_q, sizeof(note_q_data), max_melo_voice);
   init_q_sub(&drum_q, sizeof(drum_q_data), MAX_NUMBER_OF_DRUM_OPERATORS -1);
}

static void near init_q_sub(NPALLOC_Q q, int size, int limit)
{
   int i;

   for (i = 0; i < size; i++)                   //go thru the list
      {
      q->data[i].next = (char) (i + 1);         // link all the entries
      }
   q->data[limit].next = -1;                    // terminate at desired limit
   q->freelist = 0;
   q->usedlist = -1;
   q->usedcount = 0;
   q->lastused = -1;
   return;
}


/* remove_target(p, chan, op)
 *      Search for and remove a particular note from the queue.
 *      Return the operator it was assigned to at *op.
 *      Return 0 if not found in queue, 1 if found.
 */

remove_target(int p, int chan, int * op)
{
   return remove_target_sub(p, chan, op, &note_q);
}

remove_target2(int p, int chan, int * op)
{
   return remove_target_sub(p, chan, op, &drum_q);
}

static int  remove_target_sub(int p, int chan, int * op, NPALLOC_Q q)
{
int             found;
int             curptr;
int             prevptr;
int             search;
int             nexts;

   found = 0;                                                           /* found flag */
   curptr = q->usedlist;                                                        /* search through the used list */
   prevptr = -1;                                                                /* remember previous enttry */
   while (curptr >= 0 && !found)                                                /* until target found, or no more entries */
      {
      if (p == (int) q->op_stats[curptr].cur_pitch && chan == (int) q->op_stats[curptr].cur_chan)
              {
        found++;
        }
       else
              {
         look_more:
                prevptr = curptr;
                curptr = q->data[curptr].next;
         }
      }

   if (found)
      {
      if (channel_stats[chan].sus_pedal)                // implement Sustain here
              {
              if (is_sused[curptr])
                 {
                 found = 0;
                 goto look_more;
                 }
        is_sused[curptr] = 1;                   // LMH 5-22-92
        *op = curptr;
        return 0;                               // so NoteOff not called
        }
      if (curptr == q->lastused)                        /* if this is last entry in used list */
         q->lastused = prevptr;                 /* then keep this variable current */

      if (prevptr >= 0)                         /* if not first entry in list */
              q->data[prevptr].next = q->data[curptr].next;     /* link around this one, as we're deleting it */
      else                                      /* found in first entry so */
              q->usedlist = q->data[curptr].next;               /* just bump up list head */


      for (nexts=search=q->freelist; nexts>= 0; )       // find end of Q
              {
           search = nexts;
              nexts = q->data[search].next;
           }
      q->data[curptr].next = -1;                                // mark as end of q
      if (search >= 0)
         q->data[search].next = (signed char) curptr;   // if sonething in q
      else
         q->freelist = curptr;                          // if this will be only entry

      *op = curptr;
      q->usedcount--;
      }
   else
      {
      *op = -1;
      }

return(found);
}

/*   static int near search_list(int chan, int pitch)
 *
 * Will look for a free voice that matches chan AND pitch
 *   if pitch < 0, will only try to match chan
 * if found, will remove from free list and return index
 * if !found, returns < 0
 */
static int near search_list(int chan, int pitch, NPALLOC_Q q)
{
   int          found;
   int          curptr;
   int          prevptr;

   found = 0;                                                           /* found flag */
   curptr = q->freelist;                                                        /* search through the used list */
   prevptr = -1;                                                                /* remember previous enttry */
   while (curptr >= 0 && !found)                                                /* until target found, or no more entries */
      {
      if (( chan == (int) q->op_stats[curptr].cur_chan) &&
           (pitch < 0 || (pitch ==  (int)q->op_stats[curptr].cur_pitch)))
           {
           found++;
           }
   else
           {
           prevptr = curptr;
        curptr = q->data[curptr].next;
           }
   }

   if (found)
      {
      if (prevptr >= 0)                                 /* if not first entry in list */
              q->data[prevptr].next = q->data[curptr].next;     /* link around this one, as we're deleting it */
      else                                      /* found in first entry so */
        q->freelist = q->data[curptr].next;             /* just bump up list head */
      }

   return found ? curptr : -1;
}

/* add_q(p, chan, op)
 *      Add the specified pitch and channel to the queue.  If necessary,
 *      shut off the oldest operator to free one up.  Assign an operator
 *      and return that choice at *op.
 */

void  add_q(int p, int chan, int * op)
{
   add_q_sub(p, chan, op, &note_q, max_melo_voice);;
}

void  add_q2(int p, int chan, int * op)
{
   add_q_sub(p, chan, op, &drum_q, MAX_NUMBER_OF_DRUM_OPERATORS -1);
}

static void  add_q_sub(int p, int chan, int * op, NPALLOC_Q q, int limit)
{
   int          curptr;

   if (q->usedcount > limit)
      {
      shut_off_oldest(q);
      }

   curptr = search_list(chan, p, q);
   if (curptr < 0) curptr = search_list(chan, -1, q);
   if (curptr < 0)
      {
      curptr = q->freelist;                     /* save and */
      q->freelist = q->data[q->freelist].next;  /*  advance free list ptr */
      }

   if (q->lastused >= 0) q->data[q->lastused].next = (char) curptr;     /* insert new guy at */
   q->data[curptr].next = -1;                                   /*  end of used list */

   q->op_stats[curptr].cur_chan = (char) chan;
   q->op_stats[curptr].cur_pitch = (char) p;

   if (q->usedlist < 0) q->usedlist = curptr;
   q->lastused = curptr;
   is_sused[curptr] = 0;
   *op = curptr;
   q->usedcount++;
}

/* shut_off_chan_voice(op)
 *      Shut off an operator and remove its note from queue.
 * only from note_q
 */
void shut_off_chan_voice(int op)
{
   remove_target(note_op_stats[op].cur_pitch, note_op_stats[op].cur_chan, &gop);        /* we know gop will = op */
   NoteOff(gop, 0);
}

/* shut_off_oldest()
 *      Shuts off the oldest note playing.
 *      Assumes there are notes playing!!
 */

static  void shut_off_oldest(NPALLOC_Q q)
{
   remove_next_q( &gop, q );
   NoteOff(gop, 0);
}

/* shut_off_all()
 *      Shuts off all the melodic and percussive operators.
 */
void shut_off_all(void)
{
   shut_off_all_sub(&note_q);
   shut_off_all_sub(&drum_q);
}

static void near shut_off_all_sub( NPALLOC_Q q)
{
   while (q->usedcount)
      shut_off_oldest(q);
}

/* remove_next_q(op)
 *      Remove the oldest note from the queue.  Return the operator
 *      it was assigned to at *op.
 * note: operator == voice
 */

static void
remove_next_q(int * op, NPALLOC_Q q)
{
   int          temp;

   temp = q->usedlist;                  /* save and */
   q->usedlist = q->data[q->usedlist].next;     /*  advance used list ptr */
   if (temp == q->lastused) q->lastused = -1;

   q->data[temp].next = (char) q->freelist;     /* insert at front */
   q->freelist = temp;                  /*  of free list */

   *op = temp;
   q->usedcount--;
   return;
}
