;*DDK*************************************************************************/
;
; COPYRIGHT (C) Voyetra Technologies, 1990-1993
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;     Voyetra Technologies
;     5 Odell Plaza
;     Yonkers, NY 10701
;     Tel: 914-966-0600
;******************************************************************************
;
; anlmul.asm - assembler implemented 'C' callable long divide
;
; This file implements a C callable routine for long divide.
; Implemented in assembler prevents use of C runtime provided routine
;******************************************************************************

include parse.inc
include vapi.mac

_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:_TEXT


PUBLIC __aNulmul
PUBLIC __aNlmul

; extern long near pascal _aNlmul(long mul1, long mul2)
; This routine multiplies two long integers and returns result in AX:DX
;
__aNulmul label NEAR
__aNlmul PROC NEAR
        PUSH    BP
        MOV     BP, SP
        MOV     AX, [BP+06]
        MOV     BX, [BP+0Ah]
        OR      BX, AX
        MOV     BX, [BP+08]
        JNZ     @F
        MOV     AX, [BP+04]
        MUL     BX
        MOV     SP, BP
        POP     BP
        RET     0008

        @@:
        MUL     BX
        MOV     CX, AX
        MOV     AX, [BP+04]

        MUL     WORD PTR [BP+0Ah]
        ADD     CX, AX
        MOV     AX, [BP+04]
        MUL     BX
        ADD     DX, CX
        MOV     SP, BP
        POP     BP
        RET     0008

__aNlmul ENDP

_TEXT   ENDS
END
