/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Voyetra Technologies, 1990-1993                             */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*     Voyetra Technologies
*     5 Odell Plaza
*     Yonkers, NY 10701
*     Tel: 914-966-0600
*******************************************************************************
*
* adlib.c
*
*/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#include <meerror.h>
#define DRV_16
#include "os2mixer.h"

#include "mvprodd.h"
#include "parse.cdf"
#include "adlib.h"
#include "parse.ext"
#include "findpas.h"
#include "pasdef.h"
#include "globals.h"
#include "proto.h"

///#pragma intrinsic (inp)

#define TOM_PITCH       24
#define TOM_TO_SD       7                                               /* 7 steps between voice 7 & 8 */
#define SD_PITCH        (TOM_PITCH + TOM_TO_SD)

        /* macro to point into the patch data for a parameter */
#define FETCH_PARAM( slot, prm) ((unsigned)(*(slot_parameter_map[slot] + prm)))

#define HIGH_BYTE( word) ( ((char *)(&word))[ 1])                       /* 80x86-8 only .. */

typedef char    SLOT_PARAM;

        /* pitch bend variables */
static char     note_octave_map[ 96] = {0};                             /* table of (0..95) DIV 12 */
static char     note_semi_map[ 96] = {0};                               /* table of (0..95) MOD 12 */

        /* used in set_the_ksl_in_a_slot(int slot) */
static char     vol_of_this_slot[ TOT_SLOTS] = {0};                     /* relative volume of slots */

#include "2op_Cdrm.c"
#include "cmp_drum.c"

void near SndOutput1(unsigned short addr, unsigned short val);

char key_on_voice[MAX_NUMBER_OF_VOICES] = {0};                  /* state of keyOn bit of each voice */
static char current_voice_pitch[ MAX_NUMBER_OF_VOICES] = {0};   /* pitch of last note of each voice  */

        /* pointers to the patches for each slot */
static SLOT_PARAM * slot_parameter_map[ TOT_SLOTS] = {0};

static char     percussion_enable_bits = 0;                     /* control bits of percussive voices */
static char percussion_enable_bit_masks[] =
    {
    0x10, 0x08, 0x04, 0x02, 0x01
    };
        /* in 4OP mode, the first 6 2OP voices of each half chip become */
        /* 3 4OP voices. The extra Vx registers control the PAN and */
        /* CONFIGURATION of those operators. the SndOutputVx function */
        /* needs to be able to set theese. The extra 2OP voices are used */
        /* for 2OP drums and and drum-mode-drums. they are accessed from */
        /* the other modules as higher voice numbers */

/* here is a map of the voice to SndOutputVx to Vx register map for OPL3_FM */
/*  first half Vx     voice OutputVx    second half Vx voice  OutputVx  */
        /*      0       0       0       |       0       3       3       */
        /*      1       1       1       |       1       4       4       */
        /*      2       2       2       |       2       5       5       */
        /*      3       -       12      |       3       -       15      */
        /*      4       -       13      |       4       -       16      */
        /*      5       -       14      |       5       -       17      */
        /*      6       9       9       |       6       6       6       */
        /*      7       10      10      |       7       7       7       */
        /*      8       11      11      |       8       8       8       */

char  voice_slot_map[MAX_NUMBER_OF_OPERATORS] [ 4 ] = {
        {0,     3,      6,       9},            // 6 '4-OP' voices
        {1,     4,      7,      10},
        {2,     5,      8,      11},
        {0 +18, 3 +18,  6 +18,   9 +18},
        {1 +18, 4 +18,  7 +18,  10 +18},
        {2 +18, 5 +18,  8 +18,  11 +18},
        {12 +18, 15 +18, 12 +18, 15 +18},       // and 6 '2-OP' left over
        {13 +18, 16 +18, 13 +18, 16 +18},               // 3 slots for 2OP drums
        {14 +18, 17 +18, 14 +18, 17 +18},
        {12,    15,     12,     15},                    // these slots -not array vals- are used for dreum mode drums
        {13,    16,     13,     16},                    // SetVoiceVolume compares
        {14,    17,     14,     17}                     // slot[0] to slot[2] to see if 2 OP
        };

static char  perc_slot_map[] [ 4 ] = {
        {12, 15, 12, 15},       // Bass Drum: slot 12 and 15
        {16, 16, 16, 16},       // SD: slot 16
        {14, 14, 14, 14},       // TOM: slot 14
        {17, 17, 17, 17},       // TOP-CYM: slot 17
        {13, 13, 13, 13} };     // HH: slot 13
                        // SetVoiceVolume compares
                        // slot[0] to slot[2] to see if 2 OP

// for allocated voices to voice registers in SndOutputVx
static char second_chip[6] = { 0, 1, 1, 0, 0, 1 };
static char voice_to_Vx[6] = { 0, 0, 6, 6, 3, 3 };

/* a voice +12 means voice + 3 in SndOutputVx */

static char slot_to_voice_map2[NUM_SLOTS_CHIP] = {
        0, 1, 2, 0, 1, 2,
        0, 1, 2, 0, 1, 2,
        9,10,11, 9,10,11,       // these are DRUM MODE slots
        3, 4, 5, 3, 4, 5,
        3, 4, 5, 3, 4, 5,
        6, 7, 8, 6, 7, 8        };


/* This table tells if the slot is a car -OP2 OP4- (0),
 dummy mod -OP3- (1) or a mod -OP1- (2). Mod gets FeedBack and CNT
 Only the CNT == !FM and PAN bits are signifigant for the dummy mod */
static char slot_is_mod[NUM_SLOTS_CHIP] = {
    2, 2, 2, 0, 0, 0, 1, 1, 1, 0, 0, 0,         2, 2, 2, 0, 0, 0,
    2, 2, 2, 0, 0, 0, 1, 1, 1, 0, 0, 0,         2, 2, 2, 0, 0, 0        };


static char  slot_offset_map2[NUM_SLOTS_CHIP] = {
    0,  1,  2,  3,  4,  5, 8,  9, 10, 11, 12, 13, 16, 17, 18, 19, 20, 21
};


int             adlib_pitch_range_step = 0;     /* pitch variation, half-tone [+1,+12] */
static unsigned         micro_freq_lookup[ NR_STEP_PITCH] [ 12] = {0};
static int              semi_offset_lookup[MAX_NUMBER_OF_VOICES] = {0};
static unsigned *       pointer_to_current_freqs[MAX_NUMBER_OF_VOICES] = {0};

/* FUNCTIONS
*/
static void set_all_the_params_in_a_slot(int  slot);
static void set_the_ksl_in_a_slot(int slot);
static void send_modulation_params(void);
static void change_pitch_a_bit(int voice, long pitchBend);
static void SetFreq(unsigned voice, int pitch);
static void InitSlotParams(void);
static void SetFNum( unsigned * fNumVec, int num, int den);
static void InitFNums(void);
static void SoundChut(int voice);


/* shut_off_drum_voices()
 */
void shut_off_drum_voices(void)
{
   percussion_enable_bits = 0;
   send_modulation_params();
}

void set_pitch_range(unsigned p_range)
{
   if ( p_range > 12)
      p_range = 12;
   if ( p_range < 1)
      p_range = 1;

   adlib_pitch_range_step = p_range * NR_STEP_PITCH;
}

long calc_pitch(int m_chan)
{
   return cur_bender[m_chan];
}

/* set_pitch_of_this_voice(voice, pitchBend)
 *      set the pitch of the voice to its current pitch + pitchBend
 */
void set_pitch_of_this_voice(unsigned voice, long pitchBend)
{
if( ! percussion || voice <= BD)                                /* melodic, bass drum */
    {
    change_pitch_a_bit(voice, pitchBend);
    SetFreq(voice, current_voice_pitch[voice]);
    }
}

/* InitSlotParams()
 *      put the static drum data in the drum-mode-drum slots
 */
static void InitSlotParams(void)
{
   int          i;
   static int   firstTimeEver = 1;

   if (firstTimeEver)
      {
      for (i=0; i < number_of_operators; i++)
              {
              gop = i;
              update_pgm(0, i);         // start at pgm 0 9/20/90
              }
      gop = 0;
      firstTimeEver = 0;
      }

   if( percussion)
      {
      set_a_param_in_a_slot( 12, bass_drum_preset0);
      set_a_param_in_a_slot( 15, bass_drum_preset1);
      set_a_param_in_a_slot( 16, sdOpr);
      set_a_param_in_a_slot( 14, tom_tom_preset);
      set_a_param_in_a_slot( 17, crash_cymbal_preset);
      set_a_param_in_a_slot( 13, high_hat_preset);
      }
}


/* CalcPremFNum(numDeltaDemiTon, denDeltaDemiTon)
 *      Pitch Bend utilities
 */
static long f8 = 0;
static long fNum8 = 0;
static long  CalcPremFNum(int numDeltaDemiTon, int denDeltaDemiTon)
{
   long d100;

   d100 = denDeltaDemiTon * 100;
   f8 = ( d100 + 6 * numDeltaDemiTon) * (26044L * 2L);  /* 260.44 * 100 * 2 */
   f8 /= d100 * 25;
   fNum8 = f8 * 16384;          /*( 16384L * 9L);       */
   fNum8 *= 9L;
   fNum8 /= 179L * 625L;
   return(fNum8);
}


/* SetFNum(fNumVec, num, den)
 *      Pitch Bend utilities
*/
static long val = 0;

static void SetFNum( unsigned * fNumVec, int num, int den)
{
   int  i;

   *fNumVec++ = (unsigned)(4 +(val = CalcPremFNum( num, den))) >> 3;
   for ( i = 1; i < 12; i++)
      {
      val *= 106;
      *fNumVec++ = (unsigned)(4 +(val /= 100)) >> 3;
      }
}


/* InitFNums()
 *      Pitch Bend utilities
*/
static void InitFNums(void)
{
   unsigned i, j, k, num, numStep, pas;

   numStep = 100 / NR_STEP_PITCH;
   for( num = pas = 0; pas < NR_STEP_PITCH; pas++, num += numStep)
      SetFNum( micro_freq_lookup[ pas], num, 100);

   for( i = 0; i < MAX_NUMBER_OF_VOICES; i++)
      {
      pointer_to_current_freqs[ i] = (unsigned *) micro_freq_lookup[ 0];
      semi_offset_lookup[ i] = 0;
      }

   for( k= i = 0; i < 8; i++)
      {
      for( j = 0; j < 12; j++, k++)
              {
              note_octave_map[ k] = (char)i;
        note_semi_map[ k] = (char)j;
        }
      }
}


/* change_pitch_a_bit(voice, pitchBend)
 *      Pitch Bend a voice, optimized for time if called with the same pitchBend
 *      I will not pretend to understand this or the 3 routines above - LMH
*/
static void change_pitch_a_bit(int voice, long pitchBend)
{
   int temp_var_1, temp_pitch, delta;
   static long oldL = ~0;
   static int oldHt = 0;
   static unsigned * oldPtr = 0;

   if( oldL == pitchBend)
      {                                         /* optimization ... */
      pointer_to_current_freqs[ voice] = oldPtr;
      semi_offset_lookup[ voice] = oldHt;
      }
   else
      {
      temp_var_1 = (int) (pitchBend / MID_PITCH);
      if( temp_var_1 < 0)
              {
              temp_pitch = NR_STEP_PITCH -1 -temp_var_1;
              oldHt = semi_offset_lookup[ voice] = -(temp_pitch / NR_STEP_PITCH);
              delta = (temp_pitch - NR_STEP_PITCH +1) % NR_STEP_PITCH;
              if( delta) delta = NR_STEP_PITCH - delta;
              }
       else
              {
        oldHt = semi_offset_lookup[ voice] = temp_var_1 / NR_STEP_PITCH;
        delta = temp_var_1 % NR_STEP_PITCH;
        }
       oldPtr = pointer_to_current_freqs[ voice] = (unsigned *) micro_freq_lookup[ delta];
       oldL = pitchBend;
       }
}


/* set_a_param_in_a_slot(slot, cParam)
 *      saves the pointer to the patch data and calls
 *      set_all_the_params_in_a_slot() to fill the operator with the data
 *      called for each slot in a voice from update_pgm() in DO.C when a note
 *      is going to be played in a voice which last played a diifernt patch
 */
void set_a_param_in_a_slot(unsigned slot,  char * cParam)
{
   slot_parameter_map[ slot ] = cParam;
   set_all_the_params_in_a_slot( slot);
}

/*   static int slot_to_voice_map(int slot)
 *      used to get the voice for SndOutputVx()
 *      so set_all_the_params_in_a_slot()
 *      can set the ModFeedback and other Vx register stuff
 */
static int slot_to_voice_map(int slot)
{
return slot_to_voice_map2[slot];
}


/*   static int slot_is_modulator(int slot)
 *      used by set_all_the_params_in_a_slot() to decide if it should
 *      set the ModFeedback and other Vx register stuff
 */
static int slot_is_modulator(int slot)
{
   return (slot_is_mod[slot]);
}

/*  static void SndOutputSlot(int addr, int slot, int val)
 *      write to a register on the FM chip (or chips for DUAL FM)
 *      slot is our internal logical slot number
 */
static void SndOutputSlot(int addr, int slot, int val)
{
   if (slot < (NUM_SLOTS_HALF))
      SndOutput1(addr + slot_offset_map2[slot], val);
   else
      SndOpl3_2_1(addr + slot_offset_map2[slot - NUM_SLOTS_HALF], val);
}


/* void SndOutputVx()
 *      Write to a Vx registers on the chip (or chips if DUAL FM)
 */
static void
SndOutputVx(int addr, int vx, int val)
{
   int div = vx / 3;
   int adr = addr + voice_to_Vx[div] + (vx - div * 3);
   if (second_chip[div])
      SndOpl3_2_1(adr, val);
   else
      SndOutput1(adr, val);
}

/* SetVoicePan_and_FB()
 *      put the PAN bits in the Vx register with the CONFIG bit
 *      this must be done to 2 registers per 4OP voice if OPL3_FM
 */
void SetVoicePan_and_FB(int voice, char pan)            /* FeedBack field and C = ! FM */
{
   char * slot;

   if (percussion && (voice >= BD))
      {
      if (voice != BD)                  // trying to fix Bass, LMH 8/92
              return;
      slot = perc_slot_map[0];          // needed for 4OP driver
      }
   else
      slot = voice_slot_map[voice];
   SndOutputVx( 0xC0 , voice,
                ((FETCH_PARAM(slot[0], prmFeedBack) & 0x0F) ^ 1) | pan);
   if (voice <= MAX_PERC_MODE_VX)                       // percussive mode too
      SndOutputVx( 0xC0 , voice + 12,
                ((FETCH_PARAM(slot[2], prmFeedBack) & 0x0F) ^ 1) | pan);
}

/*   set_all_the_params_in_a_slot(slot)
 *         fills the slot (operator) with the pointer to the patch data
 */
static void set_all_the_params_in_a_slot(int  slot)
{
   register SLOT_PARAM * slot_ptr = slot_parameter_map[slot] ;

        /* will be incremented for COMPRESS */
   send_modulation_params();
   SndOutputSlot( 0x20 , slot, * slot_ptr++);
   set_the_ksl_in_a_slot( slot);
   slot_ptr++;

   SndOutputSlot( 0x60 , slot, * slot_ptr++);   /* set up the attack and dec */
   SndOutputSlot( 0x80 , slot, * slot_ptr++);   /* set up the sustain and release */

   if (slot_is_modulator(slot) == 2)                    // if OP3
      SetVoicePan_and_FB(slot_to_voice_map(slot), 0x30);        // turn it on

        /* FeedBack and Wave Sel in same byte */
   SndOutputSlot( 0xE0 , slot, * slot_ptr >> 5);
}


/* set_the_ksl_in_a_slot(slot)
 *      calculate the volume for the slot and put it in the chip with
 *      the KeyboardScaLing
 */
static void set_the_ksl_in_a_slot(int slot)
{
   unsigned temp_var_1;

   temp_var_1 = vol_of_this_slot[slot] *
                ( ~ FETCH_PARAM(slot, prmLevel) & 0x3f) + 1;
   temp_var_1 = 63 - (temp_var_1 / MAX_VOLUME);
   temp_var_1 |= FETCH_PARAM( slot, prmKsl) & 0xC0;
   SndOutputSlot( 0x40 , slot, temp_var_1);
}

/*   send_modulation_params()
 *         Set the AM Depth, VIB depth & Rhythm for the whole chip
 */
static void send_modulation_params(void)
{
   unsigned temp_var_1;

   temp_var_1 = 0x80 | 0x40;                    /* max mod 7/17/90 bgf */
   if (percussion)
      temp_var_1 |= 0x20;
   temp_var_1 |= percussion_enable_bits;
   SndOutput1( 0xBD, temp_var_1);               //???????? for dual mode?
}

/* SetFreq(voice, pitch)
        Change pitch of voices 0 to 8, for melodic or percussive mode.
 *      save off the given MIDI note num and combine it with the
 *      pitch bend and key-on bit and write it all to the Vx register
*/
static void SetFreq(unsigned voice, int pitch)
{
   unsigned int local_temp;
   static unsigned int temp_freq = 0;

   current_voice_pitch[ voice] = (char) pitch;
   pitch += semi_offset_lookup[ voice];
   if( pitch > 95)
      pitch = 95;
   if( pitch < 0)
      pitch = 0;
   temp_freq = * ( pointer_to_current_freqs[ voice] + note_semi_map[ pitch]);
   SndOutputVx( 0xA0, voice, temp_freq);
   local_temp = key_on_voice[ voice] ? 32 : 0;
   local_temp += ( (unsigned)note_octave_map[ pitch] << 2) + ( 0x3 & HIGH_BYTE( temp_freq) );
   SndOutputVx( 0xB0 , voice, local_temp);
}


/* SoundChut(voice)
        Set the frequency of voice 'voice' to 0 hertz.
*/
static void SoundChut(int voice)
{
   SndOutputVx( 0xA0 ,voice, 0);
   SndOutputVx( 0xB0 ,voice, 0);
}

/* BoardInstalled()
        Return 0 if board is not installed
*/
//
//  This function determines presence of OPL-3
//  and resets the hardware.
//

int BoardInstalled(void)
{
   unsigned local_temp, temp_status, i;

   SndOutput1( 4, 0x60);                                        /* mask T1 & T2 */
   SndOutput1( 4, 0x80);                                        /* reset IRQ */
   local_temp = IN_STAT();                                              /* read status register */
   SndOutput1( 2, 0xff);                                        /* set timer-1 latch */
   SndOutput1( 4, 0x21);                                        /* unmask & start T1 */
   for( i = 0; i < 200; i++)
      IN_STAT();                          // delay
   temp_status = IN_STAT();                                     /* read status register */
   SndOutput1( 4, 0x60);
   SndOutput1( 4, 0x80);
   return (local_temp & 0xE0) == 0 && (temp_status & 0xE0) == 0xC0;
}


/* SetOplMode(mode)
 *      do global FM chip stuff
 * 0 = melodic
 * 1 = perc
 */
void SetOplMode(int mode)
{
   if( mode)
      {                                                         /* changing into percussion mode */
      SoundChut( BD);                                           /* turn off these operators */
      key_on_voice[BD] = 0;
      SoundChut( SD);
      SoundChut( TOM);
      key_on_voice[TOM] = 0;
      SetFreq( TOM, TOM_PITCH);                                 /* set the frequency for the last 4 percussion voices */
      key_on_voice[SD] = 0;
      SetFreq( SD, SD_PITCH);
      }
   percussion = (char) mode;                                    /* set global var */
   percussion_enable_bits = 0;                                  /* zero all percussion bits (turn off all perc voices) */
   SndOpl3_2_1( 4, 0x3F);                       /* 4 OP me */

   InitSlotParams();                                            /* load all operators with default voices */
   send_modulation_params();                                    /* send rhythm voice bits to turn 'em off */
}

void reset_close(void)
{
   SndOpl3_2_1( 4, 0);                  /* 2 OP me again */
   SndOpl3_2_1( 5, 0);          /* clear NEW bit or won't be ADLIB for the next guy */
}

/* SoundColdInit()
        Must be called for start-up initialization.
        Return 0 if harware not found.
  what about dual mode? @@@@@@@@@@@@@@@
*/
void SoundColdInit()
{
   int i;

   SndOpl3_2_1( 5, 1);          /* set NEW bit */

   InitFNums();
   SetOplMode( DEF_PERC_MODE);                                  /* melodic mode?? */
   send_modulation_params();                                    /* these routines prepare bytes according to glob vars */
   SndOutput1( 0x08, 0);                                        /* set the note select */
   for( i = 0 ; i < number_of_operators; i++)
      SoundChut( i);
   set_pitch_range(sapi_pitch_range);                           /* default pitch range is 2 half-tone */
   for( i = 0; i < num_slots; i++)
      SndOutputSlot( 0xE0 , i, 0);                              /* choose normal sine wave for all operators */
}

        /* how do I tell if slot is REALLY a carrier for given config, */
        /* bit 0 - OP1, bit 1 - OP2, bit 2 - OP3, bit 3 - OP4 */
static char config_map[4] = { 0x0D, 0x09, 0x0A, 0x0A };
                        /* cfg 1 -OP1,OP3,OP4...   ^should be 8, but make 2OP DRUMS work */

/* SetVoiceVolume(voice, volume)
 *      set the volume of all the operators playing a voice
 *      set the modulators to MAX and carriers to volume given
 *      so that the timbre stays the same for different volumes
 *      for SUPER_SAPI this is configurable.
 */
void SetVoiceVolume(int voice, unsigned volume)
{
   int i, opcfg; char * slot;
   if (percussion && (voice >= BD))
      {
      slot = perc_slot_map[voice -BD];
      opcfg = (voice == BD) ? 2 : 1;            // yes, set volume of DRUMS
      }
   else
      {
      slot = voice_slot_map[voice];
      opcfg =  ((FETCH_PARAM(slot[0], prmFm) & 1) << 1)
           + (FETCH_PARAM(slot[2], prmFm) & 1);
      opcfg = (int)config_map[opcfg];
      }
   i = 0;
   do  {
      vol_of_this_slot[slot[i]] = (opcfg & (1 << i)) ? (char)volume : (char)MAX_VOLUME;
      set_the_ksl_in_a_slot(slot[i]);                                   /* send to chip */

           // dp2("set vol op, vol", slot[i], vol_of_this_slot[slot[i]]);
      i ++;                                     // loop 4 times for melodic voices
      } while ((i < 4) && (slot[0] != slot[i]));        // 2 times for base or 2OP drums, else once
}

/* NoteOn(voice, pitch)
 *      set the key-on bit and put it in the chip or set drum-mode-drum bits
 */
void NoteOn(unsigned voice, int pitch)
{
   if (pitch < 0)
      pitch = drum_pitch_array[last_pgm[voice] -DRUM_PATCH_OFFSET];
   pitch -= ( MID_C - CHIP_MID_C);

   if( pitch < 0)
      pitch = 0;

   if (percussion && (voice >= BD))
      {                                                         /* this is a percussive voice */
      if (voice == BD)
           SetFreq(BD, pitch);
      percussion_enable_bits |= percussion_enable_bit_masks[ voice - BD];                       /* OR in the on bit for perc voice */
      send_modulation_params();
      }
   else
      {
      key_on_voice[voice] = 1;
      SetFreq(voice, pitch);
      }
}


/* NoteOff(voice)
 *      clear key-on bit or drum-mode-drum bits
 *
 * 10/10/90 added dummy pitch to be like other synths
 */
void NoteOff(unsigned voice, int pitch)
{
if (percussion && (voice >= BD))
    {
    percussion_enable_bits &= ~percussion_enable_bit_masks[ voice - BD];
    send_modulation_params();
    }
else
    {
    key_on_voice[voice] = 0;                                    /* shut off */
    SetFreq((unsigned) voice, current_voice_pitch[voice]);
    }
}
