/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
//-----=====<<<<< MPGVSD.C >>>>>=====-----
//
//   DESCRIPTION:   MPEG Codec routines for accessing VSD
//
//
//   FUNCTIONS:     vsdInitialization, vsdOpen, vsdRefresh, vsdPassBuffer
//
//
//   HISTORY:  DEVELOPER:     COMMENTS:
//   ========  ==========     ================================================
//   05.10.94  WL Sharp       File Created
//
//-----=====<<<<< MPGDECO.C >>>>>=====-----

#define  INCL_WIN
#define  INCL_GPI
#define  INCL_DOS
#define  INCL_OS2MM
#define  INCL_MMIO_CODEC
#include <os2.h>
#include <string.h>
#include <os2me.h>
#include <hhpheap.h>
#include <cdci.h>
#include <vsdcmds.h>
#include <stdio.h>
#include "mpgdci.h"


#define MAXSTRNLEN 80
LONG lColor= 10;                   /* Index of the key color, init to 10.   */
LONG lVIC   = 0;                   /* Video Input Connector                 */
LONG lVIC_D = 0;                   /* Video Input Connector Default         */
VSD_TRANSPARENTCOLOR_PARMS SETTC;         /* Key color setting structure.   */
VSD_COLORKEYING_PARMS      SETCK;         /* Blast-through setup structure. */
VSD_VIEWPORT_PARMS         SETVP;         /* Enable/Disable video struct.   */
VSD_VIDEORECT_PARMS        vsdRect;       /* Video rectangle set structure. */


ULONG vsdInit (PINSTANCE pInst)

{
   CHAR vsdDevice[MAXSTRNLEN];

   /* Try loading up the .DLL. */
   strcpy( vsdDevice, "VIDVCI" );
   if ( DosLoadModule ( (PSZ) vsdDevice, MAXSTRNLEN, (PSZ) vsdDevice,
         &pInst->hVSD ) )
      return MMIO_ERROR;            /* VUDVCI.DLL not found. */

   /* Load passed, query for the entry point. */
   strcpy( vsdDevice, "VSD_Entry" );
   if (DosQueryProcAddr (pInst->hVSD, 0, (PSZ) vsdDevice, (PFN *) &pInst->pVSDProcI))
      return MMIO_ERROR;            /* Entry point was not found. */

   return MMIO_SUCCESS;
}



ULONG vsdPassBuffer (PINSTANCE pInst, PMMDECOMPRESS pmmDeco, ULONG ulAudioTime, ULONG ulPTS, ULONG ulSCR)

{
   VSD_STREAM_PARMS vsdPlay;

   memset(&vsdPlay, 0, sizeof(VSD_STREAM_PARMS));

   if (!pInst->pVSDProcI)
      return(MMIO_ERROR);

   /* Send the MPEG Movie data to the card */
   vsdPlay.ulLength    = VSD_STREAM_Len;
   vsdPlay.ulFlags     = VSD_NONE;
   vsdPlay.ulSizeData  = pmmDeco->ulSrcBufLen;
   vsdPlay.pData       = (PVOID) pmmDeco->pSrcBuf;
   vsdPlay.ulSCR       = ulSCR;
   vsdPlay.ulPTS       = ulPTS;
   vsdPlay.ulAudioTime = ulAudioTime;


   if (pInst->pVSDProcI ((PVOID) pInst->hVSD, (ULONG) VSD_PLAY,
           (ULONG) VSD_PLAYDATA, (PVOID) &vsdPlay ) != VSDERR_SUCCESS )
   {
#ifdef MMDEBUG
      printf("vsdPassBuffer failed\n");
#endif
      return(MMIO_ERROR);            /* Set video show though on failed. */
   }

   return(MMIO_SUCCESS);
}


ULONG vsdPlayFlush (PINSTANCE pInst, PMMDECOMPRESS pmmDeco)

{
   VSD_STREAM_PARMS vsdPlay;

   memset(&vsdPlay, 0, sizeof(VSD_STREAM_PARMS));

   if (!pInst->pVSDProcI)
      return(MMIO_ERROR);

   /* Send the MPEG Movie data to the card */
   vsdPlay.ulLength    = VSD_STREAM_Len;
   vsdPlay.ulFlags     = VSD_NONE;
   vsdPlay.ulSizeData  = 0;
   vsdPlay.pData       = NULL;

   if (pInst->pVSDProcI ((PVOID) pInst->hVSD, (ULONG) VSD_PLAY,
           (ULONG) VSD_PLAYFLUSH, (PVOID) &vsdPlay ) != VSDERR_SUCCESS )
   {
#ifdef MMDEBUG
      printf("vsdPlayFlush failed\n");
#endif
      return(MMIO_ERROR);            /* Set video show though on failed. */
   }

   return(MMIO_SUCCESS);
}


// ULONG vsdMoveSize (PINSTANCE pInst, PMMVIDEODECOMPRESS pmmVidDeco)
//
// {
//    VSD_VIDEORECT_PARMS  vsdRect;          /* Video rectangle set structure. */
//    ULONG ret;
//
//    if (!pInst->pVSDProcI) {
//       printf("No VSD\n");
//       return(MMIO_ERROR);
//       }
//
//    vsdRect.ulLength            = VSD_VIDEORECT_Len;
//
//    vsdRect.irectSource.X_left    = pmmVidDeco->rectlSrc.xLeft;    // should be 0
//    vsdRect.irectSource.Y_top     = pmmVidDeco->rectlSrc.yBottom;  // should be 0
//    vsdRect.irectSource.X_width   = pmmVidDeco->rectlSrc.xRight -
//                                    pmmVidDeco->rectlSrc.xLeft;
//    vsdRect.irectSource.Y_height  = pmmVidDeco->rectlSrc.yTop -
//                                    pmmVidDeco->rectlSrc.yBottom;
//
//
//    vsdRect.irectDest.X_left    = pmmVidDeco->rectlDst.xLeft;
//    vsdRect.irectDest.Y_top     = 480 - pmmVidDeco->rectlDst.yTop;
//    vsdRect.irectDest.X_width   = pmmVidDeco->rectlDst.xRight -
//                                  pmmVidDeco->rectlDst.xLeft;
//    vsdRect.irectDest.Y_height  = pmmVidDeco->rectlDst.yTop -
//                                  pmmVidDeco->rectlDst.yBottom;
//
// printf("SRC : %d %d %d %d\n",
//    pmmVidDeco->rectlSrc.xLeft,
//    pmmVidDeco->rectlSrc.xRight,
//    pmmVidDeco->rectlSrc.yTop,
//    pmmVidDeco->rectlSrc.yBottom);
//
// printf("DST : %d %d %d %d\n",
//    pmmVidDeco->rectlDst.xLeft,
//    pmmVidDeco->rectlDst.xRight,
//    pmmVidDeco->rectlDst.yTop,
//    pmmVidDeco->rectlDst.yBottom);
//
// printf("vsdSrc : %d %d %d %d\n",
//    vsdRect.irectSource.X_left,
//    vsdRect.irectSource.Y_top,
//    vsdRect.irectSource.X_width,
//    vsdRect.irectSource.Y_height);
//
// printf("vsdDst : %d %d %d %d\n",
//    vsdRect.irectDest.X_left,
//    vsdRect.irectDest.Y_top,
//    vsdRect.irectDest.X_width,
//    vsdRect.irectDest.Y_height);
//
//    if (ret = pInst->pVSDProcI ((PVOID) pInst->hVSD, (ULONG) VSD_SET,
//              (ULONG) VSD_SETVIDEORECT, (PVOID) &vsdRect)) {
//       printf("vsdMoveSize failed : %d\n", ret);
//       return(MMIO_ERROR);
//       }
//
//
//    return(MMIO_SUCCESS);
// }



ULONG vsdStart (PINSTANCE pInst)

{
   VSD_STREAM_PARMS vsdPlay;

   memset(&vsdPlay, 0, sizeof(VSD_STREAM_PARMS));

   if (!pInst->pVSDProcI)
      return(MMIO_ERROR);

   vsdPlay.ulLength    = VSD_STREAM_Len;
   vsdPlay.ulFlags     = VSD_NONE;
   vsdPlay.ulSizeData  = 0;
   vsdPlay.pData       = (PVOID) NULL;
   vsdPlay.ulSCR       = 0;
   vsdPlay.ulPTS       = 0;
   vsdPlay.ulAudioTime = pInst->ulFirstAudioPTS;

   if (pInst->pVSDProcI ( (PVOID) pInst->hVSD, (ULONG) VSD_PLAY,
           (ULONG) VSD_PLAYSTART, (PVOID)&vsdPlay ) != VSDERR_SUCCESS)
      {
#ifdef MMDEBUG
      printf("vsdStart failed\n");
#endif
      return(MMIO_ERROR);
      }

   return(MMIO_SUCCESS);
}



ULONG vsdOpen (PINSTANCE pInst)

{

  // Test Loading microcode on to the device
   ULONG  fsOpenFlag;
   ULONG  fsOpenMode;
   HFILE  hfHandle;
   ULONG  ulAction;
   ULONG  ulRetCode;
   ULONG  ulRC;
   ULONG  ulFileSize;
   ULONG  cbBytesRead;               /* Number of bytes read into buffer  */
   FILESTATUS fstsFile;              /* structure of file information     */
   PSZ    pszBuffer;
   VSD_LOAD_PARMS load;

   CHAR pszBINFile[100];
   PSZ p, pszEnv;


   /* Check to see if we can call to the vsd entry point. */

   if (!pInst->pVSDProcI) {
      return(MMIOERR_INTERNAL_SYSTEM);
      }

   if (!DosScanEnv("MMBASE", &pszEnv)) {
      strcpy(pszBINFile, pszEnv);

      if (p = strchr(pszBINFile, ';')) *p = 0;

      strcat(pszBINFile, "\\DSP\\VREEL.BIN");
      }
   else {
      strcpy(pszBINFile, "C:\\MMOS2\\DSP\\VREEL.BIN");
      }




 // Test Loading microcode on to the device

   fsOpenFlag = (ULONG)OPEN_ACTION_CREATE_IF_NEW |
                (ULONG)OPEN_ACTION_OPEN_IF_EXISTS;

   fsOpenMode = (ULONG)OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE;

   ulRetCode = DosOpen (pszBINFile,                    /* File Name         */
               &hfHandle,                              /* Handle            */
               &ulAction,                              /* Action taken      */
               0L,                                     /* Size if created   */
               0L,                                     /* File Attribute    */
               fsOpenFlag,                             /* Action to take if */
                                                       /*   it exists or not*/
               fsOpenMode,                             /* Mode in which to  */
                                                       /* ...open file      */
               0L);                                    /* Reserved          */


   if (ulRetCode == NO_ERROR) {
      ulRC = DosQueryFileInfo(hfHandle,                /* Get the size of the file     */
                   FIL_STANDARD,
                   (PBYTE)&fstsFile,
                   (ULONG)(sizeof(FILESTATUS)));
      }

   if ((ulRetCode == NO_ERROR) & (ulRC == NO_ERROR)) {

      ulFileSize = fstsFile.cbFile;
      if ((DosAllocMem ( (PVOID *) &pszBuffer,(ULONG) &ulFileSize,
                       PAG_COMMIT | PAG_READ | PAG_WRITE)))
         {
         ulRC = MMIOERR_OUTOFMEMORY;
         }

     if (!ulRC) {
        ulRC = DosRead(hfHandle,              /* Read in the file             */
                      (PVOID)pszBuffer,
                      (ULONG)ulFileSize,
                      (PULONG)&cbBytesRead);

        /* Load the MicroCode on to the card. */
        load.ulLength     = VSD_LOAD_Len;
        load.ulBuff_Size  = ulFileSize;
        load.pBuff        = (PVOID)pszBuffer;
        load.ulLoadID     = 0;

        if ( pInst->pVSDProcI ( (PVOID) pInst->hVSD, (ULONG) VSD_LOAD,
                (ULONG) VSD_NONE, (PVOID) &load ) != VSDERR_SUCCESS ) {
           ulRC = 9;            /* Set video show though on failed. */
           }

        DosFreeMem (pszBuffer);


        }
     }

   DosClose (hfHandle); /* Close the file */

   return ulRC;
}





ULONG vsdClose (PINSTANCE pInst)

{
   /* Check to see if we can call to the vsd entry point. */
   if (!pInst->pVSDProcI)
      return(MMIO_ERROR);

   if (pInst->pVSDProcI ( (PVOID) pInst->hVSD, (ULONG) VSD_CLOSE,
           (ULONG) VSD_NONE, (PVOID) NULL ) != VSDERR_SUCCESS)
      {
#ifdef MMDEBUG
      printf("vsdClose failed\n");
#endif
      return(MMIO_ERROR);
      }

   return(MMIO_SUCCESS);


}
