/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*                                                                          */
/* SOURCE FILE NAME:  MPGDCI.H                                              */
/*                                                                          */
/* DESCRIPTIVE NAME:  MPEG Hardware Codec instance definitions              */
/*                                                                          */
/* STATUS:  MM Release Warp                                                 */
/*                                                                          */
/* FUNCTION: This file defines specific Codec data structures               */
/*                                                                          */
/* DEPENDENCIES:                                                            */
/*                                                                          */
/* Change History:                                                          */
/* Ptm     Date     Pgmr Comments                                           */
/* ======= ======== ===  ================================================== */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/

/* XLATOFF */
#pragma pack(4)
/* XLATON */

/****************************************************************************/
/* take hard coded defines from the makefile these are the only valid flags */
/****************************************************************************/

#define CAPSFLAGS CODEC_DECOMPRESS       + \
                  CODEC_WINDOW_CLIPPING  + \
                  CODEC_PALETTE_TRANS    + \
                  CODEC_SELFHEAL         + \
                  CODEC_SCALE_PEL_DOUBLE + \
                  CODEC_SCALE_PEL_HALVED + \
                  CODEC_SCALE_CONTINUOUS + \
                  CODEC_MULAPERTURE      + \
                  CODEC_4_BIT_COLOR      + \
                  CODEC_8_BIT_COLOR      + \
                  CODEC_16_BIT_COLOR     + \
                  CODEC_24_BIT_COLOR     + \
                  CODEC_HARDWARE         + \
                  CODEC_SYMMETRIC        + \
                  CODEC_ASYMMETRIC       + \
                  CODEC_DIRECT_DISPLAY   + \
                  CODEC_DEFAULT          + \
                  CODEC_ORIGIN_LOWERLEFT + \
                  CODEC_ORIGIN_UPPERLEFT + \
                  CODEC_SET_QUALITY      + \
                  CODEC_DATA_CONSTRAINT  + \
                  CODEC_HW_OVERLAY

/****************************************************************************/
/*                                                                          */
/* ULTIMOTION_INST - Define the photomotion specific decompression instance */
/* not used yet, this is where to put private clipping storage if and when  */
/* required.                                                                */
/*                                                                          */
/****************************************************************************/
typedef struct _codecspec_inst {
   BOOL      fFirstTime;            /* SVGA support flag for multiple aperture decoding */
   PFN       pVSDProcI;             /* Main entry point for the dd commands. */
   ULONG     hVSD;                  /* Handle to the dd for this instance.   */
   ULONG     ulFirstAudioPTS;
   ULONG     ulFlags;
}  INSTANCE;

typedef INSTANCE *PINSTANCE;

#define LOCAL_VSD 0x00000001

/****************************************/
/* define the local function prototypes */
/* specific algorithms                  */
/****************************************/

RC AllocInstData    (PCODEC_INST);
RC DeallocInstData  (PCODEC_INST);
RC DecompressBuffer (PMMDECOMPRESS pmmDeco, PCODEC_INST pcodec_inst);

/* XLATOFF */
#pragma pack()
/* XLATON */
