/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************ START OF SPECIFICATIONS ***************************/
/*                                                                          */
/* SOURCE FILE NAME:  MPGDCDLL.C                                             */
/*                                                                          */
/* DESCRIPTIVE NAME: Ultimotion Decompression Decompressor DLL              */
/*                                                                          */
/*                                                                          */
/* STATUS:  OS/2 Release 2.0                                                */
/*                                                                          */
/* FUNCTION: This source module contains the ring 3 (DLL) entry point for   */
/*    PDM_ messsages as well as Initialization for the DLL                  */
/*                                                                          */
/* NOTES:                                                                   */
/*    DEPENDENCIES: none                                                    */
/*    RESTRICTIONS: Runs in 32 bit protect mode (OS/2 2.0)                  */
/*                                                                          */
/* ENTRY POINTS:                                                            */
/*    AllocInstData                                                         */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*                                                                          */
/* Change History:                                                          */
/* DATE      DEVELOPER         CHANGE DESCRIPTION                           */
/*************************** END OF SPECIFICATIONS **************************/

/* OS/2 INCLUDES */
#define  INCL_WIN
#define  INCL_GPI
#define  INCL_DOSSEMAPHORES
#define  INCL_DOSEXCEPTIONS
#define  INCL_DOSERRORS
#define  INCL_DOSPROCESS
#define  INCL_OS2MM
#define  INCL_MMIO_CODEC
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <os2me.h>
#include <hhpheap.h>
#include <svsh.h>
#include <cdci.h>
#include <ptrace.h>
#include <vsdcmds.h>
#include "mpgdci.h"

/* define external data */
extern ULONG  ulGlobalCapsFlags;

#define MMIO_FLUSH 0x0100

extern ULONG vsdInit       (PINSTANCE pInst);
extern ULONG vsdOpen       (PINSTANCE pInst);
extern ULONG vsdClose      (PINSTANCE pInst);
extern ULONG vsdStart      (PINSTANCE pInst);
extern ULONG vsdRefresh    (PINSTANCE pInst);
extern ULONG vsdMoveSize   (PINSTANCE pInst, PMMVIDEODECOMPRESS pmmVidDeco);
extern ULONG vsdPassBuffer (PINSTANCE pInst, PMMDECOMPRESS pmmDeco, ULONG ulAudioTime, ULONG ulPTS, ULONG ulSCR);
extern ULONG vsdPlayFlush  (PINSTANCE pInst, PMMDECOMPRESS pmmDeco);

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: AllocInstData                                           */
/*                                                                          */
/* DESCRIPTIVE NAME:                                                        */
/*                                                                          */
/* FUNCTION: Allocate instance data pertinant to a particular codec         */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINT: AllocUltimotInst                                            */
/*                                                                          */
/* INPUT:                                                                   */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*              MMIO_SUCCESS                                                */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/* INTERNAL REFERENCES:                                                     */
/*        ROUTINES:                                                         */
/*                                                                          */
/* EXT1ERNAL REFERENCES:                                                    */
/*        ROUTINES:                                                         */
/*        DATA STRUCTURES:                                                  */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/

RC AllocInstData (PCODEC_INST pcodec_inst)
{
   RC                rc = MMIO_SUCCESS;
   PINSTANCE  pInst;
   PULONG pOtherInfo;

//
// Allocate codec specific structure
//

   if (!(pInst = (PINSTANCE) HhpAllocMem (hHeap, sizeof(INSTANCE)))) {
      DeallocInstData (pcodec_inst);
      return(ERROR_ALLOC_RESOURCES);
      }

   memset(pInst, 0, sizeof(INSTANCE));

   /*************************************************/
   /* Return address of the allocated instance to   */
   /* caller                                        */
   /*************************************************/
   pcodec_inst->pCodecPlugInstData = pInst;


//
// set FirstTime flag so that the VSD is started on the first decompress call
//

   pInst->fFirstTime = TRUE;

#ifndef NOVSD

   pOtherInfo = (PULONG) pcodec_inst->pe_movie_inst->codecopen.pOtherInfo;

   if ((!pOtherInfo) || (!pOtherInfo[0])) {
      pInst->pVSDProcI  = 0;
      pInst->hVSD       = 0;
      pInst->ulFirstAudioPTS = 0;
      }
   else {
      pInst->pVSDProcI       = (PFN)   pOtherInfo[1];
      pInst->hVSD            = (ULONG) pOtherInfo[2];
      pInst->ulFirstAudioPTS = (ULONG) pOtherInfo[3];
      }

   if (!pInst->pVSDProcI) { // if VSD address not passed in, open it ourselves
      pInst->ulFlags |= LOCAL_VSD;
      vsdInit(pInst);
      }

   vsdOpen(pInst);
#endif

   return rc;
}

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: DeallocUltimotInst                                      */
/*                                                                          */
/* DESCRIPTIVE NAME:                                                        */
/*                                                                          */
/* FUNCTION: Cleans up non ultimotion instance data                         */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINT: Cleanup                                                     */
/*   LINKAGE:   CALL FAR (00:32)                                            */
/*                                                                          */
/* INPUT:                                                                   */
/*       PCHGPAL pchgpalInfo                                                */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*              NO_ERROR                                                    */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*              MMIOERR_UNSUPPORTED_MESSAGE                                 */
/*              Message specific error                                      */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/

RC DeallocInstData (PCODEC_INST pcodec_inst)

{
   RC               rc = NO_ERROR;
   PINSTANCE pInst =  pcodec_inst->pCodecPlugInstData;

#ifndef NOVSD
   if (pInst->ulFlags & LOCAL_VSD) {
      vsdClose(pInst);
      }
#endif

   if (pInst) /* need to deallocate if present */
   {
      /*********************************/
      /* deallocate the Instance block */
      /*********************************/
      HhpFreeMem (hHeap, pInst);
   }
   /**************************************************/
   /* finally null the instance data pointer         */
   /**************************************************/
   pcodec_inst->pCodecPlugInstData = NULL;


   return rc;
}

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: DecompressBuffer                                        */
/*                                                                          */
/* DESCRIPTIVE NAME:                                                        */
/*                                                                          */
/* FUNCTION: Pluggable Codec Entrypoint                                     */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINT: CodecEntry                                                  */
/*                                                                          */
/* INPUT: PMMDECOMPRESS pmmvideodecompress                                  */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*              MMIO_SUCCESS                                                */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/* INTERNAL REFERENCES:                                                     */
/*        ROUTINES:                                                         */
/*                                                                          */
/* EXT1ERNAL REFERENCES:                                                    */
/*        ROUTINES:                                                         */
/*        DATA STRUCTURES:                                                  */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/

RC DecompressBuffer (PMMDECOMPRESS pmmDeco, PCODEC_INST pcodec_inst)

{
   RC                   rc = MMIO_SUCCESS;
   PMMVIDEODECOMPRESS   pmmVidDeco;
   PINSTANCE            pInst;
   PCODECOPEN           pcodecopen;
   PBYTE                pbRawSrc;
   ULONG                ulRowsToDecode;

#ifdef MMDEBUG
   CHAR          pszBuffer[256];
   ULONG         ulBufWritten;
#endif

  /***************************************************/
  /* Check for NULL parameters and extract runtime   */
  /* pmmvideodecompress structure                    */
  /***************************************************/
   if (pmmDeco && pcodec_inst)
   { /* check videodecompress parameter */
      if (pmmVidDeco = (PMMVIDEODECOMPRESS)pmmDeco->pRunTimeInfo)
      {

         pInst = (PINSTANCE)pcodec_inst->pCodecPlugInstData;
        /**********************************************/
        /* extract the open static data that          */
        /* accompanied the codec open                 */
        /**********************************************/
         pcodecopen = &pcodec_inst->pe_movie_inst->codecopen;

         if (pInst->fFirstTime) { // start playing movie

#ifndef NOVSD
            vsdStart (pInst);
#endif

            pInst->fFirstTime = FALSE;
            }

//        /**********************************************/
//        /* Check for the presence of an in-stream     */
//        /* palette or a system palette change,        */
//        /* I assume that this is stored in the        */
//        /* genpalPhysical and genpalVideo. The        */
//        /* pSrcBuf still contains the next frame.     */
//        /* only call if there is a palette handler    */
//        /**********************************************/
//         if (pmmDeco->ulFlags & MMIO_PALETTE_CHANGE)
//         {
//
// call Ken with new palette
//         }
//
//        /**********************************************/
//        /* may have to change the direction or update */
//        /* the clipping flags if supported            */
//        /**********************************************/
//         if (pmmDeco->ulFlags & MMIO_RECTL_CHANGE)
//         {
//            pmmDeco->ulFlags &= ~MMIO_RECTL_CHANGE;
//
// move and size window - handled in MCD
//
//#ifndef NOVSD
//         vsdMoveSize (pInst, pmmVidDeco);
//#endif
//
//         }

       if (pmmDeco->ulFlags == MMIO_FLUSH) {
          pmmDeco->ulFlags &= ~MMIO_FLUSH;
          vsdPlayFlush(pInst, pmmDeco);
          pInst->fFirstTime = TRUE;
          }

// pass buffer to Ken

      else {
         vsdPassBuffer (pInst, pmmDeco, pmmVidDeco->ulParm1, pmmVidDeco->ulParm2, pmmVidDeco->ulParm3);
#ifdef MMDEBUG
      sprintf(pszBuffer, "PTS, %8u 0x%08x | ", pmmVidDeco->ulParm2, pmmVidDeco->ulParm2);
      DosWrite(1, pszBuffer, strlen(pszBuffer), &ulBufWritten);
      sprintf(pszBuffer, "SCR  %8u 0x%08x | ", pmmVidDeco->ulParm3, pmmVidDeco->ulParm3);
      DosWrite(1, pszBuffer, strlen(pszBuffer), &ulBufWritten);

      sprintf(pszBuffer, "AUD  %8d\r\n", pmmVidDeco->ulParm1);
      DosWrite(1, pszBuffer, strlen(pszBuffer), &ulBufWritten);
#endif
         }


// clear flags

         pmmDeco->pSrcBuf = 0;
         pmmDeco->ulSrcBufLen = 0;


      }
      else /* parameter problem */
      {
         rc = MMIOERR_INVALID_PARAMETER;
      }
   }
   else /* null lparm1 field */
   {
      rc = MMIOERR_INVALID_PARAMETER;
   }
   return rc;
}


