/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************ START OF SPECIFICATIONS ***************************/
/*                                                                          */
/* SOURCE FILE NAME:  MPDCGDAT.C                                            */
/*                                                                          */
/* DESCRIPTIVE NAME: MPEG Decompression Decompressor DLL                    */
/*                                                                          */
/*                                                                          */
/* STATUS:  OS/2 Release 2.0                                                */
/*                                                                          */
/* FUNCTION: this file contains the global data definitions                 */
/*                                                                          */
/* NOTES:                                                                   */
/*    DEPENDENCIES: none                                                    */
/*    RESTRICTIONS: Runs in 32 bit protect mode (OS/2 2.0)                  */
/*                                                                          */
/* ENTRY POINTS:                                                            */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
/* OS/2 INCLUDES */
#define  INCL_WIN
#define  INCL_GPI
#define  INCL_OS2MM
#define  INCL_MMIO_CODEC
#define  INCL_DOSSEMAPHORES
#define  INCL_DOSPROCESS
#include <os2.h>
#include <os2me.h>
#include <hhpheap.h>
#include <svsh.h>
#include <cdci.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <memory.h>
#include <ioprnls.h>
#include "mpgdci.h"            // private defines for CODEC
#include "mpgdcnls.h"

/********************************************************************/
/*  DLL Global data - one copy in memory shared by all processes    */
/*                                                                  */
/*  NOTE - for some reason the compiler requires these global data  */
/*         variables to be inititialized or they will NOT be placed */
/*         in the shared segment.                                   */
/********************************************************************/
#pragma data_seg (CDC_SEG)    // Put this into a seperate data seg

CODECFNS codecfns = {
   (PFN)AllocInstData,        // pfnAllocInstData
   (PFN)DeallocInstData,      // pfnDellocInstData
   (PFN)NULL,                 // pfnPaletteHandler
   (PFN)NULL,         // pfnClipHandler
   (PFN)DecompressBuffer,     // pfnDecompressBuffer
   (PFN)NULL,                 // pfnCompressBuffer
// (PFN)QryNameLength,        // pfnQryNameLength
// (PFN)QryNameString,        // pfnQryNameString
};

ULONG ulGlobalCapsFlags = CAPSFLAGS; // mandatory capability flags CODEC_xxx
ULONG ProcNameID= MPGDC_FORMATNAMEKEY;
#pragma data_seg ()


/********************************************************************/
/*  DLL Global Process Instance Data - one copy per instance        */
/********************************************************************/
HMTX           hmtxGlobalData= 0;      // Critical section semaphore
HHUGEHEAP      hHeap = (ULONG)NULL;    // Heap handle foe allocation/Deallocatin of memory
PE_MOVIE_INST  Movie_Inst_Anchor = (PE_MOVIE_INST)NULL; /* must initialize to null */
