/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************ START OF SPECIFICATIONS ***************************/
/*                                                                          */
/* SOURCE FILE NAME:  CDCSRV.C                                              */
/*                                                                          */
/* DESCRIPTIVE NAME: Codec general services                                 */
/*                                                                          */
/* COPYRIGHT:                                                               */
/*                                                                          */
/* STATUS:  OS/2 Release 2.1                                                */
/*                                                                          */
/* FUNCTION:                                                                */
/*                                                                          */
/* NOTES:                                                                   */
/*    DEPENDENCIES: none                                                    */
/*    RESTRICTIONS: Runs in 32 bit protect mode (OS/2 2.1)                  */
/*                                                                          */
/* ENTRY POINTS:                                                            */
/*    RemoveCodecChainLink                                                  */
/*    QryNameLength                                                         */
/*    QryNameString                                                         */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*    ProcNameID must be defined in the codec global data as                */
/*    the ID in the national language support resource file.                */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
/* OS/2 INCLUDES */
#define  INCL_WIN
#define  INCL_GPI
#define  INCL_DOSSEMAPHORES
#define  INCL_DOSEXCEPTIONS            /* For exception handler */
#define  INCL_DOSERRORS
#define  INCL_DOSPROCESS
#define  INCL_OS2MM
#define  INCL_MMIO_CODEC
#include <os2.h>
#include <os2me.h>
#include <hhpheap.h>
#include <svsh.h>
#include <cdci.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <memory.h>
#include <ioprnls.h>                   /* National Language Support */

extern ProcNameID;


/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: RemoveCodecChainLink                                    */
/*                                                                          */
/* DESCRIPTIVE NAME: Removes a hCodec Link from the linked list             */
/*                                                                          */
/* FUNCTION: Removes a hCodec Link from the linked list of codecs that are  */
/*           loaded for a particular movie file format                      */
/*           code is called by the CodecClose code                          */
/*                                                                          */
/* NOTES: pPlugInstData has already been deallocated from the hCodec        */
/*        allowing this structure to be deallocated from the heap           */
/*                                                                          */
/* ENTRY POINT: RemoveCodecChainLink                                        */
/*   LINKAGE:   CALL FAR (00:32)                                            */
/*                                                                          */
/* INPUT:                                                                   */
/*       PCODEC_INST                                                        */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*              MMIO_SUCCESS                                                */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*              MMIO_WARNING                                                */
/*           or MMIO_ERROR                                                  */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
RC RemoveCodecChainLink ( PCODEC_INST pcodec_key )
{
   RC              rc = MMIO_SUCCESS;
   PCODEC_INST     pcodec_inst;     /* codec_inst chain pointer */
   PCODEC_INST     pcodec_temp;     /* linked list codec_inst temp chain ptr */
   BOOL            fFound;          /* used to indicate if link found */
   PE_MOVIE_INST   pe_movie_inst;   /* pointer to the sghared movie data */

  /**************************************************************/
  /* get the shared data, search for a match and if found repair*/
  /* the chain                                                  */
  /**************************************************************/
   if (pcodec_key) /* null? */
   {
      if (pe_movie_inst = pcodec_key->pe_movie_inst) /* null? */
      {
         if (pe_movie_inst->pCodecInstAnchor) /* check for non null anchor */
         {
            if (pcodec_key == pe_movie_inst->pCodecInstAnchor)
            {
               pcodec_temp = ((PCODEC_INST)(pe_movie_inst->pCodecInstAnchor))->pNextCodecInst;
               pe_movie_inst->pCodecInstAnchor = pcodec_temp;  /* could be NULL */
            }
            else /* this is not the first element in the chain */
            {
               for ( pcodec_inst = pe_movie_inst->pCodecInstAnchor, fFound = FALSE;
                     pcodec_inst->pNextCodecInst && !fFound; /* guaranteed true first time around */
                     pcodec_inst = pcodec_inst->pNextCodecInst )
               {
                  if (pcodec_inst->pNextCodecInst == pcodec_key)
                  {
                     pcodec_temp = pcodec_inst->pNextCodecInst->pNextCodecInst; /* NULL if the end of the Chain */
                     HhpFreeMem (hHeap, pcodec_inst->pNextCodecInst); /* this is guaranteed non Null */
                     pcodec_inst->pNextCodecInst = pcodec_temp;
                     fFound = TRUE;
                  }
               }
               if (!fFound)
               {
                  rc = MMIO_WARNING; /* indicate that nothing deallocated */
               }
            }
         }
         else /* check for null anchor */
         {
            rc = MMIO_ERROR; /* indicate that nothing deallocated */
         }
      }
   }
   return (rc);
}


/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: QryNameLength                                           */
/*                                                                          */
/* DESCRIPTIVE NAME: Query the length of the ASCIIZ name of the CODEC.      */
/*                                                                          */
/* FUNCTION: Query the length of the ASCIIZ name of the CODEC.              */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINT: QryNameLength                                               */
/*   LINKAGE:   CALL FAR (00:32)                                            */
/*                                                                          */
/* INPUT:                                                                   */
/*       PPCODEC_INST  ppcodec_inst                                         */
/*       WORD          wMessage                                             */
/*       PULONG        pulLength                                            */
/*       LONG          lParam2                                              */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*              MMIO_SUCCESS                                                */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*              MMIO_ERROR                                                  */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
RC QryNameLength           ( PVOID   ppcodec_inst,
                             WORD    wMessage,
                             PULONG  pulLength,
                             LONG    lParam2 )
{
// *pulLength = IOPRNLS_GetFormatString ( ProcNameID, NULL, 0L );
// if ( *pulLength )
//    return ( MMIO_SUCCESS );
// else
//    return ( MMIO_ERROR );
}


/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: QryNameString                                           */
/*                                                                          */
/* DESCRIPTIVE NAME: Query the name of the CODEC                            */
/*                                                                          */
/* FUNCTION: Returns a pointer to the ASCIIZ name of the CODEC.             */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINT: QryNameString                                               */
/*   LINKAGE:   CALL FAR (00:32)                                            */
/*                                                                          */
/* INPUT:                                                                   */
/*       PPCODEC_INST  ppcodec_inst                                         */
/*       WORD          wMessage                                             */
/*       PULONG        pulLength                                            */
/*       LONG          lParam2                                              */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*              MMIO_SUCCESS                                                */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*              MMIO_ERROR                                                  */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
RC QryNameString           ( PVOID  ppcodec_inst,
                             WORD   wMessage,
                             PSZ    pszCODECNameNew,
                             PULONG pulLength )
{
// *pulLength = IOPRNLS_GetFormatString ( ProcNameID,
//                                        pszCODECNameNew,
//                                        *pulLength );
// if ( *pulLength )
//    return ( MMIO_SUCCESS );
// else
//    return ( MMIO_ERROR );
}

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: CalcClippingMask                                        */
/*                                                                          */
/* DESCRIPTIVE NAME:                                                        */
/*                                                                          */
/* FUNCTION:                                                                */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/*   This sample code shows an example of how a region to clipping mask can */
/*   be generated.  All rectangles considered here are PM stype Incluseve   */
/*   bottom left and Exclusive top right reectangles.  This means that the  */
/*   lower left pixel is included in the rectangle while the top and right  */
/*   edges are not.  The width of such a rectangle is always                */
/*   xRight-xLeft.  The height is yTop - yBottom.                           */
/*                                                                          */
/*   The algorithm contains an input mask pointer.  This buffer must be     */
/*   and stored within the codec's process instance data (not in a shared)  */
/*   segment as it would be trached by another process using this DLL       */
/*                                                                          */
/*   The algorithm assumes that the first element in the pbClipMask corre-  */
/*   sopnds to the top left pixel of the destination rectangle              */
/*   as the rectangles come in in Top Left top bottom right order           */
/*                                                                          */
/* ENTRY POINT: CalcClippingMask                                            */
/*   LINKAGE:                                                               */
/*                                                                          */
/* INPUT:                                                                   */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/* INTERNAL REFERENCES:                                                     */
/*        ROUTINES:                                                         */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*        ROUTINES:                                                         */
/*        DATA STRUCTURES:                                                  */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
RC CalcClippingMask ( ULONG            ulNumValidRects,
                      PRECTL           prectlArray,
                      PRECTL           prectlSrc,
                      RECTL            rectlDst,
                      ULONG            ulBlockLength,       /* total length of the bitmask */
                      PBYTE            pbClipMask,          /* pointer to the clip mask */
                      ULONG            ulBlockWidth,        /* horizontal clipping granularity */
                      ULONG            ulBlockHeight,       /* vertical clipping granularity */
                      ULONG            ulMaskLength,        /* mask length of allocated buffer */
                      ULONG            ulMaskWidth)         /* greater than a scanblock's worth of data */
{
   RC       rc = NO_ERROR;
   ULONG    ulVisRectWidth;
   ULONG    ulVisRectHeight;
   ULONG    ulVisRectFromLHEdge;
   ULONG    ulVisRectFromTop;
   ULONG    ulModVal1;
   ULONG    ulModVal2;
   ULONG    ulXindex;
   ULONG    ulYindex;
   ULONG    ulRectlIndex;
   PRECTL   prectl;
   PBYTE    pbMask;
   PBYTE    pbLastMaskStart;

  /*****************************************************/
  /* the array of visable rectangles is relative to    */
  /* the destination rectangle located at 0,0 width    */
  /* height, so temporarily manipulate the value       */
  /* on the stack                                      */
  /*****************************************************/
   rectlDst.xRight -= rectlDst.xLeft;
   rectlDst.xLeft   = 0;
   rectlDst.yTop   -= rectlDst.yBottom;
   rectlDst.yBottom = 0;

  /*****************************************************/
  /* fully cover the mask as there is no way of finding*/
  /* delta information from last clip info to the this */
  /* latest clip rectangles                            */
  /* this example shows where the mask is byte oriented*/
  /*****************************************************/
   for ( ulXindex = 0, pbMask = pbClipMask;
         ulXindex < ulMaskLength;
         ulXindex++ )
   {
      *pbMask++ = CLIPPED;
   }

  /*****************************************************/
  /* reset the portions that are uncovered             */
  /* all of the assumptions assume that PM has xLeft   */
  /* less than xRight and yTop > yBottom for each rect */
  /* note that all visable rectangles are WRT the dst  */
  /* with the origin at the bottom LHS                 */
  /*****************************************************/
   for ( ulRectlIndex=0, prectl = prectlArray;
         ulRectlIndex < ulNumValidRects;
         ulRectlIndex++, prectl++ )
   {
     /**************************************************/
     /* calculate offsets into the mask in block units */
     /* rectangles come in from PM in largest horiz    */
     /* units??                                        */
     /**************************************************/

      ulVisRectFromTop     =  (prectl->yTop - rectlDst.yTop) /
                              ulBlockHeight;  /* this rect is mapped to the origin */

      ulModVal1            =  (prectl->yTop - rectlDst.yTop) %
                              ulBlockHeight;  /* block granular clipping */

      ulVisRectFromLHEdge  = (prectl->xLeft - rectlDst.xLeft)  /
                              ulBlockWidth; /* exclusive rects */

      ulModVal2            = (prectl->xLeft - rectlDst.xLeft)  %
                              ulBlockWidth;

     /**************************************************/
     /* the ulVisRectWidth and ulvisRectlHeight are    */
     /* used for horiz and vert loop counters for      */
     /* unclipping the rectl areas within the clipping */
     /* bitmask, the module values are used            */
     /* to calculate an undersided area to show the    */
     /* video is the block size > 1 as we cannot oblit */
     /* any visable regions on the desktop             */
     /**************************************************/
      ulVisRectWidth  = (prectl->xRight - prectl->xLeft   - ulModVal2 ) / ulBlockWidth;
      ulVisRectHeight = (prectl->yTop   - prectl->yBottom - ulModVal1 ) / ulBlockHeight;

     /**************************************************/
     /* note the extra column and line used here this  */
     /* ins used for performance reasons in the decode */
     /* as the CL register is ised as an index         */
     /* see decoder for details                        */
     /**************************************************/
      pbLastMaskStart     = (PBYTE)(((ulVisRectFromTop) *
                                    ulMaskWidth) +
                                    (ULONG)(pbClipMask) +
                                    ulVisRectFromLHEdge +
                                    1);   /* Offset of 1 */

     /**************************************************/
     /* fill the clipped rectangular area with a non 0 */
     /* clipping pattern                               */
     /**************************************************/
      for ( ulYindex = 0;
            ulYindex < ulVisRectHeight;
            ulYindex++, pbLastMaskStart += ulMaskWidth )
      {
         for ( ulXindex = 0, pbMask = pbLastMaskStart;
               ulXindex < ulVisRectWidth;
               ulXindex++ )
         {
            *pbMask++ = UNCLIPPED; /* clipped mask value */
         }
      }
   }
   return rc;
}
