/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************ START OF SPECIFICATIONS ***************************/
/*                                                                          */
/* SOURCE FILE NAME:  CDCPAL.C                                              */
/*                                                                          */
/* DESCRIPTIVE NAME: Codec Palette Services                                 */
/*                                                                          */
/*                                                                          */
/* STATUS:  OS/2 Release 2.0                                                */
/*                                                                          */
/* FUNCTION:                                                                */
/*                                                                          */
/* NOTES:                                                                   */
/*    DEPENDENCIES: none                                                    */
/*    RESTRICTIONS: Runs in 32 bit protect mode (OS/2 2.0)                  */
/*                                                                          */
/* ENTRY POINTS:                                                            */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*                                                                          */
/* Change History:                                                          */
/* DATE      DEVELOPER         CHANGE DESCRIPTION                           */
/* 09/12/92  John Coffey       created                                      */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
/* OS/2 INCLUDES */
#define  INCL_WIN
#define  INCL_GPI
#define  INCL_DOSSEMAPHORES
#define  INCL_DOSEXCEPTIONS            /* For exception handler */
#define  INCL_DOSERRORS
#define  INCL_DOSPROCESS
#define  INCL_OS2MM
#define  INCL_MMIO_CODEC
#include <os2.h>
#include <os2me.h>
#include <hhpheap.h>
#include <svsh.h>
#include <cdci.h>

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: CheckPalettes                                           */
/*                                                                          */
/* DESCRIPTIVE NAME:                                                        */
/*                                                                          */
/* FUNCTION: check for Asynchronous palettes                                */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINT:                                                             */
/*                                                                          */
/* INPUT:                                                                   */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*             MMIO_SUCCESS                                                 */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*             MMIO_ERROR                                                   */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/* INTERNAL REFERENCES:                                                     */
/*        ROUTINES:                                                         */
/*                                                                          */
/* EXT1ERNAL REFERENCES:                                                    */
/*        ROUTINES:                                                         */
/*        DATA STRUCTURES:                                                  */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/

RC CheckPalettes (PCODEC_INST pcodec_inst, PMMVIDEODECOMPRESS pmmvideodecompress, PFNPLT pfnCallbackPalette)
{
   RC rc = MMIO_SUCCESS;
   PE_MOVIE_INST pe_movie_inst = (PE_MOVIE_INST)pcodec_inst->pe_movie_inst;

  /**************************************************************************/
  /* Check for the presence of an In-Stream palette if one is present       */
  /* recalculate the XLAT table, also check that a fn exists, NULL callback */
  /* if this feature unsupported                                            */
  /**************************************************************************/

   if (pfnCallbackPalette)
   {
     /***********************************************************************/
     /* the palette has changed so call back to the caller's palette Xlat   */
     /* calculator                                                          */
     /***********************************************************************/
      rc = pfnCallbackPalette ( &pmmvideodecompress->genpalVideo,
                                &pmmvideodecompress->genpalPhysical,
                                pcodec_inst->pCodecPlugInstData);
   }
   return rc;
}

