/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************ START OF SPECIFICATIONS ***************************/
/*                                                                          */
/* SOURCE FILE NAME:  CDCOPEN.C                                             */
/*                                                                          */
/* DESCRIPTIVE NAME: Open codec processing                                  */
/*                                                                          */
/* COPYRIGHT:                                                               */
/*                                                                          */
/* STATUS:  OS/2 Release 2.1                                                */
/*                                                                          */
/* FUNCTION:                                                                */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/*    DEPENDENCIES: none                                                    */
/*    RESTRICTIONS: Runs in 32 bit protect mode (OS/2 2.1)                  */
/*                                                                          */
/* ENTRY POINTS:                                                            */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*                                                                          */
/*    Function entry points defined in codec global data area.  These       */
/*    functions are defined in a CODECFNS structure that is externed in     */
/*    CDCI.H. Each codec must name this as 'codecfns' for the linker        */
/*    to resolve the external reference                                     */
/*                                                                          */
/*    Each Codec must also define 'ulGlobalCapsFlags' in its global data.   */
/*    This ULONG contains the CODEC_xxx capabilities bits that correctly    */
/*    describe that codec's capabilities, ie record, playback scaling etc.  */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
/* OS/2 INCLUDES */
#define  INCL_WIN
#define  INCL_GPI
#define  INCL_DOSSEMAPHORES
#define  INCL_DOSEXCEPTIONS
#define  INCL_DOSERRORS
#define  INCL_DOSPROCESS
#define  INCL_OS2MM
#define  INCL_MMIO_CODEC
#include <os2.h>
#include <os2me.h>
#include <hhpheap.h>
#include <memory.h>
#include <svsh.h>
#include <cdci.h>

extern ULONG ulGlobalCapsFlags; /* see above note on external references */

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: OpenCodec                                               */
/*                                                                          */
/* DESCRIPTIVE NAME:                                                        */
/*                                                                          */
/* FUNCTION: Initializes Codec                                              */
/*                                                                          */
/* NOTES:                                                                   */
/*   this function does a validity check on the capability flags passed     */
/*   from mmio to those of the codec.                                       */
/*   If the validuity check passes the codec initializes shared instance    */
/*   data and calls the codec specific initilization function.  This funct  */
/*   returns with a pointer to its private data storage and this is stored  */
/*   in the CODEC_INST chain that is attached to the shared instance data   */
/*                                                                          */
/* ENTRY POINT: OpenCodec                                                   */
/*                                                                          */
/* INPUTS:                                                                  */
/*        PCODEC_INST *ppcodec_inst                                         */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/* INTERNAL REFERENCES:                                                     */
/*        ROUTINES:                                                         */
/*                                                                          */
/* EXT1ERNAL REFERENCES:                                                    */
/*        ROUTINES:                                                         */
/*        DATA STRUCTURES:                                                  */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/

RC OpenCodec (PCODEC_INST *ppcodec_inst, PCODECOPEN pcodecopen)
{
   RC                rc = MMIO_SUCCESS;
   PE_MOVIE_INST     pe_movie_inst;    /* shared codec data area pointer   */
   PCODEC_INST       pcodec_inst;      /* codec specific instance dats ptr */

   ENTERCRITX(rc); /* crit sect req's as playing around winth linked lists */

  /*********************************************************/
  /* validate the codec open flags,  These indicate the    */
  /* consistency between the current codec and the IO      */
  /* proc that issued the open call,   if any flags        */
  /* besides the ulGlobalCapsFlags are set then ERROR      */
  /*********************************************************/
   if (!(pcodecopen->ulFlags & (~ulGlobalCapsFlags)))
   {
     /******************************************************/
     /* The ppcodec_inst on input is either a pointer to a */
     /* previously allocated hcodec or it is null.  If it  */
     /* is null the codecopen is being called for the      */
     /* first time and the pe_movie_inst  shared date      */
     /* block needs to be allocated.                       */
     /*                                                    */
     /* If on the other hand the hcodec is non null the    */
     /* shared pe_movie_inst has already been allocated    */
     /* and needs to be extracted from the pcodec_inst     */
     /******************************************************/
      if (!(*ppcodec_inst))
      {
        /***************************************************/
        /* Null pointer => this is a new movie instance  so*/
        /* alloc resources and add to beginning of the     */
        /* list chain. and also add the movie instance to  */
        /* its linked list chain                           */
        /***************************************************/
         if (pe_movie_inst = (PE_MOVIE_INST) HhpAllocMem (hHeap,
                                             sizeof(E_MOVIE_INST)))
         {
           /************************************************/
           /* store the shared instance data and open parms*/
           /* also copy the allocated pointer field        */
           /* containing codec specific info               */
           /************************************************/
            pe_movie_inst->codecopen  = *pcodecopen;

           /************************************************/
           /* need to store source header?                 */
           /************************************************/
            if (pcodecopen->pSrcHdr)
            {
               if (pe_movie_inst->codecopen.pSrcHdr = (PVOID) HhpAllocMem (hHeap,
                                                      sizeof (CODECVIDEOHEADER)))
               {
                  memcpy (pe_movie_inst->codecopen.pSrcHdr,
                          pcodecopen->pSrcHdr,
                          sizeof (CODECVIDEOHEADER));
               }
               else 
               {
                  rc = MMIOERR_OUTOFMEMORY;
               }
            }

           /************************************************/
           /* need to store destination header?            */
           /* extract the structure length                 */
           /************************************************/
            if (pcodecopen->pDstHdr && !rc)
            {
               if (pe_movie_inst->codecopen.pDstHdr = (PVOID) HhpAllocMem (hHeap,
                                                      ((PQUERYLEN)(pcodecopen->pDstHdr))->ulStructLen))
               {
                  memcpy (pe_movie_inst->codecopen.pDstHdr,
                        pcodecopen->pDstHdr,
                        ((PQUERYLEN)(pcodecopen->pDstHdr))->ulStructLen);
               }
               else 
               {
                  rc = MMIOERR_OUTOFMEMORY;
               }
            }

           /************************************************/
           /* Optionally this field may have data so       */
           /* allocate and copy it                         */
           /************************************************/
            if (pcodecopen->pOtherInfo && !rc)
            {
               if (pe_movie_inst->codecopen.pOtherInfo = (PVOID) HhpAllocMem (hHeap,
                                                         ((PQUERYLEN)(pcodecopen->pOtherInfo))->ulStructLen))
               {
                  memcpy (pe_movie_inst->codecopen.pOtherInfo,
                        pcodecopen->pOtherInfo,
                        ((PQUERYLEN)(pcodecopen->pOtherInfo))->ulStructLen);
               }
               else
               {
                  rc = MMIOERR_OUTOFMEMORY;
               }
            }
            pe_movie_inst->ulNumCodecs  = 0;
         }
         else
         {
            rc = MMIOERR_OUTOFMEMORY;
         }
      }
      else /* fetch previously allocated one and check for null */
      {
         if (!(pe_movie_inst = (*ppcodec_inst)->pe_movie_inst))
         {
            rc= MMIOERR_OUTOFMEMORY;
         }
      }

     /******************************************************/
     /* allocate a codec instance structure and add it to  */
     /* the linked list, at this stage pe_movie inst points*/
     /* to the shared instance data area containing valid  */
     /* open data                                          */
     /******************************************************/
      if (!rc) /* check for errors so far */
      {
        /***************************************************/
        /* allocate codec instance data struct             */
        /***************************************************/
         if (pcodec_inst = (PCODEC_INST) HhpAllocMem (hHeap,
                                         sizeof(CODEC_INST)))
         { /* fill in pointer to (checked) shared data */
            pcodec_inst->pe_movie_inst = pe_movie_inst;

            if (codecfns.pfnAllocInstData)
            {
              /*********************************************/
              /* call the codec specific allocation routine*/
              /* note that the allocation code can find all*/
              /* necessary information in the pcodec_inst->*/
              /* pe_movie_inst->codecopen.  The allocated  */
              /* data is stored in pe_movie_inst->pPlug..  */
              /* if the call succeded this is the hCodec   */
              /* that the IO proc refers to.               */
              /*********************************************/
               if (!(rc = codecfns.pfnAllocInstData (pcodec_inst)))
               {
                 /******************************************/
                 /* attach the codec inst to the anchor pt */
                 /* as instance data correctly allocated   */
                 /******************************************/
                  pe_movie_inst->ulNumCodecs++;
                  pcodec_inst->pNextCodecInst      = pe_movie_inst->pCodecInstAnchor;
                  pe_movie_inst->pCodecInstAnchor  = (PVOID)pcodec_inst; 
               }
            }
         }
         else /* error allocating codec instance data */
         {
            rc = MMIOERR_OUTOFMEMORY;
         }
      }

     /******************************************************/
     /* insert code here to deal with the MIPS             */
     /* finally return codec instance data pointer to      */
     /* FFIO proc.  The FFIO proc calls this a hCodec      */
     /******************************************************/
      if (!rc)
      {
         *ppcodec_inst = pcodec_inst;   /* FFIO stores this as ULONG */
      }

     /******************************************************/
     /* in the case of an allocation error the FFIO proc   */
     /* must send the MMIOM_CODEC_CLOSE message to the     */
     /* codec proc for each of the codec's for that movie  */
     /* as the deallocation functions are not known here   */
     /******************************************************/
   }
   else /* invalid open flags sent down so return an error */
   {
      rc = MMIO_ERROR;
   } /* endif */

   EXITCRIT;
   return rc;
}


