/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*************************START OF SPECIFICATIONS *************************/
/* SOURCE FILE NAME:  CDCINIT.C                                           */
/*                                                                        */
/* DESCRIPTIVE NAME: Codec Proc Proc DLL Init/Term                        */
/*                                                                        */
/*                                                                        */
/* STATUS: OS/2 Release 2.0                                               */
/*                                                                        */
/*                                                                        */
/* MODIFICATION HISTORY:                                                  */
/* DATE      DEVELOPER         CHANGE DESCRIPTION                         */
/* 02/14/93  John Coffey       File created                               */
/************************* END OF SPECIFICATIONS **************************/

#ifdef MMRAS
#define MMRAS_PTRACE
#endif
#ifdef PTRACE
#define MMRAS_PTRACE
#endif

#include  <stdio.h>
#define   INCL_32                        /* Set include file levels.  */
#define   INCL_DOS                       /* #define  INCL_DOSPROCESS. */
#define   INCL_ERRORS
#define   INCL_WIN
#define   INCL_GPI
#include  <os2.h>                        /* OS/2 headers.             */
#include  <pmbitmap.h>

#define   INCL_OS2MM
#define   INCL_MMIO_CODEC
#define   INCL_MMIO_DOSIOPROC
#include  <os2me.h>                      /* Multi-Media IO extensions.*/
#include  <hhpheap.h>
#include  <cdci.h>

#ifdef MMRAS_PTRACE
#include <ptrace.h>
#endif

#define   DLLINITTERM_SUCCESS  1L        /* reverse logic for the return codes */
#define   DLLINITTERM_FAILURE  0L        /* reverse logic for the return codes */

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: _DLL_InitTerm                                           */
/*                                                                          */
/* DESCRIPTIVE NAME: DLL initialization/Termination routine                 */
/*                                                                          */
/* FUNCTION: This function is executed by OS/2 at DLL load time and DLL     */
/*           unload time.                                                   */
/*                                                                          */
/* NOTES: None                                                              */
/*                                                                          */
/* ENTRY POINT: _DLL_InitTerm                                               */
/*   LINKAGE:   CALL FAR (00:32)                                            */
/*                                                                          */
/* INPUT:                                                                   */
/*              HMODULE hmod     - DLL module handle                        */
/*              ULONG   fTerm    - Init/Term flag                           */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*              TRUE (1)                                                    */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*              FALSE (0)                                                   */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
#pragma linkage (_DLL_InitTerm, system)
int _CRT_init(void);
unsigned long _DLL_InitTerm ( ULONG hmod, ULONG fTerm )
{
   LONG  rc = DLLINITTERM_FAILURE; /* initialize to failure */

   if(!fTerm)
   { /* initialize */
      if(!(_CRT_init()))
      {
         if (hHeap = HhpCreateHeap((ULONG)HEAP_SIZE,(USHORT)0L))
         {
            if (!DosCreateMutexSem(NULL,
                                   &hmtxGlobalData,
                                   DC_SEM_SHARED,
                                   FALSE))
            {
               rc = DLLINITTERM_SUCCESS;
#ifdef MMRAS_PTRACE
               InitPTrace()
#endif
            } /* endif */
         } /* endif */
      } /* endif */
   }
   else /* terminate DLL request */
   {
      DosCloseMutexSem(hmtxGlobalData);
      if (!HhpDestroyHeap(hHeap))
      {
         rc = DLLINITTERM_SUCCESS;
      } /* endif */
   } /* endif */
   return rc;
}/* end _DLL_InitTerm */
