/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************ START OF SPECIFICATIONS ***************************/
/*                                                                          */
/* SOURCE FILE NAME:  CDCENTRY.C                                            */
/*                                                                          */
/* DESCRIPTIVE NAME: Main Codec Entrypoint                                  */
/*                                                                          */
/* COPYRIGHT:                                                               */
/*                                                                          */
/* STATUS:  OS/2 Release 2.1                                                */
/*                                                                          */
/* FUNCTION:                                                                */
/*    Main entrypoint for the codec proc                                    */
/*                                                                          */
/* NOTES:                                                                   */
/*    DEPENDENCIES: none                                                    */
/*    RESTRICTIONS: Runs in 32 bit protect mode (OS/2 2.1)                  */
/*                                                                          */
/* ENTRY POINTS:                                                            */
/*    CodecEntry                                                            */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
/* OS/2 INCLUDES */
#define  INCL_WIN
#define  INCL_GPI
#define  INCL_DOSSEMAPHORES
#define  INCL_DOSEXCEPTIONS            /* For exception handler */
#define  INCL_DOSERRORS
#define  INCL_DOSPROCESS
#define  INCL_OS2MM
#define  INCL_MMIO_CODEC
#include <os2.h>
#include <os2me.h>
#include <hhpheap.h>
#include <svsh.h>
#include <cdci.h>

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: CodecEntry                                              */
/*                                                                          */
/* DESCRIPTIVE NAME:                                                        */
/*                                                                          */
/* FUNCTION: Pluggable Codec Entrypoint                                     */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINT: CodecEntry                                                  */
/*                                                                          */
/* INPUT:                                                                   */
/*              PVOID   pmmiostr   - Pointer to MMIOINFO staus structure    */
/*              WORD    wMessage   - MMIO Specific Message from FFIOproc    */
/*              LONG    lParam1    - Primary message dependent parameter    */
/*              LONG    lParam2    - Secondary message dependent parameter  */
/*                                   indicating the length of the message   */
/* EXIT-NORMAL:                                                             */
/*              MMIO_SUCCESS                                                */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/* INTERNAL REFERENCES:                                                     */
/*        ROUTINES:                                                         */
/*                                                                          */
/* EXT1ERNAL REFERENCES:                                                    */
/*        ROUTINES:                                                         */
/*        DATA STRUCTURES:                                                  */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/

LONG APIENTRY CodecEntry (PVOID ppcodec_inst,
                          WORD  wMessage,
                          LONG  lParam1,
                          LONG  lParam2)

{
   RC rc = NO_ERROR;

   switch (wMessage)
   {
   case MMIOM_CODEC_OPEN:

     /***************************************************/
     /* allocate the instance data for this MMIO proc   */
     /* if there are > 1 codec's used for a particular  */
     /* bit stream the first time the first time this   */
     /* nessage is sent the ppcodec_inst parameter must */
     /* be NULL as this is shared data is allocated     */
     /* by the first OpenCodec call (see CodecOpen)     */
     /***************************************************/
      rc = OpenCodec ((PCODEC_INST *)  ppcodec_inst,
                      (PCODECOPEN)     lParam1);
      break;

   case MMIOM_CODEC_CLOSE:

     /***************************************************/
     /* deallocate the instance data for this MMIO proc */
     /* the lParam1 is the hCodec that contains pointers*/
     /* to all the codec allocated data that has to be  */
     /* deallocated                                     */
     /***************************************************/
      rc = CloseCodec ((PCODEC_INST *) ppcodec_inst);
      break;

   case MMIOM_CODEC_COMPRESS:

     /***************************************************/
     /* decompress the incommong buffer                 */
     /* this calls the codec's compressor entrypoint    */
     /* to compress a fraame of data                    */
     /***************************************************/
      if (codecfns.pfnCompressBuffer)
      {
         rc = codecfns.pfnCompressBuffer   ( (PMMCOMPRESS)lParam1,
                                            *(PCODEC_INST *)ppcodec_inst );
      }
      else
      {
         rc = MMIOERR_UNSUPPORTED_MESSAGE;
      }
      break;

   case MMIOM_CODEC_DECOMPRESS:

     /***************************************************/
     /* decompress buffer meaaage so check for palettes */
     /* this calls the codec's decompressor entrypoint  */
     /* to decompress a frame of data                   */
     /***************************************************/
      if (codecfns.pfnDecompressBuffer)
      {
         rc = codecfns.pfnDecompressBuffer ( (PMMDECOMPRESS)lParam1,
                                            *(PCODEC_INST *)ppcodec_inst );
      }
      else
      {
         rc = MMIOERR_UNSUPPORTED_MESSAGE;
      }
      break;

   case MMIOM_CODEC_QUERYNAMELENGTH:

     /***************************************************/
     /* Query the ASCIIZ name of the CODEC              */
     /***************************************************/
//    if (codecfns.pfnQryNameLength)
//    {
//       rc = codecfns.pfnQryNameLength ((PCODEC_INST *) ppcodec_inst,
//                                       (WORD) wMessage,
//                                       (PULONG) lParam1,
//                                       (LONG) lParam2);
//    }
//    else
//    {
         rc = MMIOERR_UNSUPPORTED_MESSAGE;
//    }
      break;

   case MMIOM_CODEC_QUERYNAME:

     /*****************************************************/
     /* Query the length of the ASCIIZ name for the CODEC */
     /*****************************************************/
//    if (codecfns.pfnQryNameString)
//    {
//       rc = codecfns.pfnQryNameString ((PCODEC_INST *)  ppcodec_inst,
//                                       (WORD) wMessage,
//                                       (PSZ) lParam1,
//                                       (PULONG) lParam2);
//    }
//    else
//    {
         rc = MMIOERR_UNSUPPORTED_MESSAGE;
//    }
      break;

   default:
      rc = MMIOERR_UNSUPPORTED_MESSAGE;
      break;
   }
   return (rc);
}
