/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************ START OF SPECIFICATIONS ***************************/
/*                                                                          */
/* SOURCE FILE NAME:  CDCCLOS.C                                             */
/*                                                                          */
/* DESCRIPTIVE NAME: Codec close services                                   */
/*                                                                          */
/* COPYRIGHT:                                                               */
/*                                                                          */
/* STATUS:  OS/2 Release 2.1                                                */
/*                                                                          */
/* FUNCTION:                                                                */
/*                                                                          */
/* NOTES:                                                                   */
/*    DEPENDENCIES: none                                                    */
/*    RESTRICTIONS: Runs in 32 bit protect mode (OS/2 2.1)                  */
/*                                                                          */
/* ENTRY POINTS:                                                            */
/*    CloseCodec                                                            */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*                                                                          */
/* DATE      DEVELOPER   DEFECT  CHANGE DESCRIPTION           CHANGE FLAG   */
/* ---       ---------   ------  ------------------------     -----------   */
/* 06/21/93  JPC         11616   Merging rel1.1 changes             @JC32   */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
/* OS/2 INCLUDES */
#define  INCL_WIN
#define  INCL_GPI
#define  INCL_DOSSEMAPHORES
#define  INCL_DOSEXCEPTIONS            /* For exception handler */
#define  INCL_DOSERRORS
#define  INCL_DOSPROCESS
#define  INCL_OS2MM
#define  INCL_MMIO_CODEC
#include <os2.h>
#include <os2me.h>
#include <hhpheap.h>
#include <svsh.h>
#include <cdci.h>

/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: CloseCodec                                              */
/*                                                                          */
/* DESCRIPTIVE NAME:                                                        */
/*                                                                          */
/* FUNCTION: Terminates a Codec instance                                    */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINT:                                                             */
/*                                                                          */
/* INPUTS:                                                                  */
/*        PDCIO_PINIT pParmIn                                               */
/*        PCDCINITFN  AllocInstCallback                                     */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/* INTERNAL REFERENCES:                                                     */
/*        ROUTINES:                                                         */
/*                                                                          */
/* EXT1ERNAL REFERENCES:                                                    */
/*        ROUTINES:                                                         */
/*        DATA STRUCTURES:                                                  */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/

RC CloseCodec ( PCODEC_INST *ppcodec_key )
{
   RC                rc = MMIO_SUCCESS;
   PE_MOVIE_INST     pe_movie_inst;    /* shared codec data area pointer   */
   PCODEC_INST       pcodec_inst;      /* codec specific instance dats ptr */

   /********************************************************************/
   /* deallocate a codec instance here.  If it is the last codec then  */
   /* destroy the instance must check the pParmin->hCodec (non null??) */
   /********************************************************************/

   ENTERCRITX(rc);

   if (pcodec_inst = *ppcodec_key)
   {
      /**********************************/
      /* find the shared data structure */
      /**********************************/
      if (pe_movie_inst = (pcodec_inst->pe_movie_inst))
      {
         if (!(rc = RemoveCodecChainLink (pcodec_inst)))
         { /* remove from chain but do not deallocate */
            /**********************************************/
            /* at this stage the instance codec_inst was  */
            /* removed from the chain, now the pluggable  */
            /* instance data must deallocated by the      */
            /* callback function.  After this the codec   */
            /* instance struct may be deallocated         */
            /**********************************************/
            if (codecfns.pfnDeallocInstData)
            {
               rc = codecfns.pfnDeallocInstData (pcodec_inst);
            }

            HhpFreeMem (hHeap, pcodec_inst);

            /********************************************/
            /* problem is that the old code had         */
            /* if (!(pe_movie_inst->ulNumCodecs--))     */
            /* the -- did not work correctly       @JC32*/
            /********************************************/
            if (pe_movie_inst->ulNumCodecs)
            {
               pe_movie_inst->ulNumCodecs--;       //@JC32 no -1's
            }

            if (!pe_movie_inst->ulNumCodecs)       //@JC32 last codec so destroy shared stuff
            {
               /****************************************/
               /* destroy the shared movie instance    */
               /* data fields as this is last codec    */
               /****************************************/
               if (pe_movie_inst->codecopen.pSrcHdr)
               {
                  HhpFreeMem (hHeap, pe_movie_inst->codecopen.pSrcHdr);
               }

               if (pe_movie_inst->codecopen.pDstHdr)
               {
                  HhpFreeMem (hHeap, pe_movie_inst->codecopen.pDstHdr);
               }

               if (pe_movie_inst->codecopen.pOtherInfo)
               {
                  HhpFreeMem (hHeap, pe_movie_inst->codecopen.pOtherInfo);
               }

               HhpFreeMem (hHeap, pe_movie_inst);
               pe_movie_inst = NULL;
            }
         }
      }
      else
      {
         rc = MMIO_ERROR; /* null pe_movie_inst */
      }
   }
   else
   {
      rc = MMIO_ERROR; /* null hCodec */
   }
   EXITCRIT;
   return rc;
}


