;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;IOCTL.ASM
;*****************************************************************
; OS/2 3.0 Sample Overlay (MPEG Video Playback) Device driver
;
;
;   Device driver functions
;   -----------------------
;   OPEN
;     Open the device when ready to use adapter.
;
;   CLOSE
;     Close device when no longer being used.
;
;   IOCTL
;     Category 140
;
;       code 60h - Device Specific .INI file Information
;
;
;*****************************************************************
title Sample OS/2 3.0 Device driver for OVERLAY MPEG Video Playback Adapter
page 55,132

.386p

;******************************************************************************
;  I N C L U D E S
;******************************************************************************
INCL_DOSMISC    EQU     1
INCL_DOSERRORS  EQU     1
INCL_TYPES      EQU     1
INCL_DEF        EQU     1

.xlist
include devsym.inc
include devhlp.inc
include basemaca.inc
include basedef.inc
include VIDIN.inc
include vididc.inc         ;struc for IDC stream instance
include vidvci.inc         ; Struc of IOCTLS request packets
include os2medef.inc
include meerror.inc
include ssm.inc
include shdd.inc

ifdef   PTRACE
      include       ptrace.inc    ; PTrace Macros
endif
.list

EXTRN   DOS32FLATDS:ABS               ; 32 bit r/w FLAT selector
EXTRN   _CL450DownLoadCode:NEAR
;EXTRN   _CL450temp1:NEAR
;EXTRN   _CL450temp2:NEAR
;EXTRN   _CL450temp3:NEAR
EXTRN  _VidSetOffsets:NEAR
EXTRN  _VidSetSrcSizePos:NEAR
EXTRN  _VidSetDestSizePos:NEAR
EXTRN  _MonitorON:NEAR
EXTRN  _MonitorOFF:NEAR
EXTRN  _EnableColorKey:NEAR
EXTRN  _DisableColorKey:NEAR
EXTRN  _VidSetKeyMode:NEAR
EXTRN  _CL450StopStream:NEAR
EXTRN  _CL450StartStream:NEAR
EXTRN  _CL450PAUSE:NEAR
EXTRN  _CL450GetBufferLevel:NEAR
EXTRN  _VidSetChromaKey:NEAR
EXTRN  _CL450GetScr:NEAR
EXTRN  _CL450Flush:NEAR
EXTRN  _CL450SetSCR:NEAR

;_DATA   SEGMENT WORD PUBLIC 'DATA'
;_DATA   ENDS
;
;_BSS    SEGMENT WORD PUBLIC 'BSS'
;_BSS    ENDS
;
;CONST   SEGMENT WORD PUBLIC 'CONST'
;CONST   ENDS
;
;_ENDDATA   SEGMENT WORD PUBLIC 'ENDDATA'
;_ENDDATA   ENDS
;
;_TEXT   SEGMENT WORD PUBLIC 'CODE'
;_TEXT   ENDS
;
;_ENDTEXT SEGMENT WORD PUBLIC 'ENDCODE'
;_ENDTEXT   ENDS
;
;
;DGROUP  GROUP   CONST, _BSS, _DATA, _ENDDATA
;CGRP    GROUP   _TEXT, _ENDTEXT

_DATA    SEGMENT dword public 'DATA' USE16; All code and data segments must be named
_DATA ENDS

;DATA    SEGMENT dword public 'DATA' USE16; All code and data segments must be named
;DATA ENDS

_BSS     SEGMENT dword public 'BSS' USE16; All code and data segments must be named
_BSS  ENDS

CONST    SEGMENT dword public 'CONST' USE16; All code and data segments must be named
CONST ENDS

CONST2        segment dword public use16 'DATA'
CONST2        ends

_TEXT           SEGMENT  WORD PUBLIC 'CODE' USE16
_TEXT           ENDS


INIT_TEXT   SEGMENT WORD PUBLIC 'INITCODE' USE16
        EXTRN   INIT:FAR
INIT_TEXT   ENDS

;DGROUP  GROUP   CONST, _BSS, _DATA, _ENDDATA
;CGRP    GROUP   _TEXT, _ENDTEXT
DGROUP  GROUP   _DATA, _BSS, CONST, CONST2
CGRP    GROUP   _TEXT, INIT_TEXT
;DGROUP  GROUP   _DATA, CONST, _BSS
;CGROUP  GROUP   _TEXT


LBegin  macro len
        push    ebp
        mov     ebp,esp
        sub     esp,len
        endm
LEnd    macro
        mov     esp,ebp
        pop     ebp
        endm


_DATA    SEGMENT dword public 'DATA' USE16; All code and data segments must be named

 PUBLIC FlatSel, GetI2RAM
 PUBLIC selector1, named, device_hlp
 PUBLIC Ginfo_Seg, Ginfo_offset, lsw_phys_add, msw_phys_add
 PUBLIC usr_Y_Height, usr_X_Width, usr_ScaleFactor, usr_FPS, usr_X_Left, usr_Y_Top
 PUBLIC usr_DY_Height, usr_DX_Width, usr_DX_Left, usr_DY_Top
 PUBLIC late_tic, lin_addr
 PUBLIC RMagic_opens
 PUBLIC INT_HAND
 PUBLIC usr_FPSflags
 PUBLIC usr_Vinput, usr_VinputD
 PUBLIC usr_KeyColor
 PUBLIC _VGA_KeyColor


CAPTURE_DEVICE    equ  140          ;IOCTL User defined catagory for image capture device
devlev_1          equ  0000000010000000B ;Bits 7-9 - DOS 5.0
dev_char_dev      equ  1000000000000000B ;Bit 15-Device is a character device
dev_30            equ  0000100000000000B ;Bit 11-Accepts open/close
dev_IDC           equ  0100000000000000B ;Bit 14-Accepts IDC command

;------------------ DEVICE DRIVER HEADER ---------------------------------------
Dev_Header        equ  $
ptr_to_nxt_hdr    dd   -1           ;Indicates loadable device driver
device_attr       dw   devlev_1 + dev_char_dev + dev_30
offst             dw   _TEXT:strategy  ;OffQuery to the strategy routine
idc_offset        dw   0               ;No IDC Entry Point routine
named             db   'VIDRMSx$'   ;Name of the device
reserved_words    dw   4 dup (0)    ;Reserved words
;------------------ END OF DEVICE DRIVER HEADER --------------------------------

;***************************************
;* IocTab - Table of Generic IOCTALs   *
;***************************************
        EVEN
        PUBLIC  IocTab
IocTab LABEL WORD
        DW     31H                      ;--- Number of Entries in this Table
        DW     CODE_60H            ;60  ; Init Parms
        DW     CODE_61H            ;61  ; Save current Setup Info
        DW     CODE_62H            ;62  ; Restore Setup Info
        DW     CODE_63H            ;63  ; Load device (microcode...)
        DW     CODE_unk            ;64  ; Unknow Function (command not supported)
        DW     CODE_unk            ;65  ; Unknow Function (command not supported)
        DW     CODE_unk            ;66  ; Unknow Function (command not supported)
        DW     CODE_67H            ;67  ; Play Images back
        DW     CODE_unk            ;68  ; Unknow Function (command not supported)
        DW     CODE_unk            ;69  ; Unknow Function (command not supported)
        DW     CODE_unk            ;6A  ; Set Video Input Source
        DW     CODE_6BH            ;6B  ; Set Capture Image Size
        DW     CODE_unk            ;6C  ; Capture Image and Scale to Ram Bufferd)
        DW     CODE_6DH            ;6D  ; Get Device Info
        DW     CODE_6EH            ;6E  ; Validate Capture Image Size
        DW     CODE_unk            ;6F  ; Capture image into RAM buffer
        DW     CODE_unk            ;70  ; (not supported) Get addressability to VRAM
        DW     CODE_unk            ;71  ; Unknow Function (command not supported)
        DW     CODE_ok             ;72  ; Select Live capture mode
        DW     CODE_unk            ;73  ; Unknow Function (command not supported)
        DW     CODE_unk            ;74  ; Select Live Mode then Freeze
        DW     CODE_ok             ;75  ; Video Adjustments
        DW     CODE_76H            ;76  ; Set Time Based Capture
        DW     CODE_unk            ;77  ; Unknow Function (command not supported)
        DW     CODE_unk            ;78  ; Unknow Function (command not supported)
        DW     CODE_unk            ;79  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7A  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7B  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7C  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7D  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7E  ; Unknow Function (command not supported)
        DW     CODE_unk            ;7F  ; Unknow Function (command not supported)
        DW     CODE_80H            ;80  ; Enable/Disable Monitor
        DW     CODE_81H            ;81  ; Enable/Diable Color Key
        DW     CODE_82H            ;82  ; Set Color Key
        DW     CODE_unk            ;83  ; Unknow Function (command not supported)
        DW     CODE_unk            ;84  ; Unknow Function (command not supported)
        DW     CODE_unk            ;85  ; Unknow Function (command not supported)
        DW     CODE_unk            ;86  ; Unknow Function (command not supported)
        DW     CODE_unk            ;87  ; Unknow Function (command not supported)
        DW     CODE_unk            ;88  ; Unknow Function (command not supported)
        DW     CODE_unk            ;89  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8A  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8B  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8C  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8D  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8E  ; Unknow Function (command not supported)
        DW     CODE_unk            ;8F  ; Unknow Function (command not supported)
        DW     CODE_unk            ;90  ; Unknow Function (command not supported)
        DW     CODE_unk            ;91  ; Unknow Function (command not supported)

getI2RAM       dd      0
eye_catcher    db      ' Sample MPEG overlay PDD DATA AREA '
count_74s      dd      0
               dw      0

FlatSel        dw      0    ; Flat Selector

;------------------- DEVICE IDs OF SUPPORTED DEVICES --------------------------

done              equ   0100h           ; code for DONE
error_s           equ   8000h           ; status code for error
general_failure   equ   000ch           ; General failure error code
Device_in_use     equ   0014h           ; Device Already in use error code
unknown_command   equ   0003h           ; Unknown command error code
not_supported     equ     21h  ;-223    ; This capture device is not supported
not_available     equ     22h  ;-222    ; This capture device is not available
cat_not_supported equ     23h  ;-221    ; IOCTL catagory not supported
fun_not_supported equ     24h  ;-220    ; IOCTL function not supported

sys_time_Rate     equ     32            ; System Timer Ticks/Second

;-------------------------------------------------------------------------------
;Structure of an INIT request packet
;-------------------------------------------------------------------------------
IP       equ   es:[bx]          ;Request packet
INITpkt  struc
         db      ?
         db      ?
_Cmd     db      ?                      ; Command code
_Stat    dw      ?                      ; Status word
         dd      ?
         dd      ?
         db      ?
_DHptr   dd      ?                      ; dev help pointer
_I_parms dd      ?                      ; Parms on "DEVICE=" in config.sys
         db      ?
INITpkt  ends
;-------------------------------------------------------------------------------
;Structure of a General IOCTL request packet
;-------------------------------------------------------------------------------
GIO     equ   es:[bx]
GIOpkt  struc
         db      ?
         db      ?
         db      ?                      ; Command code
         dw      ?                      ; Status word
         dd      ?
         dd      ?
_cat     db      ?                      ; category
_code    db      ?                      ; function code
_Parm    dd      ?                      ; address of parms
_PData   dd      ?                      ; address of data (see VIDVCI.INC)
_Parm_l  dw      ?                      ; Length of parm area  (IOCTL2 only)
_Pdata_l dw      ?                      ; Length of data area  (IOCTL2 only)
GIOpkt  ends


;-------------------------------------------------------------------------------
; General IOCTL output data structures
;-------------------------------------------------------------------------------
GIX     equ   es:[bx]

;-------------------------------------------------------------------------------
; Defaults for the Device   (must match info in VIDVCI.H/INC  ... don't change ... add to end only)
;-------------------------------------------------------------------------------
Defaults          equ $
D_Length          dd   Defaults_End - Defaults            ; Length of Structure/Data
                       ;123456789012345678901234567890
prod_info         db   'IBM - Sample MPEG Playback    '   ; Name of the device
Manufacture_info  db   'IBM                           '   ; Owner of The PDD
Version_info      db   '0.1       '                       ; Version Number
Img_format_info   dd   DI_IMAGEFORMAT_YUV_411             ; YUV422
BitsPerPEL_info   dw   16                                 ; Bit Per PEL
Overlay           dw   1                                  ; Overlay Device
I_brightness      dd   d_brightness
I_hue             dd   d_hue
I_saturation      dd   d_saturation
I_contrast        dd   d_contrast
I_Sharpness       dd   -1                                ; Not Supported
unused1           dd   0                                 ; Unused
S_X_Left          dd   0                                 ; Default Source Info
S_Y_Top           dd   0
S_Y_Height        dd   480
S_X_Width         dd   640
D_X_Left          dd   0                                 ; Default Destination
D_Y_Top           dd   0
D_Y_Height        dd   480/dscale
D_X_Width         dd   640/dscale
D_ScaleFactor     dd   dscale
S_X_MAX           dd   1024                              ; Max X for Source
S_Y_MAX           dd   768                               ; Max Y for Source
D_X_MAX           dd   1024                              ; Max X for Dest
D_Y_MAX           dd   768                               ; Max Y for Dest
O_X_MAX           dd   1024                              ; Max X for Overlay
O_Y_MAX           dd   768                               ; Max Y for Overlay
VideoInputs       dw    1                                ; 2 inputs
CanRestore        dw    1                                ; Yes
CanStretch        dw    1                                ; Yes
CanDistort        dw    8001h                            ; Yes and Off Screen
HasVolume         dw    0                                ; Not supported
HasBalance        dw    0                                ; Not supported
CanScale          dw    1                                ; Can Scale Down
CanStream         dw    0                                ; Can Stream
Instance_ID       dd    0            ; Returned Instance ID for stream
Defaults_End     equ $
Dscale    equ 2
;-------------------------------------------------------------------------------
; Misc data area used by driver
;-------------------------------------------------------------------------------
device_hlp    dd   ?         ; Holds address of the DevHlp functions
RMagic_opens  dd   0         ; open count
buffer_phys   dd   0         ; physical address of buffer
lin_addr      dd   0         ; 32 bit linear address  (GLOBAL)
aper_size     dd   0         ; VRAM buffer aperature size in bytes
buffer_lin    dd   0         ; Linear address for the card
Card_frame_rate dw   60      ; Frame Rate of Card
Timer_on        dw   0       ; Is time based capture turned on (1=True)
parm_es         dw   0       ; parameter packet Selector
parm_bx         dw   0       ; parameter packet Offset
Ginfo_Seg       dw   0       ; Global Info Segment
Ginfo_offset    dw   0       ; Global Info Offset
Late_tic        dd   0       ; Times timer tic was detected late
Card_Buff       dd   0       ; Address of Image buffer on Capture Card
Vsync_count     dd   0       ; Count Vsync Interrupts
_loaded         dd   0       ; MicroCode loaded
public _loaded
public  Vsync_count

StackUsage      equ $                   ; pg 5-47 of os2 Device Drivers book
  SU_cbStruc    DW 14                   ; Size of structure
  SU_flags      DW ?                    ; Flags
  SU_iIRQ       DW ?                    ; IRQ being handled
  SU_cbStackCLI DW ?                    ; bytes used during CLI
  SU_cbStackSTI DW ?                    ; bytes used during STI
  SU_cbStackEOI DW ?                    ; bytes used during EOI
  SU_cNest      DW ?                    ; Nesting Levels
;StackUsage     ENDS


public boardid
boardid  dw      0        ; Type of RM board
                          ; 0=   , 1= lite  2=

PUBLIC bank_size, baseaddr, Intr_Level
bank_size  dd 0           ; Size of Quick VIA bank as configured
baseaddr   dd 0           ; Base RAM address of Quick VIA
Intr_Level db 0           ; Interrupt level for the card

lsw_phys_add dw    0      ;/*Real 32 bit address LSW FROM SYSTEM*/
msw_phys_add dw    0      ;/*Real 32 bit address MSW FROM SYSTEM*/
selector1  dw      0      ;/*Selector of real address FROM SYSTEM. (Same as segment address for DOS) */



ioctl_s_time      dd 0    ; Time in DD to process IOCTL Start
ioctl_s_delta     dd 0    ; Time in DD to process IOCTL Delta
Stop_play         dd 0h
Time_X            dd 0        ; X (time) position on the sreeen
tDelta            dd 57000    ; Big delta times to highlight (.633 Seconds)
out_of_sync_count db 0        ; Count back to back audio & video out of sync
public stop_play, tDelta, ioctl_s_delta

; TEMP **************************88
sync_with_audio   db 1        ; Should we attemp to sysnc with Audio clock
public sync_with_audio
; TEMP **************************88

; Video adjustment settings as seen by the user
;
usr_brightness  dd   d_brightness  ; 1=min,   255=max, 150=norm,    -1=no change, -2=default
usr_hue         dd   d_hue         ; 1=green, 255=red, 075=neutral, -1=no change, -2=default
usr_saturation  dd   d_saturation  ; 1=min,   255=max, 185=norm,    -1=no change, -2=default
usr_contrast    dd   d_contrast    ; Not Supported
usr_vInput      dd    0    ; User Video Input Connector
usr_vInputD     dd    0    ; User Video Input Connector  Default

; Image capture Info as set by the user thru IOCTL 6B "Set Capture Image Size"
;
usr_X_Left      dd   0          ; Offset in X from the left of the image
usr_Y_Top       dd   0          ; Offset in Y from the top of the image
usr_Y_Height    dd   240        ; Height of image
usr_X_Width     dd   320        ; Width  of image
usr_ScaleFactor dd   4          ; Scale image down by this factor
usr_DX_Left     dd   0          ; Offset in X from the left of the image
usr_DY_Top      dd   0          ; Offset in Y from the top of the image
usr_DY_Height   dd   240/dscale ; Height of image
usr_DX_Width    dd   320/dscale ; Width  of image

; Offset to be added (may be negative) to monitor window postion
public offset_x_left, full_sleep, skip_play, _offset_X_Width
offset_X_Left      dw   0          ; Offset in X from the left of the image
offset_Y_Top       dw   0          ; Offset in Y from the top of the image
_offset_X_Width    dw   0          ; Width  of image
offset_Y_Height    dw   0          ; Height of image
full_sleep         dw   8000h      ; If FIFO is fuller than this sleep 33 ms
skip_play          dw   0          ; Don't play omages
; Image capture Rate as set by the user thru IOCTL 67 "Set Capture Rate"
;
usr_FPS            dd   10      ; Frames Per Second or MicroSeconds per Frame
usr_FPSflags       dd    0      ; Default to Frames Per Second 1=MicoSeconds
usr_KeyColor       dd    0      ; Default Key Color
_vga_KeyColor      dd    0      ; Default Key Color

;Default Setting
D_brightness        equ   -1    ; Not Supported
D_hue               equ   128
D_saturation        equ   -1    ; Not Supported
D_contrast          equ   -1    ; Not Supported

; Defaults as set by Init
ID_brightness       dd   D_brightness
ID_hue              dd   D_hue
ID_saturation       dd   D_saturation
ID_contrast         dd   D_Contrast


SCALE_BITS equ 00000111B; Bit used to set scale

  Public frame_info
Frame_info      db  0           ; List of Open Instance

  Public Dac_info
DAC_info      dW  0             ; Type of RMA DAC being used 0FFFFH = normal

; Trace data Items
public Tioctl_s, Tioctl_e, tplay_data,
public tPlay_sleep, tPlay_awake, tPlay_scr, tplay_bound, dl_Delta
public taudio_scr, tscr_log, tiscr
public speed_calc
tioctl_s   db 0
tioctl_e   db 0
tPlay_data db 0
tPlay_sleep db 0
tPlay_awake db 0
tPlay_scr   db 0
tAudio_scr  db 0
tPlay_bound db 0
tscr_log    db 1
speed_calc  db 0
tiscr       db 0
tpts_scr    db 0
dl_Delta dw 40h

public play_time, play_count, cur_time, old_play_count, delay_count, full_level
public delay_deltat,  _delay_count2, _ms_clock, Start_time
public TODC, Last_log, prev_ptraceT, pData_prev,  Low_full_level
public tpts_scr, play_bCount
play_bCount dd 0
play_count dd 0
old_play_count  dd 0
play_time       dd 0
cur_time        dd 0
delay_count     dd 0
full_level      dd 0
delay_deltat    dd 0
_delay_count2   dd 0
_ms_clock       dd 0
start_time      dd 0
todc            dw 0
last_log        dw 0
prev_ptraceT    dw 0
pData_prev      dd 0
prev_scr        dd 0
preva_scr       dd 0
log_scr_count   dw 0
log_scr_skip    dw 32
Low_full_level  dd 0
sleep_start     dd 0
max_sleep_full  dd 0
max_sleep       dd 0
curr_sleep      dd 0
sleep_loop      dw 0                          ; Number of sleep attemps left
public prev_scr, preva_scr
public log_scr_count, log_scr_skip
public sleep_start, max_sleep_full, max_sleep, curr_sleep, sleep_loop

ADJ_REMAIN      dd 0
ADJ_SCR         dd 0
ADJ_DELTA       dd 0
first_Ascr      dd 0
first_Vscr      dd 0
HW_AT           dd 0
HW_VT           dd 0
PREV_ASCR       dd 0
PREV_VPTS       dd 0
PREV_VSCR       dd 0
in_count        dd 0    ; Count 90KHZ clock in DD *** Performance Check ***
public  ADJ_REMAIN, ADJ_SCR, ADJ_DELTA, PREV_ASCR, PREV_VPTS, PREV_VSCR
public First_Ascr, First_Vscr, HW_AT, HW_VT, in_count

EOS_DATA db 64 dup (0)
         db 01, 0fh
         db 64 dup (0)


; Trace data Areas
public rm_ts, rm_te, rm_tcurr
rm_tCurr dd offset rm_ts
         dd 3 dup (0)
rm_tS    dd 600 dup (0)
rm_te    dd 4 dup (0)




  Public OI_LIST, OI_CURR
OI_LIST         dd  0           ; List of Open Instance
OI_CURR         dd  0           ; Current Open Instance
public intr_nest, copy_Active
intr_nest       dd  0
copy_active     dd  0           ; User Level image copy is active

  PUBLIC Ifreeze, Ifroozen, arm_count
Ifreeze         dd  0           ; GetImage Ioctl is active
Ifroozen        dd  0           ; Image Froozen in H/W FIFO
arm_count       db  0           ; Attempt before image is froozen
times_to_rearm  equ 4           ; Times to rearm capture on freeze IOCTL

OC_FN_OFFSET  equ  13           ; Offset to File Handle in OPEN and Close IOCTL
GN_FN_OFFSET  equ  23           ; Offset to File Handle in Generic IOCTL

public _MonitorCode, _MonitorCodeLen
; Boot Strap loader code for DSP
_MonitorCode equ $
;********** Add Code Here for DSP's boot strap loader ...................
;********** Add Code Here for DSP's boot strap loader ...................
;********** Add Code Here for DSP's boot strap loader ...................
;********** Add Code Here for DSP's boot strap loader ...................
; Sample Boot Strap loader Code below for card's DSP
 db     000h,001h,002h,003h,004h,005h,006h,007h,008h,009h,00Ah,00Bh,00Ch,00Dh,00Eh,00Fh
 db     010h,011h,012h
_MonitorCodeLen dw  $-_MonitorCode



public _buf
_buf db  512 dup (0)    ;Reserved words

ifdef   PTRACE
;
; PTrace Public Data
;
        PUBLIC  PTrace_DevHlp, PTraceStruct

        PTrace_DevHlp   dd     0        ; pointer to devhelp routine
        PTraceStruct    db 40 DUP(00)   ; define structure
                                        ; PTrace Structure
                                        ;    MMIOBase32 DWORD( 0:32)
                                        ;    MMIOBase16 DWORD(16:16)
                                        ;    RAS_Table  BYTE:32
endif

ifdef   MMRAS                                                             ;RASHOOK
        PUBLIC  MMRASStruct,MMRASDevHelp                                  ;RASHOOK
MMRASStruct     db 36 DUP(00)   ; define structure for RAS                ;RASHOOK
MMRASDevHelp    dd 0            ; Devhelper address                       ;RASHOOK
ifndef PTraceStruct                                                       ;RASHOOK
PTraceStruct    equ     0       ; dummy define                            ;RASHOOK
endif                                                                     ;RASHOOK
endif                                                                     ;RASHOOK

_DATA ENDS
;*******************************************************************************

subttl Strategy Routine
page
_TEXT     SEGMENT  word public 'CODE' USE16  ;Define code segment
          assume cs:_TEXT,ds:_DATA,es:NOTHING

;-------------------------------------------------------------------------------
; Far Procedure STRATEGY gets the request packet and based on its command code
; branches to the appropriate subroutine. Upon return from the subroutine,
; the request is signalled serviced with or without error.
;-------------------------------------------------------------------------------
PUBLIC RM_STRAT
RM_STRAT EQU $
STRATEGY PROC  FAR
; Temp KLLLLLLL   trace lost time
       pushfd
       cli


         cmp   byte ptr tioctl_s,1
         jne   skip_ioctl_start_trace
         ; Trace commands .........
         push  eax
;         mov   eax,_ms_clock
;         mov   start_time,eax
;         shl   eax,16
         mov   eax,es:[bx]
         push  eax
         mov   eax,es:[bx+4]
         push  eax
         mov   eax,es:[bx+8]
         push  eax
         mov   eax,es:[bx+12]
         push  eax
         call  add_tr
         add   sp,16
         pop   eax
skip_ioctl_start_trace:

         push  ds
         push  gs
         mov   gs,Selector1             ; Selector to the cards Memory

                                        ; IP (ES:BX) = request packet address
         and   IP._Stat,error_s + unknown_command
         mov   al,byte ptr IP._Cmd      ; Command code
         cmp   al,0                     ; Is it INIT call ?
         jne   strat13                  ; no,
         mov   IP._Stat,0
         sti                            ; Temp.....KLLLL time trace

ifdef  PTRACE
       push    ax
       mov     ax,word ptr es:[bx].InitDevHlp+2
       mov     word ptr [PTrace_DevHlp+2],ax
       mov     ax,word ptr es:[bx].InitDevHlp
       mov     word ptr [PTrace_DevHlp],ax
       Init_PTrace     PTraceStruct, PTrace_DevHlp
       pop      ax
endif

         call  INIT                     ; yes,
         cmp   ax,0                     ; Init's Return Code non-zero= failure
         jnz   stratGF                  ; Did init Fail?
         jmp   strat8                   ; go to common exit
strat13:

         cmp   al,13                    ; is it OPEN call ?
         jne   strat14                  ; no
         call  OPEN                     ; yes
         jmp   strat8                   ; go to common exit
strat14: cmp   al,14                    ; is it CLOSE call ?
         jne   strat16                  ; no
         call  CLOSE                    ; yes
         jmp   strat8                   ; go to common exit
strat16: cmp   al,16                    ; is it IOCTL call ?
         jne   strat7                   ; no, go to unknown command
         mov   IP._Stat,0
         call  IOCTL                    ; do IOCTL processing
         jmp   strat8                   ; 
stratGF: or    IP._Stat,error_s + general_failure
         jmp   strat8
strat7:  or    IP._Stat,error_s + unknown_command
strat8:  or    IP._Stat,done            ; set complete flag

         pop   gs
         pop   ds

         cmp   byte ptr tioctl_e,1
         jne   skip_ioctl_end_trace
         ; Trace commands .........
         push  eax
;         mov   eax,_ms_clock
;         sub   eax,start_time
;         shl   eax,16
         mov   eax,es:[bx]
         push  eax
         mov   eax,0FFFFFFFFh
         mov   ax,IP._Stat
         push  eax
         mov   eax,es:[bx+8]
         push  eax
         mov   eax,es:[bx+12]
         push  eax
         call  add_tr
         add   sp,16
         pop   eax
skip_ioctl_end_trace:

; Temp KLLLLLLL   trace lost time
         popfd
         ret
STRATEGY ENDP


subttl Strategy Routine
page
;-------------------------------------------------------------------------------
; Procedure for handling General IOCTLs for device
;-------------------------------------------------------------------------------
IOCTL    PROC  NEAR
         push  es                       ; save request packet pointer
         push  bx                       ; 
         cmp   GIO._cat,CAPTURE_DEVICE  ; Check for category  (same as IP address)
         je    IOCTL_LOOKUP             ; 
;-------------------------------------------------
         mov   ax,cat_not_supported
         jmp   gout

;TABLE LOOKUP for IOCTL hander Routine
IOCTL_LOOKUP:
        mov     cx,[IocTab]             ; Get # of functions in table into CX
        xor     eax,eax
        mov     al,GIO._code            ; al =  function
ifdef   PTRACE
       push eax
       push bx
       push si
       push cx
       xor  cx,cx
       mov  cl,al
       mov  eax,_ms_clock
       sub  ax,prev_ptraceT
       mov  ebx,_ms_clock
       mov  prev_ptraceT,bx     ; Reset prev log time
       lea  si,named+6
       mov  bx,WORD PTR [si]
       and  bx,000Fh
;      Start_PTrace     ADSH_MAJOR,ADSH_ACPADevIntEntry,PTraceStruct,<bx>
       Start_PTrace     ADSH_MAJOR,62h,PTraceStruct,<bx, ax, cx, word  ptr _ms_clock,word ptr play_count>
       pop cx
       pop si
       pop bx
       pop eax
endif

        sub     al,60h                  ; Base Entry Which Entry in the table
        jb      chk_n                   ; function out of range (too small)
        cmp     al,cl                   ; Function in range? (too big)
        ja      chk_n                   ; function out of range
        shl     eax,1                   ; word offset for dispatch table
        call    IocTab[eax+2]           ; Call the function
ifdef   PTRACE
       push eax
       push bx
       push si
       push cx
       mov  cx,ax
       mov  eax,_ms_clock
       sub  ax,prev_ptraceT
       mov  ebx,_ms_clock
       mov  prev_ptraceT,bx     ; Reset prev log time
       lea  si,named+6
       mov  bx,WORD PTR [si]
       and  bx,000Fh
;      Stop_PTrace     ADSH_MAJOR,ADSH_ACPADevIntExit,PTraceStruct,<bx>
       Stop_PTrace     ADSH_MAJOR,80h+62h,PTraceStruct,<bx, ax, cx, word ptr _ms_clock>
       pop cx
       pop si
       pop bx
       pop eax
endif

        jmp     gout                    ; Ioctl done


chk_n:
         mov   ax,fun_not_supported
gout:
         pop   bx                       ; restore request packet pointer
         pop   es                       ; 
         cmp   ax,0                     ; Has any error occured?
         jz    goutok                   ; NO, then jump
         or    ax,error_s               ; YES, then turn on  error flag
         or    IP._Stat,ax              ; put in status field
goutok:
         RET
IOCTL    ENDP

CODE_ok PROC NEAR
;-------------------- Unknow Function  but say oK ------------
         mov   ax,0
         ret
CODE_ok ENDP

CODE_unk PROC NEAR
;-------------------- Unknow Function ------------------------
         mov   ax,fun_not_supported
         ret
CODE_unk ENDP


public INI_PARMS
INI_PARMS equ $
CODE_60H PROC NEAR
;-------------- Init Parms (60H) -------------------------------------------

        mov   ax,word ptr GIO._PData+2; get address of data area
        mov   bx,word ptr GIO._PData  ; 
        mov   es,ax                   ; es:bx-->data area

; Setup Defaults from the INI file
        mov   ax,es:[bx+0]
        mov   offset_X_Left,ax
        mov   ax,es:[bx+2]
        mov   offset_Y_Top,ax
        mov   ax,es:[bx+4]
        mov   _offset_X_Width,ax
        mov   ax,es:[bx+6]
        mov   offset_Y_Height,ax
        mov   ax,es:[bx+8]
        mov   full_sleep,ax
        xor   eax,eax
        mov   ax,es:[bx+10]
        mov   usr_keycolor,eax
        mov   _vga_keycolor,eax
        mov   ax,es:[bx+12]
        mov   skip_play,ax

       cmp   _loaded,1
       jne   skip_sets

       mov   ax,offset_y_top
       push  ax
       mov   ax,offset_x_left
       push  ax
       call  _VidSetOffsets
       add   sp,4

       mov   eax,usr_Y_Height
       push  ax
       mov   eax,usr_X_Width
       push  ax
;       call _VidSetSrcMax
       add   sp,4

       mov   eax,usr_Y_Top
       push  ax
       mov   eax,usr_X_Left
       push  ax
       mov   eax,usr_Y_Top
       push  ax
       mov   eax,usr_X_Left
       push  ax
       call _VidSetSrcSizePos
       add   sp,8

       mov   eax,usr_DY_Top
       push  ax
       mov   eax,usr_DX_Left
       push  ax
       mov   eax,usr_DY_Height
       push  ax
       mov   eax,usr_DX_Width
       push  ax
       call _VidSetDestSizePos
       add   sp,8


skip_sets:
        sub   ax,ax               ; indicate no error
        ret
CODE_60H ENDP


CODE_61H PROC NEAR
;-------------------- Save Setup Info ------------------------

         ; Save all instance information
         PUSHFD
         CLI
         mov   cx,GIO.GN_FN_OFFSET     ; System File Number
         CALL  far ptr FIND_OI         ; Is it In the List?
         CMP   EAX,0                   ; Not in List
         JNE   Save_Fail               ; Error - not found in the list

         mov   OI_CURR,0               ; Mark as NO current Instance
         ;......... do save suff ......
         ;......... Save Current Setting
         xor   ax,ax                   ; RC = Success
         jmp   save_exit               ; all done

save_fail:
         mov   ax,-1

save_exit:
         POPFD
         RET
CODE_61H ENDP

CODE_62H PROC NEAR
;-------------------- Restore Setup Info ------------------------

         PUSHFD
         CLI
         ; Restore all instance information
         mov   cx,GIO.GN_FN_OFFSET     ; System File Number
         CALL  far ptr FIND_OI         ; Is it In the List?
         CMP   EAX,0                   ; Not in List
         JNE   Restore_Fail            ; Error - not found in the list

         mov   OI_CURR,eax             ; Mark as current Instance
         ;......... do restore suff ......
         ;......... Restore Setting ......
         xor   ax,ax                   ; RC = Success
         jmp   restore_exit            ; all done

restore_fail:
         mov   ax,-1

restore_exit:
         POPFD
         ret
CODE_62H ENDP

public LOAD
load equ $
CODE_63H PROC NEAR
;-------------------- Load MicroCode ------------------------

       PUSHFD
       CLI
       ; Address of Request packet
       mov   dx,word ptr GIO._Parm+2 ; get address of Parameter area .. selector
       shl   edx,16
       mov   dx,word ptr GIO._Parm   ;                               .. offset
       mov   cx,word ptr GIO._Parm_l ;                               .. Length
       mov   ax,word ptr GIO._PData+2 ; get address of data area
       mov   bx,word ptr GIO._PData   ; 
       mov   es,ax                    ; es:bx-->data area


       ; Load Device
       mov   eax,GIX.LOAD_ulflags
       cmp   eax,VCALOAD_LOAD
       jne   load_fail

       mov  eax,GIX.LOAD_pLoadData
       push edx

       ;Temp Code for Quick Init of device
;      call _CL450temp1


       ; Good Code......
       ; Load MicroCode onto the device
       call _Cl450DownLoadCode
       add  sp,4

       ;More Init of device  once MicroCode is loaded
;       call _CL450temp2

 ;Set the offsets/alignment Info
       mov   ax,offset_y_top
       push  ax
       mov   ax,offset_x_left
       push  ax
;       call  _VidSetOffsets
       add   sp,4

       mov   eax,usr_Y_Height
       push  ax
       mov   eax,usr_X_Width
       push  ax
;       call _VidSetSrcMax
       add   sp,4

       mov   eax,usr_Y_Top
       push  ax
       mov   eax,usr_X_Left
       push  ax
       mov   eax,usr_Y_Top
       push  ax
       mov   eax,usr_X_Left
       push  ax
       call _VidSetSrcSizePos
       add   sp,8

       mov   eax,usr_DY_Top
       push  ax
       mov   eax,usr_DX_Left
       push  ax
       mov   eax,usr_DY_Height
       push  ax
       mov   eax,usr_DX_Width
       push  ax
       call _VidSetDestSizePos
       add   sp,8


       mov   _loaded,1
       xor   ax,ax                ; RC = Success
       jmp   load_exit            ; all done

load_fail:
       mov   ax,-1

load_exit:
       POPFD
       ret
CODE_63H ENDP


public RESTOREI
RESTOREI equ $
CODE_67H PROC NEAR
;-------------------- Play Images back on the Device ------------------------


       ; Get The Video Scr Value
       push  eax
       push  edx
       push  es
       call  _CL450GetScr
       shl   edx,16
       mov   dx,ax
       mov   HW_VT,edx
       pop   es
       pop   edx
       pop   eax

       mov   eax,stop_play
       cmp   play_count,eax
       jne   skip_stop
skip_stop:

       ; Address of Request packet
       mov   dx,word ptr GIO._Parm+2 ; get address of Parameter area .. selector
       shl   edx,16
       mov   dx,word ptr GIO._Parm    ;                              .. offset
       xor   ecx,ecx
       mov   cx,word ptr GIO._Pdata_l ;                              .. Length
       mov   ax,word ptr GIO._PData+2 ; get address of data area
       mov   bx,word ptr GIO._PData   ; 
       mov   es,ax                    ; es:bx-->data area

         ; Trace Timinig info in data Packet
         cmp   byte ptr tiscr,1
         jne   skip_tiscr_trace
         mov   eax,GIX.STRM_ulSCR
         push  eax
         push  eax

         mov   eax,GIX.STRM_ulPTS
         push  eax
         mov   eax,GIX.STRM_ulAudioTime
         mov   ecx,play_count
         shl   ecx,16
         and   eax,0FFFFh
         or    eax,ecx
         push  eax
         call  add_tr
         add   sp,16
skip_tiscr_trace:

         ; Trace commands .........
         ; Get Time
         push    gs                  ; Save Segment for Card
         push    eax
         push    ebx
         mov     ax,[Ginfo_Seg]      ; Global Info Segment
         mov     ebx,0               ; No Time value to read yet
         cmp     ax,0
         je      no_gs
         mov     gs,ax               ; Load Segment for Global Info
         mov     bx ,[Ginfo_offset]  ; Global Info Offset
         mov     ebx,gs:[bx+4]       ; Read Global Info tenths of milliseconds
         mov     cur_time,ebx
         mov     eax,play_time
         sub     ebx,eax
         mov     delay_deltat,ebx
no_gs:

         pop     ebx
         pop     eax
         pop     gs



         push  eax
         push  cx                      ; Lenght on IOCTL
         mov   eax,cur_time
         mov   play_time,eax
         mov   ecx,GIX.STRM_ulFlags
         shl   ecx,16                  ; UlFlag to top of ECX
         pop   cx

         ;Temp Delay count2 (wait on command to clear)
         mov   ecx,_delay_count2
         mov   _delay_count2,0
         shl   ecx,08                  ; Wait Command to clear/256
         push  ecx                     ; Lenght on IOCTL
         mov   eax,play_count
         sub   eax,old_play_count
         push  ax
         mov   eax,GIX.Strm_ulLength    ; Lenght in IOCTL
         shl   eax,16
         pop   ax

         push  eax
         mov   eax,play_count
         mov   old_play_count,eax
         mov   eax,delay_count         ; Delay in write to fifo
         mov   delay_count,0           ; Delay in write to fifo
         push  eax
         mov   eax,GIX.strm_pImageData ; 32 bit Linear Address
         mov   eax,delay_deltat        ; Delta Time
         push  ax
         mov   eax,full_level      ; Last FIFO Level
         shl   eax,16
         pop   ax
         mov   eax,play_bcount
         mov   play_bcount,0
         push  eax
;        cmp   full_level,1000h
;        jnc   skip_log
         call  add_tr

         ; Show low full level
         mov   eax,low_full_level      ; Number of LOW FIFO Counted
         cmp   eax,0
         je    skip_log
         add   sp,16
         push  eax
         push  eax
         mov   low_full_level,0        ; Zero Count
         mov   eax,max_sleep_full      ; Max Sleep Time
         mov   max_sleep_full,0        ; Zero Count
         push  eax
         mov   eax,077777777H
         push  eax
         call  add_tr
skip_log:
         add   sp,16
         pop   eax



skip_play_data_trace:

       mov   eax,GIX.STRM_ulFlags
       cmp   eax,VCA_PLAY_START
       jne   PLAY_DATA_CHK
       mov   adj_remain,0
       mov   adj_delta,0
       mov   adj_scr,0
       mov   first_Ascr,0
       mov   first_Vscr,0
       mov   PREV_ASCR,0
       mov   PREV_VPTS,0
       mov   PREV_VSCR,0
       mov   log_scr_count,0
       mov   play_count,0
       mov   in_count,0
       mov   old_play_count,0
       mov   low_full_level,0
       mov   max_sleep_full,0        ; Zero Count
       mov   max_sleep,0
;       mov   time_x,0
       call _CL450StartStream

       ;Get Starting Video stream time
       ; It should be equla to the First Audio PTS
       ; mov   eax,GIX.STRM_ulSCR
       mov   eax,GIX.STRM_ulAudioTime
       mov   first_Vscr,eax
       push  eax
       call  _CL450SetSCR
       add   sp,4

       jmp RI_OK

PLAY_DATA_CHK:
       cmp   eax,VCA_PLAY_DATA
       jne   PLAY_STOP_CHK

;******************************************************************
;************** Check if SCR needs to be reprogrammed   ***********
;************** based on the current reported audio SCR ***********
;******************************************************************
        pushad


         ; Convert MMTIME (3,000 tics/sec to 90,000 Hz MPEG Clock)
         ; assume audio time starts at zero
         mov   eax,GIX.STRM_ulAudioTime
         cmp   prev_ascr,eax
         je    no_time_adjust
         cmp   eax,0                        ; Temp = during a pause the system
         je    no_time_adjust               ; send a time of zero???

         mov   eax,GIX.STRM_ulAudioTime
         mov   prev_ascr,eax
         mov   edx,0
         mov   ecx,30
         mul   ecx                          ;*30 to get to 90,000Khz from 3000 ms
         add   eax,first_Vscr               ; add in starting Video SCR
         mov   GIX.STRM_ulAudioTime,eax     ;Convert Audio to 90,000KHZ

         mov   eax,GIX.STRM_ulAudioTime     ; Audio time
         sub   eax,HW_VT                    ; HW Video * Audio SCR Delta
         test  eax,080000000h               ; Check for Negative
         jz    positive_num
         mov   ecx,eax
         mov   eax,0
         sub   eax,ecx
positive_num:
         and   eax,0FFFFF000H               ; Time off by .045 Sec
         cmp   eax,0

         ; Resync the Video with the audio time if the time is out of sync
         ; 2 time in a row. The audio time tends to bounce around a little
         ; this will help eliminate false audio time readings
         jne   resync_needed
         mov   out_of_sync_count,0
         jmp    skip_resync
Resync_needed:
         cmp   sync_with_audio,1
         jne   skip_resync
         inc   out_of_sync_count
         cmp   out_of_sync_count,2         ; If out of Sync 2 time in a row
         je    resync_now                  ; Then it is time to resync

         jmp   skip_resync
resync_now:
         mov   out_of_sync_count,0
         mov   eax,GIX.STRM_ulAudioTime     ; Audio time
         mov   ioctl_s_time,eax             ; adjust to new time
         push  es
         push  ebx
         push  eax
         call  _CL450SetSCR
         add   sp,4

         pop   ebx
         pop   es
skip_resync:


no_time_adjust:
        popad

        ; Check to make sure FIFO has some room.... don't let
        ; caller make us loop wait for FIFO to empty
        pushad
        call    _CL450GetBufferLevel
        and   eax,0ffffh
        mov   full_level,eax


        ; Count Number of times the FIFO Runs Low
        cmp   full_level,3000h
        jnc   skip_fullness_trace
        inc   low_full_level
skip_fullness_trace:

        ; Sleep up to max of 8 times waiting for FIFO to clear
        mov     Sleep_loop,8
        mov     eax,full_level
        cmp     ax,full_sleep
        jc      no_sleep

;
; Put caller to sleep let FIFO clear out some (lets not waste CPU MIPs)
;
sleep_some:
        pushad
        inc     curr_sleep              ; Count Number of times sleep occurs

        add     delay_count,01000000h;Temp Timing info for trace
        mov     ebx,GIX.strm_pImageData ; use linear buffer as event id Low
        mov     eax,ebx                 ; use linear buffer as event id
        shr     eax,16                  ; event id High
        mov     di,0                    ; Time out High
        mov     cx,33                   ; Time out Low (let sleep 33 Milliseconds)
        mov     dh,1                    ; Non-interruptable sleep
        mov     dl,Devhlp_procblock     ; 
        call    device_hlp              ; 
        cli

        call   _CL450GetBufferLevel
        and    eax,0ffffh
        mov    full_level,eax

        mov    eax,full_level
        cmp    ax,full_sleep
        popad
        jc     no_more_sleep
        mov    eax,full_level

        dec    sleep_loop
        jnz    sleep_some
        jmp     ri_fail

no_more_sleep:

no_sleep:

        mov    eax,curr_sleep
        cmp    eax,max_sleep
        jbe    not_max_sleep_count
        mov    max_sleep,eax           ; Set new high water mark
not_max_sleep_count:
;KLLLLLLLLLLLLL  TEMP Check for sleeping multiple times   below
        mov   eax,curr_sleep
        cmp   eax,5
        jb    skip_int      ; Check if we are sleeping too much (bad SCR/PTS)
;  int 3
skip_int:

        popad

got_speed:



       ; Send Data to the Chip for Decompression with Lenght and PTS ...
       ; 
       ; ****************
       ; ***** NOTE: ****  Length may be Odd number of Bytes
       ; ****************
       mov   ecx,GIX.Strm_ulLength   ; Lenght in IOCTL
       mov  ecx,GIX.STRM_ulPTS
       mov  eax,GIX.STRM_ulAudioTime
       cmp  eax,0                   ; No Video Time?
       je   NO_time_provided
       cmp  eax,first_Vscr          ; No Video Time?
       jne  have_good_time
NO_time_provided:
       mov  ecx,0                   ; No Time provided (no audio stream)
have_good_time:
       push ecx                     ; PTS
       mov   ecx,GIX.Strm_ulLength  ; Lenght in Data to decompress
       push cx                      ; Length of the Data
       mov  edx,GIX.strm_pImageData ; 32 bit Linear Address
       push edx                     ; Pointer to data to restore/decompress
       mov   ax,0  ; Init Return code Sample Skip Call below
;      call _CL450Temp3
       add  sp,10

       cmp  ax,0
       jne  RI_FAIL
       jmp  RI_OK

PLAY_STOP_CHK:
       cmp   eax,VCA_PLAY_STOP
       jne   PLAY_FLUSH_CHK
       call _CL450StopStream
       jmp RI_OK

PLAY_FLUSH_CHK:
       cmp   eax,VCA_PLAY_FLUSH
       jne   PLAY_PAUSE_CHK
       call _CL450Flush
       jmp RI_OK

PLAY_PAUSE_CHK:
       cmp   eax,VCA_PLAY_PAUSE
       jne   RI_FAIL
       call _CL450PAUSE
       jmp RI_OK


RI_OK:
       xor   ax,ax              ; RC = Success
       jmp   RI_exit            ; all done

RI_fail:
       mov   ax,-1

RI_exit:
       ret
CODE_67H ENDP

CODE_6DH PROC NEAR
;-------------------- Get Default Info (6DH) --------------------------

       ; Load up Default info for caller
       mov   dx,GIO.GN_FN_OFFSET      ; System File Number
       mov   ax,word ptr GIO._PData+2 ; get address of data area
       mov   bx,word ptr GIO._PData   ; 
       mov   es,ax                    ; es:bx-->data area

       mov   ecx,GIX.DI_Length
       cmp   ecx,0
       je    too_Small
       cmp   ecx,D_Length
       jb    too_small
       mov   si,offset Defaults
       mov   di,bx

copy_defaults:
       REP  MOVS byte ptr es:[di], byte ptr ds:[si] ; copy the Dafault Info

       ; Find  Stream Instance
       mov   di,bx                    ; Start of Parm List
       mov   es:[di].DI_ulFileNum,-1; Assume Invalid Instance
       mov   fs,flatsel
       mov   cx,dx                    ; System File Number
       call  far ptr FIND_OI
       cmp   eax,0                    ; 0 = Invalid Stream Handle
       je    CODE_6DH_DONE            ; Instance is not active
       xor   ebx,ebx
       mov   bx,fs:[eax].OI_FILENUM   ; File Number for this OPEN
       mov   es:[di].DI_ulFileNum,EBX ; File Number for the Caller

       sub   ax,ax                    ; indicate no error
       jmp   CODE_6DH_DONE

Too_Small:
       mov   ax,1                                     ; !!! Too Small

CODE_6DH_DONE:
       ret
CODE_6DH ENDP


CODE_6BH PROC NEAR
;-------------------- SET Source and Destination Image Info (6BH) ------------

       ; Save Parms away for use later by Image Capture Routines
       mov   ax,word ptr GIO._PData+2 ; get address of data area
       mov   bx,word ptr GIO._PData   ; 
       mov   es,ax                    ; es:bx-->data area

       ; Save Video Acquisition Source window Info
       mov   eax,GIX.CR_Source_X_Left
       mov   usr_X_Left,eax
       mov   eax,GIX.CR_Source_Y_Top
       mov   usr_Y_Top,eax
       mov   eax,GIX.CR_Source_Y_Height
       mov   usr_Y_Height,eax
       mov   eax,GIX.CR_Source_X_Width
       mov   usr_X_Width,eax

       ; Save Video Distination/Display window Info
       mov   eax,GIX.CR_Dest_X_Left
       mov   usr_DX_Left,eax
       mov   eax,GIX.CR_Dest_Y_Top
       mov   usr_DY_Top,eax
       mov   eax,GIX.CR_Dest_Y_Height
       mov   usr_DY_Height,eax
       mov   eax,GIX.CR_Dest_X_Width
       mov   usr_DX_Width,eax

       ; Tell Device the new scale factor KLLLLLLLL for playback
;KKKKKKKKKKKKKKKKKKKKKKK Source (SRC) must be set also

       cmp   _loaded,1
       jne   tempskip

       mov   eax,GIX.CR_Source_Y_Height
       push  ax
       mov   eax,GIX.CR_Source_X_Width
       push  ax
;       call _VidSetSrcMax
       add   sp,4

       mov   eax,GIX.CR_Source_Y_Top
       push  ax
       mov   eax,GIX.CR_Source_X_Left
       push  ax
       mov   eax,GIX.CR_Source_Y_Height
       push  ax
       mov   eax,GIX.CR_Source_X_Width
       push  ax
       call _VidSetSrcSizePos
       add   sp,8

       mov   eax,GIX.CR_Dest_Y_Top
       push  ax
       mov   eax,GIX.CR_Dest_X_Left
       push  ax
       mov   eax,GIX.CR_Dest_Y_Height
       push  ax
       mov   eax,GIX.CR_Dest_X_Width
       push  ax
       call _VidSetDestSizePos
       add   sp,8
tempskip:

code_6B_done:
       sub   ax,ax                    ; indicate no error
       ret
CODE_6BH ENDP


public VALIDATERECT
VALIDATERECT equ $
CODE_6EH PROC NEAR
;-------------------- VALIDATE CAPTURE IMAGE SIZE (6EH) --------------------------
      Scale             EQU     12h                  ; Scale Down Image by
      Update            EQU     16h                  ; Source updated

       LBegin 24h
       jmp valid_rectl_6E                            ; Valid Rectangle
       ; Address of Parms
       ; Save Parms away for use later by Image Capture Routines
       mov   ax,word ptr GIO._PData+2 ; get address of data area
       mov   bx,word ptr GIO._PData   ; 
       mov   es,ax                    ; es:bx-->data area
       mov   byte ptr[ebp-update],0   ; Assume source not updated

       ; X and Y source must be >= X and Y destinations
       mov   eax,GIX.CR_Source_Y_Height
       mov   ecx,GIX.CR_Dest_Y_Height
       cmp   eax,ecx
       jae   Check_width
       mov   GIX.CR_Source_Y_Height,ecx
       mov   byte ptr[ebp-update],1   ; source updated

Check_width:
       mov   eax,GIX.CR_Source_X_Width
       mov   ecx,GIX.CR_Dest_X_Width
       cmp   eax,ecx
       jae   Source_calc_done
       mov   GIX.CR_Source_X_Width,ecx
       mov   byte ptr[ebp-update],1   ; source updated

source_calc_done:
       cmp     byte ptr[ebp-update],0     ; Source was not updated
       je      valid_rectl_6E
       mov     ax,VCAERR_INVALID_PARM
       jmp     vrDone

valid_rectl_6E:                          ; Valid Rectangle
       ;Retrun Code = success
       sub   ax,ax                       ; indicate no error

vrDone:
       lend
       ret
CODE_6EH ENDP


CODE_76H PROC NEAR
;-------------------- SET FPS to stream Image (76H) --------------------------
; Set/Query Frame Rate (only provided for compatability - not used)
        LBegin 4h
        push  es
        push  bx

        mov   ax,word ptr GIO._PData+2; get address of data area
        mov   bx,word ptr GIO._PData  ; 
        mov   es,ax                   ; es:bx-->data area


        mov   ecx,GIX.SF_Set_FPS      ; Frame Rate
        mov   [usr_FPS],ecx

        mov   ecx,GIX.SF_ulflags      ; FPS or MicroSeconds Per Frame (MPF) flag
        mov   [usr_FPSflags],ecx

        sub   ax,ax                   ; indicate no error

code_76h_done:
        pop   bx                ; restore request packet pointer
        pop   es
        lend
        ret
CODE_76H ENDP

CODE_80H PROC NEAR
;-------------------- Enable\Disable Display of Video on VGA Monitor (80H) ------------

        push  es
        push  bx

        mov   ax,word ptr GIO._PData+2; get address of data area
        mov   bx,word ptr GIO._PData  ; 
        mov   es,ax                   ; es:bx-->data area


        cmp   GIX.EDM_bMonitor,1      ; Monitor ON or OFF?
        je    code_80h_ON             ; Jmp if set to ON

        Call _MonitorOFF              ; Turn the Monitor OFF

        jmp   code_80h_done

code_80h_ON:
       call  _MonitorON               ; Turn the Monitor ON

code_80h_done:
        pop   bx                      ; restore request packet pointer
        pop   es

        sub   ax,ax                   ; indicate no error
        ret
CODE_80H ENDP

CODE_81H PROC NEAR
;-------------------- Enable\Disable Color Key /Transparrent Color (81H) ------------

        push  es
        push  bx

        mov   ax,word ptr GIO._PData+2; get address of data area
        mov   bx,word ptr GIO._PData  ; 
        mov   es,ax                   ; es:bx-->data area


        cmp   GIX.EDCK_bColorKeying,1 ; Color Keying  ON or OFF?
        je    code_81h_ON             ; Jmp if set to ON

        call  _DisableColorKey; Turn OFF
        jmp   code_81h_done

code_81h_ON:
        call  _EnableColorKey ; Turn ON

code_81h_done:
        pop   bx                      ; restore request packet pointer
        pop   es

        sub   ax,ax                   ; indicate no error
        ret
CODE_81H ENDP

CODE_82H PROC NEAR
;-------------------- Set Color Key /Transparrent Color (81H) ------------

        push  es
        push  bx

        mov   ax,word ptr GIO._PData+2; get address of data area
        mov   bx,word ptr GIO._PData  ; 
        mov   es,ax                   ; es:bx-->data area


        mov   eax,GIX.SCK_ulColorKey  ; Color Key value
        cmp   eax,-1                  ; Is this a Query of the current value?
        je    return_CurColor         ; return Current Value
        and   eax,0FFh                ; make sure it's not too big
        mov   usr_keycolor,eax        ; Save Current Setting
        mov   _vga_keycolor,eax       ; Save Current Setting
        pushad
        push  ax
        ; Set Video Overlay Key/Transparent Color
        call _VidSetChromaKey
        add  sp,2
        popad
return_CurColor:                      ; return Current Value
        xor   eax,eax
        mov   eax,usr_keycolor        ; Get Current Setting
        mov   GIX.SCK_ulColorKey,eax  ; Color Key value
        pop   bx                      ; restore request packet pointer
        pop   es

        sub   ax,ax                   ; indicate no error
        ret
CODE_82H ENDP



subttl OPEN Routine
page
;-------------------------------------------------------------------------------
; Procedure for handling OPEN for device
;-------------------------------------------------------------------------------
OPEN     PROC  NEAR

        cmp   RMagic_opens,1           ; Is the device already open?
        mov   ax, Device_in_use        ;Device Already in use error code
        je    OPENt                    ; yes - block open



        ; Allocate and Initialize an Open Instance structure
        mov   ecx,SIZE OPEN_INSTANCE ; Size of storage to allocate
        mov   edi,-1
        ;         876543210
        mov   eax,000000010B ; Allocate in Global address space, fixed  storage
        mov   dl,DevHlp_VMAlloc
        call  device_hlp
        jc    OPENx                     ; Did we get the storage   Carry=1 is a failure

        ; Add new Stream Instance
        PUSHFD
        CLI                              ; Turn Off Interrupt (Critical Section)
        mov   fs,flatsel
        MOV   ECX,OI_List                ; Find first OI in the List
        mov   fs:[eax].OI_pNext,ECX      ; New OI points to old  Head of the OI_LIST
        MOV   OI_List,EAX                ; Add New OI at the head of the OI_LIST
        MOV   fs:[eax].OI_SI,0           ; Stream Instance
        mov   fs:[eax].OI_hStream,0      ; 
        mov   dx,es:[bx+OC_FN_OFFSET]    ; System File Number
        MOV   fs:[eax].OI_FileNum,dx     ; Stream not active
        POPFD


         inc   RMagic_opens             ; Count Opens
         cmp   RMagic_opens,1             ; Is this The First OPEN
         jne   OPEN_done                ; yes
         push  es                       ; save request packet pointer
         push  ebx



ring3addr:
;
;        Create a 16:16 selector address to the buffer for ring 3 code to use
;
;        The ring 3 selector will reference a buffer that is 16, 32, or 64K
;        depending on the aperature size configured.  Only the first 64K
;        of a 640K aperature-configured card will be addressable with 16:16
;        addressing.
;
        mov   cx,800h                  ; get size of RAM on the card
        mov   ax,msw_phys_add          ; convert real address of VRAM to
        mov   bx,lsw_phys_add          ; convert real address of VRAM to
        mov   dh,1                     ; read/write area
        mov   dl,DevHlp_PhysToUVirt    ; get a selector
        call  device_hlp               ; 
;        mov   ax,es                    ; save the returned selector
;        mov   selector1,ax             ; save selector for VRAM window 1
;        mov   gs,ax                    ; GS is selector to card
;        mov   gs,Selector1             ; Selector to the cards Memory

;
;        mov   cx,400h                  ; get aperature size
;        mov   ax,msw_phys_add          ; convert real address of VRAM to
;        mov   bx,lsw_phys_add          ; convert real address of VRAM to
;        mov   dh,1                     ; read/write area
;        mov   dl,DevHlp_PhysToUVirt    ; get a selector
;        call  device_hlp               ;

;        Create a 32-bit linear address to the buffer for ring 3 code to use
;
        mov     edi, DWORD PTR lsw_phys_add ; get physical addr of buffer
        mov     buffer_phys, edi        ; save it

        mov     ax, ds
        mov     esi, offset buffer_phys ; this is the 32 bit offset (flat)
        mov     dl, DevHlp_VirttoPhys
        call    device_hlp

        mov     ax, ds
        mov     esi, offset buffer_phys ; this is the 32 bit offset (flat)
        mov     dl, DevHlp_VirttoLin
        call    device_hlp

        mov     edi, eax                 ; get pointer to physical address
        mov     ecx,800h                 ; size of bank / aperture size
        mov     aper_size,ecx   ; save aperature size
;        mov     eax, 30h        ; bit 4 = phys addr, bit 5 = 1 Proccess addr
;        mov     dl,  DevHlp_VMAlloc
;        call    device_hlp      ; Process Address
;        mov     lin_addr_p, eax   ; store linear address of Quick VIA memory

        mov     eax, 10h        ; bit 4 = phys addr, bit 5 = 0 Global addr
        mov     dl,  DevHlp_VMAlloc
        call    device_hlp      ; Get Global Address
        mov     lin_addr, eax   ; store linear address of Quick VIA memory



;        mov     [S_Y_Height],240               ; Default Source Y Size
;        mov     [D_Y_Height],240/2             ; Default Destination Y Size
;        mov     [S_Y_MAX],240                  ; Max Y for Source
;        mov     [D_Y_MAX],240                  ; Max Y for Dest


;!!!! Init........... stuff

; Timer 0 to 1MS Rate  .... TEMP KLLLLLLLLLLLLLLLL
ifdef   MMTIME
         mov     al,36h
         out     43h,al
         mov     al,0a6h
         out     40h,al
         mov     al,04h
         out     40h,al
endif



        pop   ebx                     ; restore request packet pointer
        pop   es                      ; 

OPEN_done:
        xor    eax,eax                ; No Error
        jmp    open_end

OPENt:  or    IP._Stat,error_s        ; Log Error  code in status
        or    IP._Stat,ax
        jmp   open_end

OPENx:  or    IP._Stat,error_s + general_failure
open_end:

         RET
OPEN     ENDP

subttl CLOSE Routine
page
;-------------------------------------------------------------------------------
; Procedure for handling CLOSE for device
;-------------------------------------------------------------------------------
CLOSE    PROC  NEAR
         ; Remove  Stream Instance
         mov   fs,flatsel
         mov   cx,es:[bx+OC_FN_OFFSET]  ; System File Number
         call  REMOVE_OI

         cmp   eax,0                    ; 0 = Invalid Stream Handle
         je    CLOSEx

         ; Make Sure Video Is OFF
         pushad
         mov  ax,1                 ;ALL VGA for Now (kill the video Display)
         push ax
         call _VidSetKeyMode
         pop  ax
         popad

         ; Stop and deregister the stream for this instance
         mov   ecx,fs:[eax].OI_hStream
         cmp   ecx,0                    ; Is a stream Registered
         je    STREAM_GONE              ; No Stream registered
;        call  far ptr STOP_STREAM
;        call  far ptr DEREG_STREAM
STREAM_GONE:                            ; 


         ; Free the OI  structure
         mov   dl,DevHlp_VMFree
         call  device_hlp
         jc    CLOSEx                   ; Did we free the storage   Carry=1 is a failure

         dec   RMagic_opens             ; Count Current OPENs
         cmp   RMagic_opens,0           ; is This the Last OPEN
         jne   CLOSEx                   ; no

         ; Drop Addressability to the Cards Memory
         mov   eax,lin_addr             ; Free  address of Quick VIA memory
         mov   lin_addr,0               ; Zero  address of Quick VIA memory
         mov   dl,  DevHlp_VMFree
         call  device_hlp               ; Free Global Address of QuickVIA memory
CLOSEx:
         RET
CLOSE    ENDP

subttl IOCTL Routines

IC              equ es:[bp]     ; pointer to structure (like GIX above)
IC_BUMP         equ es:[di]     ; pointer to structure for use with stosw


subttl LockMem
page

;********************** START OF SPECIFICATIONS ***************************
;*
;* SUBROUTINE NAME:  LockMem
;*
;* DESCRIPTIVE NAME:  Lock memory passed to PDD from process.
;*
;* FUNCTION: Lock the virtual linear addresses of a chunk of memory
;*            so that we can access them. It will also convert process
;*            memory to globale memory.
;*
;* ENTRY POINTS:   LockMemLong
;*
;* INPUT:
;*              AX:ESI = selector:offset of lock handle
;*              EBX = Linear address to lock
;*              ECX = Length to lock (will be rounded to next 4K boundary)
;*
;* EXIT-NORMAL: Carry Flag clear
;*              EAX = Global linear address of memory locked
;*
;* EXIT-ERROR:  Carry Flag Set
;*              EAX = error code
;*
;* SIDE EFFECTS:
;*              All registers are preserved, except for EAX
;*
;* MODIFICATION HISTORY:
;*     DATE      DEVELOPER     CHANGE DESCRIPTION
;*
;*********************** END OF SPECIFICATIONS ****************************
LockMem Proc NEAR
;        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
      LOCK_RW         EQU     0000000000001000B     ; R/W access
      LOCK_LONG       EQU     0000000000010000B     ; Lock for long duration

        push    edi
        push    ebx
        push    ecx
        push    edx
        push    esi

        mov     edi,LOCK_RW OR LOCK_LONG ; r/w access & lock Long
;
; Get linear address of hlock. Needed for VMLock call
;
        mov     dl,DevHlp_VirtToLin
        call    device_hlp              ; 
        jc      LockMem_err

;
; Lock the memory.
;
        mov     esi,eax                 ; lock handle
        mov     eax,edi                 ; flags:
        mov     edi,-1                  ; no page info returned
        mov     dl,DevHlp_VMLock
        call    device_hlp              ; 
        jc      LockMem_err

;
; Need to do VMProcessToGlobal
;
        mov     eax,01h                 ; flag: writable
        mov     dl,DevHlp_VMProcessToGlobal
        call    device_hlp              ; 
        jnc     LockMem_ret

LockMem_err:
;        mov     eax,1                  ; EAX has Error Code from DevHelp
LockMem_ret:
        pop     esi
        pop     edx
        pop     ecx
        pop     ebx
        pop     edi

        ret
LockMem endp

subttl UnLockMem
page

;********************** START OF SPECIFICATIONS ***************************
;*
;* SUBROUTINE NAME:  UnlockMem
;*
;* DESCRIPTIVE NAME:  Unlock memory
;*
;* FUNCTION: Unlock the virtual linear addresses of the memory we locked down.
;*
;* ENTRY POINTS:   UnlockMem
;*
;* INPUT:
;*              AX:ESI = selector:offset of lock handle
;*              EBX = offset of global linear to VMfree
;*
;* EXIT-NORMAL: Carry Flag clear
;*
;* EXIT-ERROR:  Carry Flag Set
;*              EAX = error code
;*
;* SIDE EFFECTS:
;*              All registers are preserved, except EAX
;*
;* MODIFICATION HISTORY:
;*     DATE      DEVELOPER     CHANGE DESCRIPTION
;*
;*********************** END OF SPECIFICATIONS ****************************
UnlockMem Proc NEAR
;        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

        push    edx
        push    esi

;
; Do a VMFree (to undo VMProcessToGlobal)
;
        xchg    eax,ebx                         ; eax = linear addr to lock
        mov     dl,DevHlp_VMFree
        call    device_hlp              ; 
        jc      UnlockMem_err

;
; Get linear address of hlock. Needed for VMLock call
;
        xchg    eax,ebx                         ; eax = selector of lock handle
        mov     dl,DevHlp_VirtToLin
        call    device_hlp              ; 
        jc      UnlockMem_err

;
; Unlock the memory.
;
        mov     esi,eax                 ; lock handle
        mov     dl,DevHlp_VMUnlock
        call    device_hlp              ; 
        jnc     UnlockMem_ret           ; 

UnlockMem_err:
;        mov     eax,1                  ; EAX has Error Code from DevHelp
UnlockMem_ret:
        pop     esi
        pop     edx

        ret
UnlockMem endp

subttl Interrupt Routine
;-------------------------------------------------------------------------------
; Interrupt routine
;
; Handles End-of-Frame interrupts from the Card
;
;  Uses system millisecond counter to judge when it's time to capture the next image
;  Then when the application has specified more frames per second than the CPU can
;  support the sytem timer will get locked out and time will appear to stand still, this
;  will cause this code to stop captureing images utill the system timer can get back in
;  to update the time to the correct value. At this point we may have skipped some frames
;  but because the system is now correct we can calculate how many we skipped.
;
;-------------------------------------------------------------------------------
INT_HAND PROC  FAR
;        pushfd
        cli
        inc   intr_nest
        inc   vsync_count


        ; Clear the active Interrupt from the card



        ; Issue EOI
        mov   al, Intr_Level
        mov   dl, DevHlp_EOI
        call  device_hlp             ; 

; Keep those interrupts comming!

        cmp   Ifreeze,1                  ; Has Freeze Been Issued
        je    Image_freeze_active

        cmp   copy_active,1
        je    int_exit
        sti
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>  IF (Correct Time)  Read Image from the VCA Card  and Stream >>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

;KLLL  process the interrupt
;       CALL  TIMEINTRPT
        jmp   int_exit




Image_freeze_active:
        ; One shot (single image capture)
        ; Image Freeze IOCTL issued don't unfreeze until unfreeze IOCTL
        ; is issued let a few field times pass before freeze starts
        cmp  Ifroozen,1
        je   Int_exit
        dec  arm_count
        je   image_has_been_froozen
;        call armforcapture
        jmp  int_exit

image_has_been_froozen:
        mov  Ifroozen,1

int_exit:
        cli


; Allow new Interrupts - reinitialize for the next VSYNC interrupt.
;        mov     al,INTRCREGSAVE
;        or      al,(INT_ENABLE OR INT_ON_VSYNC)
;        mov     dx,INTRCREG
;        out     dx,al                   ; reenable interrupts
;        mov     INTRCREGSAVE,al
        dec   intr_nest
        clc                          ; Clear Carry Flag to show it
                                     ; was our Interrupt
        jmp     INTR_DONE

;
; Interrupt not caused by our card (exit with Carry Flag set without doing
; a DevHelp EOI
Intr_not_ours:
        stc                          ; tell caller - not our Interrupt

INTR_DONE:
;         popfd
         ret                         ; 

INT_HAND ENDP

;***************************************************************************
;  Timer Interrupt handler (called by system timer code every N clock ticks
;  then it checks to see if the pallete has changed and corrects the Pallete
;  in the Overlay card. This may not be required for all Overlay Cards.
;***************************************************************************
Procedure PaletteCheck,FAR
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING


        push    ds
        push    gs
        push    fs
        push    eax
        push    ebx

        mov     ax,_DATA                 ; DS -> DGROUP
        mov     ds,ax

        mov     ax,FlatSel               ; load up flat selector for VMAlloced memory
        mov     fs,ax

; Read Palette from VGA chip's DAC and program MPEG overlays cards DAC with the
; current color Information.
;        Call _VidSoftSnoop


        pop     ebx
        pop     eax
        pop     fs
        pop     gs
        pop     ds


        ret

EndProc PaletteCheck


;***************************************************************************
;* FUNCTION:    Remove a Open Instance (OI) from the OI_LIST
;*
;* INPUT:
;*              CX  = OPEN Handle of the (OI) to be removed
;*
;* EXIT-NORMAL:
;*              EAX  = Buffer Address for OI
;*
;* EXIT_ERROR:
;*              EAX = 0   (OI not Found)
;***************************************************************************
Procedure REMOVE_OI,NEAR
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

        PUSHFD
        PUSH  ECX
        PUSH  EDX
        CLI                                   ; Turn Off Interrupt (Critical Section)

        CALL  far ptr FIND_OI                 ; Is it In the List?
        CMP   EAX,0                           ; Is the List Empty
        JE   REMOVE_OI_Done                   ; Stream Handle - Not in List

REMOVE_OI_WALK:
        MOV   EAX,OI_LIST                     ; Get First OI in the OI_LIST
        MOV   EDX,0                           ; 0 = Delete from List Head
REMOVE_OI_NEXT:
        CMP   EAX,0                           ; Is the List Empty
        JE   REMOVE_OI_Done                   ; - Not in List

        cmp   fs:[eax].OI_FileNum,cx          ; Is this to correct OI
        je    REMOVE_OI_ITEM                  ; We Found the OI - Handle in List

        mov   edx,eax                         ; Remember Previous Element
        mov   eax,fs:[eax].OI_pNext           ; Try next OI
        jmp   REMOVE_OI_Next                  ; Loop until all OI(s) are checked

REMOVE_OI_ITEM:
        cmp   edx,0                           ; Is the Item at the List Head
        je    REMOVE_OI_HEAD                  ; Remove Element from the Head
        mov   ecx,fs:[eax].OI_pNext           ; Next Item after Item being Deleted
        mov   fs:[edx].OI_pNext,ecx           ; Previous points to new next
        Jmp   REMOVE_OI_Done                  ; All Done

REMOVE_OI_HEAD:
        mov   ecx,fs:[eax].OI_pNext           ; Next Item after Item being Deleted
        mov   OI_LIST,ECX                     ; Next point to new next Item
        Jmp   REMOVE_OI_Done                  ; All Done


REMOVE_OI_DONE:
        POP   EDX
        POP   ECX
        POPFD
        RET
EndProc REMOVE_OI

;***************************************************************************
;* FUNCTION:    Find a Open Instance (OI) in the OI_LIST
;*
;* INPUT:
;*              CX  = File Handle/Open Instance to Find
;*
;* EXIT-NORMAL: EAX  = pointer to OI
;*
;*
;* EXIT_ERROR:  EAX = 0 (not in the List)
;*
;***************************************************************************
Procedure FIND_OI,FAR
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

        PUSHFD
        PUSH  ECX
        CLI                                   ; Turn Off Interrupt (Critical Section)

        MOV   EAX,OI_List                     ; Find first OI in the List
FIND_OI_Next:
        CMP   EAX,0                           ; Is list Empty?
        je    FIND_OI_NIL                     ; - Not in List

        cmp   fs:[eax].OI_FileNum,cx          ; Is this to correct OI
        je    FIND_OI_DONE                    ; We Found the OI

        mov   eax,fs:[eax].OI_pNext           ; Try next OI
        jmp   FIND_OI_Next                    ; Loop until all OI(s) are checked


FIND_OI_NIL:                                  ; Not in the List

FIND_OI_DONE:                                 ; We Found the OI


        POP   ECX
        POPFD
        RET
EndProc FIND_OI



;***************************************************************************
;* FUNCTION:    Add Item to trace Record
;*
;* INPUT:
;*              SS:SP+2  = 16 bytes of data to trace
;*
;* EXIT-NORMAL:
;***************************************************************************
Procedure ADD_TR,NEAR
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

        lbegin 60
   ;*********************************************
   ; Parameters on stack
        Data1                   equ ebp+18
        Data2                   equ ebp+14
        Data3                   equ ebp+10
        Data4                   equ ebp+06
   ;*********************************************
   ; Local Parameters on stack
        hm                     equ ebp-4
        sf                     equ ebp-8
        tr                     equ ebp-12
        cnth                   equ ebp-16
        cntl                   equ ebp-20
        h                      equ ebp-24
        m                      equ ebp-28
        s                      equ ebp-32
        f                      equ ebp-36
        cnt                    equ ebp-40
        ms_delta               equ ebp-44
        s_tcurr                equ ebp-48
   ;*********************************************

        PUSHFD
        PUSH  EBX
        PUSH  EAX
        CLI                                   ; Turn Off Interrupt (Critical Section)


        ; Find next entry in circular trace buffer
        mov   eax,rm_tcurr
        mov   [s_tcurr],eax
;       add   eax,32
        add   eax,16
        cmp   eax,offset rm_te
        jl    T_log

        ; Trace buffer is full wrap around to start
        mov   eax,offset rm_ts
t_log:
        ;Update current pointer and log data to trace buffer
        mov   rm_tcurr,eax
        mov   ebx,[data1]
         ; Get Time
         push    gs                  ; Save Segment for Card
         push    eax
         mov     ax,[Ginfo_Seg]      ; Global Info Segment
         mov     bx,0                ; No Time value to read yet
         cmp     ax,0
         je      init_not_done
         mov     gs,ax               ; Load Segment for Global Info
         mov     bx ,[Ginfo_offset]  ; Global Info Offset
         mov     bx,gs:[bx+4]        ; Read Global Info tenths of milliseconds
         mov     todc,bx
; use MS clock instead
         mov     eax, _ms_clock
         sub     eax, Start_time
         mov     bx,ax
         mov     [ms_delta],bx
         mov     eax,_ms_clock
         mov     start_time,eax

init_not_done:
         pop     eax
         pop     gs

        push  eax
        ror   ebx,16
        mov   bx,todc
        sub   bx,last_log
        mov   ax,todc
        mov   last_log,ax     ; Make 2nd word Time of day clock
        ror   ebx,16
        pop   eax

         ; Get The Video Scr Value
         push  eax
         push  edx
         push  es
         call  _CL450GetScr
         shl   edx,16
         mov   dx,ax
         mov   ebx,edx
         pop   es
         pop   edx
         pop   eax

        mov   ds:[eax+00],ebx
        mov   ebx,[data2]

        mov   ds:[eax+04],ebx

        mov   ebx,[data3]
        mov   ds:[eax+08],ebx
        mov   ebx,[data4]
        mov   ds:[eax+12],ebx

;delay_too_small:
        jmp   skip_time_Info2
        xor   ebx,ebx
        mov   bl,[h]
        shl   ebx,8
        mov   bl,[m]
        shl   ebx,8
        mov   bl,[s]
        shl   ebx,8
        mov   bl,[f]
        mov   ds:[eax+16],ebx
        mov   ebx,0FFFFFFFFh
        mov   ds:[eax+20],ebx
        mov   bx,[tr]
        mov   ds:[eax+24],ebx
        mov   ebx,[cnt]
        mov   ds:[eax+28],ebx
skip_time_Info2:
         mov   bx,[ms_delta]
         cmp   bx,[dl_delta]
;         jge   leave_log
;         mov   eax,[s_tcurr]
;         mov   rm_tcurr,eax
;         jl   leave_log
;         int 3

leave_log:

        POP   EAX
        POP   EBX
        POPFD
        lend
        RET
EndProc ADD_TR



;***************************************************************************
;* FUNCTION:    My Dos Sleep (Sleep n Milliseconds)
;*              Some H/W just has to have itme to go from one state to
;*              another
;*
;* INPUT:
;*              SS:SP+2  = WORD n Milliseconds to sleep
;*
;* EXIT-NORMAL:
;***************************************************************************
Procedure _My_DosSleep,NEAR
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

        lbegin 0
   ;*********************************************
   ; Parameters on stack
        Sleep_time             equ ebp+06
   ;*********************************************

        PUSHFD
        PUSHAD
        CLI                             ; Turn Off Interrupt (Critical Section)

        mov     bx,ds                   ; Make up an event ID Low
        mov     ax,offset Defaults      ; Makeup and Event ID High
        mov     di,0                    ; Time out High
        mov     cx,[sleep_time]         ; Time out N Milliseconds
        mov     dh,1                    ; Non-interruptable sleep
        mov     dl,Devhlp_procblock     ; 
        call    device_hlp              ; 
        cli

        POPAD
        POPFD
        lend
        RET
EndProc _MY_DosSleep



_TEXT ENDS

;    End of CODE segment
;
;*******************************************************************************
        END

