;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
.386p
INCL_DOSMISC    EQU     1
.xlist
include devsym.inc
include devhlp.inc
include basemaca.inc
.list

EXTRN   DOS32FLATDS:ABS              ; 32 bit r/w FLAT selector
EXTRN   INT_HAND:FAR                 ; Interrupt handler for Card
EXTRN   _Disableeverything:NEAR      ; Disable the card and it components
EXTRN   PaletteCheck:FAR
EXTRN   _endofcode:NEAR
EXTRN   _Vidinit:NEAR

stdout          equ     1            ;Standard device handles
cr              equ     0dh          ; ASCII carriage return
lf              equ     0ah          ; ASCII linefeed

                extrn   DosWrite:far
                extrn   DosOpen:far
                extrn   DosRead:far
                extrn   DosQFileInfo:far
                extrn   DosClose:far

;*********************************************
; Define the C calling macros
LBegin  macro len
        push    ebp
        mov     ebp,esp
        sub     esp,len
        endm
LEnd    macro
        mov     esp,ebp
        pop     ebp
        endm
;*********************************************
;*************************************************************************************************************
_TEXT   SEGMENT  DWORD USE16 PUBLIC 'CODE'
        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT

;***********************************
; END OF CODE SEGMENT (MUST BE LAST)
;***********************************
;        PUBLIC  END_OF_CODE
;END_OF_CODE     EQU     $

_TEXT   ENDS
;*************************************************************************************************************

;*************************************************************************************************************
CONST   SEGMENT  WORD PUBLIC USE16 'CONST'    ; Of the 3 C compiler created data
        EXTRN   _Endofdata:word       ; 
CONST   ENDS

INIT_DATA SEGMENT WORD PUBLIC 'INITDATA' USE16

temp    dd      0

INIT_DATA ENDS

;*************************************************************************************************************
_DATA   SEGMENT  DWORD PUBLIC 'DATA' USE16
        EXTRN   FlatSel:WORD
        EXTRN   selector1:WORD        ; Segment address for Cards RAM
        EXTRN   named:BYTE
        EXTRN   device_hlp:DWORD
        EXTRN   Ginfo_Seg:WORD        ; Global Info Segment
        EXTRN   Ginfo_offset:WORD     ; Global Info Offset
        EXTRN   lsw_phys_add:WORD     ; Real 32 bit address LSW FROM SYSTEM
        EXTRN   msw_phys_add:WORD     ; Real 32 bit address MSW FROM SYSTEM
        EXTRN   Intr_level:BYTE       ; Interrupt level number for Card
        EXTRN   OI_LIST:DWORD         ; Open Instances List
        EXTRN   OI_CURR:DWORD         ; Current Open Instance
        EXTRN   Frame_info:byte       ; 
        EXTRN   BoardID:word          ; 


;-------------------------------------------------------------------------------
;Structure of an INIT request packet
;-------------------------------------------------------------------------------
IP       equ   es:[bx]          ;Request packet
INITpkt  struc
         db      ?
         db      ?
_Cmd     db      ?                      ; Command code
_Stat    dw      ?                      ; Status word
         dd      ?
         dd      ?
         db      ?
_DHptr   dd      ?                      ; dev help pointer
_I_parms dd      ?                      ; Parms on "DEVICE=" in config.sys
         db      ?
INITpkt  ends

not_available     equ     22h  ;-222    ; This capture device is not available

public _b_dir

msg_1   db      cr,lf,lf
        db      'OS/2 Sample MPEG Video device driver loaded.  Version 0.01'
msg_nl  db      cr,lf
msg_1_len equ   $-msg_1

msg_10  equ $
        db      'Base I/O                      = '
b_io    db      '                 '
        db      cr,lf
        db      'Board ID                      = '
b_id    db      '                 '
        db      cr,lf
        db      'Device Num                    = '
b_num   db      '                 '
        db      cr,lf
;        db      'IRQ Num                       = '
;b_irq   db      '                 '
;        db      cr,lf
;        db      'DSP Code Directory            = '
                ;123456789012345678901234567890123456789012345678901234567890
_b_dir  db      '                                                            '
        db      '                                                            '
        db      cr,lf
msg_10_len equ   $-msg_10

msg_ok equ $
        db      'Initialiaztion Successfull      '
        db      cr,lf
msg_ok_len equ   $-msg_ok

msg_fa equ $
        db      '*** ERROR *** >>>> '
                ;0        1         2         3         4         5
                ;1234567890123456789012345678901234567890123456789012345
b_err   db      '                                                       '
        db      ' <<<<'
        db      cr,lf
        db      'Initialiaztion Failed           '
        db      cr,lf
msg_fa_len equ   $-msg_fa

msg_t   db      '    '
        db      cr,lf
msg_t_len equ   $-msg_t

msg_PFi  db     ' VGA Palette Fix Up - Invoked '
msg_PFi_len equ   $-msg_PFi
msg_PFc  db     ' VGA Palette Fix Up - Completed'
msg_PFc_len equ   $-msg_PFc

msg_Pal   db     ' VGA Pallette '
          db     '     '
msg_Pali  db     '        '
msg_pal_len equ   $-msg_PAl
public pal_raw
pal_raw   dd     257 dup(0)


wlen    dw      ?
card_id db      0
parm_es         dw   0       ; parameter packet Selector
parm_bx         dw   0       ; parameter packet Offset
mapping         db   0       ; Mapping to cards base memory address

; Possible base address for card (Note: uppercase)
;                                    Note: this must match with table below
base_io_list  equ $
;                123456789A
        db      ' /IO:'

; Possible Interrupt for the  card
;
base_IRQ_list  equ $
;                1234567
        db      ' /IRQ10'
        db      ' /IRQ11'
        db      ' /IRQ15'

; Possible Interrupt for the Card
;                                    Note: this must match with above table
base_IRQ_list2  equ $
        db      10
        db      11
        db      15

; IRQ value to program H/W with
;                                    Note: this must match with above table
base_IRQ_list_HW  equ $
        db      01b
        db      10b
        db      11b

IRQ_to_HW db    0            ; Value to set H/W to correct Interrupt level

; Possible Names for the PDD
;
base_name_list  equ $
;                123456789
        db      ' /1'
        db      ' /2'
        db      ' /3'
        db      ' /4'
        db      ' /5'
        db      ' /6'
        db      ' /7'
        db      ' /8'
        db      ' /9'
        db      ' /1'          ; Default
board_num db 0                 ; Which board is this (0-7)

Frame_info_list  equ $
;                123456789
        db      ' /FI'


;code_dir    equ $
;;                123456789012
;        db      '\VIDRMS.SYS '



StackUsage      equ $                   ; pg 5-47 of os2 Device Drivers book
  SU_cbStruc    DW 14                   ; Size of structure
  SU_flags      DW ?                    ; Flags
  SU_iIRQ       DW ?                    ; IRQ being handled
  SU_cbStackCLI DW ?                    ; bytes used during CLI
  SU_cbStackSTI DW ?                    ; bytes used during STI
  SU_cbStackEOI DW ?                    ; bytes used during EOI
  SU_cNest      DW ?                    ; Nesting Levels
;StackUsage     ENDS


public RMBASE
RMBase          dw      0000h


;end_of_data equ $
_DATA   ENDS


;*************************************************************************************************************
;_TEXT   SEGMENT WORD PUBLIC 'CODE' USE16
;        EXTRN   END_OF_CODE:ABS
;_TEXT   ENDS


;*************************************************************************************************************
INIT_TEXT SEGMENT WORD PUBLIC 'INITCODE' USE16
        ASSUME cs:INIT_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
subttl Initialization Code
page


;-------------------------------------------------------------------------------
; Initialization procedure is placed at the end of the code so it can go away
;  once initialization has been done.
;-------------------------------------------------------------------------------

Procedure INIT,FAR
        ASSUME cs:INIT_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
        LBegin   40H
   ;*********************************************
   ; Local Parameters on stack
        action                  equ ebp-4
        fhandle                 equ ebp-8
        fileStatus_end          equ ebp-0Ch
        fileStatus              equ ebp-0Ch-18H
        bytes_read              equ ebp-0Ch-18H-4

;
; Save DevHlp entry point, end-of-segment offsets, and display message...
;
         mov   [parm_es],es             ; save pointer to parameter packet
         mov   [parm_bx],bx             ; save pointer to parameter packet

         mov   [OI_LIST],0h             ; No Open Instances
         mov   [OI_CURR],0h             ; No Current Open Instance
         mov   ax,word ptr IP._DHptr    ; get DevHlp entry point
         mov   word ptr device_hlp,ax   ; 
         mov   ax,word ptr IP._DHptr+2  ; 
         mov   word ptr device_hlp+2,ax ; 

         mov   ax,offset _ENDOFCODE     ; Return end of resident code seg
         mov   word ptr IP._DHptr,ax    ; and data segments
         mov   ax,offset CONST:_endofdata ;end of data
         mov   word ptr IP._DHptr+2,ax  ; 

         mov    ax,stdout               ; standard output handle
         push   ax                      ; 
         push   ds                      ; address of message
         mov    ax,offset _DATA:msg_1
         push   ax
         mov    ax,msg_1_len            ; length of message
         push   ax                      ; 
         push   ds                      ; address to word that
         mov    ax,offset _DATA:wlen     ; receives bytes written
         push   ax                      ; 
         call   DosWrite                ; transfer to OS/2


        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .


;**** Find Frame Info Requested for Device Driver **********
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si, offset Frame_info_list; table of FI
        mov   bx, 4                     ; Size of an entry in the table
        mov   cx, 1                     ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
                                        ; defaults to last name in table
                                        ;  of entries = '1'
        mov   frame_info,0              ; Assume Frame Info not wanted
        CMP   cx,0
        jne   skip_fi
        mov   frame_info,1
skip_fi:

        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .



;**** Find name for Device Driver **********
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si, offset base_name_list ; table of possible names for PDD
        mov   bx, 3                     ; Size of an entry in the table
        mov   cx, 9                     ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
                                        ; defaults to last name in table
                                        ;  of entries = '1'
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .

name_found:
        mov   board_num,cl              ; Save Board Number (0-7)
        mov   si, offset base_name_list
        mov   ax,cx
        shl   ax,1
        add   cx,ax
        add   cx,2
        add   si,cx
        mov   al,ds:[si]
        mov   Byte ptr named+6,al       ; Change name of PDD on the fly


;;**** Find IRQ Number for the card **********
;        mov   bx,[parm_bx]              ; restore request packet pointer
;        mov   es,[parm_es]              ; .
;        mov   di,word ptr IP._I_Parms   ; get Device= parms address
;        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
;        mov   si, offset base_IRQ_list  ; table of possible IRQ Numbers
;        mov   bx, 7                     ; Size of an entry in the table
;        mov   cx, 3                     ; Number of an entries in the table
;        Call  FDEVICE                   ; Find IRQ parm on DEVICE=
;        mov   bx,[parm_bx]              ; restore request packet pointer
;        mov   es,[parm_es]              ; .
;        cmp   cx,3                      ; Was a valid IRQ entry found
;        jne   irq_found                 ; Yes - no problem
;
;        ; Why it failed ...
;         mov    di,offset b_IRQ
;         mov    byte ptr ds:[di-1],'>'  ; put a '>' by failure in msg line
;
;        jmp   T_INITX                   ; Exit with error
;
;irq_found:
;        mov   si, offset base_IRQ_list2
;        add   si,cx
;        mov   al,ds:[si]
;        mov   intr_level,al             ; Save IRQ number
;        mov   si, offset base_IRQ_list_HW
;        add   si,cx
;        mov   al,ds:[si]
;        mov   irq_to_hw,al             ; Save IRQ value for H/W
;
        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .


;**** Find I/O Base Address for the card **********
        mov   di,word ptr IP._I_Parms   ; get Device= parms address
        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
        mov   si,offset base_io_list    ; table of possible IO addr for card
        mov   bx, 5                     ; Size of an entry in the table
        mov   cx, 1                     ; Number of an entries in the table
        Call  FDEVICE                   ; Find Addr parm on DEVICE=
        cmp   cx, 1                     ; Was a match found
        jne   io_found                  ; Valid Address was found
        mov   ax,not_available          ; card address not valid

io_invalid:
        ; Why it failed ...
        mov    di,offset b_io
        mov    byte ptr ds:[di-1],'>' ; put a  failure in msg line

        jmp   T_INITX_F               ; Exit with error

io_found:
        mov   si,di
        add   si,5
        mov   di,offset RMbase
        mov   cx,4                      ; Bytes to convert
        call  TOHEX

        cmp   cx, 0                     ; did it convert
        jne   io_not_converd            ; Port Address was not converted
        mov   cx,rmbase
        cmp   cx,03ffh                  ; Must be between 0 and 3FF
        jg    io_invalid
        and   cx,3                      ; Must be on 4 byte address
        jnz   io_invalid
        jmp   io_ok                     ; Port Address was converted and Valid
io_not_converd:                         ; Port Address was not converted
        mov   RMBase,0
        mov   di,offset b_io
        mov   byte ptr ds:[di-1],'?'   ; put a '?' by failure in msg line
        jmp   T_INITX_F                ; Exit with error

io_ok:

        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .


;;**** Find Directory where code was installed **********
;        mov   di,word ptr IP._I_Parms   ; get Device= parms address
;        mov   es,word ptr IP._I_Parms+2 ; get Device= parms address
;        mov   si,offset code_dir        ; table of device = directory info
;        mov   bx, 12                    ; Size of an entry in the table
;        mov   cx, 1                     ; Number of an entries in the table
;        Call  FDEVICE                   ; Find Addr parm on DEVICE=
;        cmp   cx, 1                     ; Was a match found
;        jne   DIR_found                 ; Device=Dir found
;        mov   ax,not_available          ; card address not valid
;
;        ; Why it failed ...
;         mov    di,offset _b_dir
;         mov    byte ptr ds:[di-1],'>' ; put a  failure in msg line
;
;        jmp   T_INITX                   ; Exit with error
;
;dir_found:
;        mov   bx,[parm_bx]              ; restore request packet pointer
;        mov   es,[parm_es]              ; .
;        mov   cx,di                     ; end of dir...\VIDRMS.SYS
;        sub   cx,word ptr IP._I_Parms   ; start of DEVICE=dir...\VIDRMS.SYS
;                                        ; Lenght of Directory name
;        mov   si,word ptr IP._I_Parms   ; start of DEVICE=dir...\VIDRMS.SYS
;        mov   di,offset _b_dir          ; Display line
;copy_dir:
;        mov   al,es:[si]
;        mov   ds:[di],al
;        inc   si
;        inc   di
;        loop  copy_dir
;        ;Fill in DSP file name for Audio functions
;        mov   BYTE PTR ds:[di+00],'\'
;        mov   BYTE PTR ds:[di+01],'1'
;        mov   BYTE PTR ds:[di+02],'2'
;        mov   BYTE PTR ds:[di+03],'3'
;        mov   BYTE PTR ds:[di+04],'4'
;        mov   BYTE PTR ds:[di+05],'D'
;        mov   BYTE PTR ds:[di+06],'S'
;        mov   BYTE PTR ds:[di+07],'P'
;        mov   BYTE PTR ds:[di+08],'.'
;        mov   BYTE PTR ds:[di+09],'B'
;        mov   BYTE PTR ds:[di+10],'I'
;        mov   BYTE PTR ds:[di+11],'N'
;        mov   BYTE PTR ds:[di+12],00h


Check_if_V_Card:
;**************************************************************************
        ; Maufactures suggest way to tell if this is a xxxxxxc card
;**************************************************************************
;********** Check if card is present  *******************
;********** Add Code Here .....
;********** Add Code Here .....
;********** Add Code Here .....
;********** Add Code Here .....
         pushad
         mov  dx,0
         push dx              ; Board ID (0 - normal, 1- Lite)
         mov  dx,RMBase
         push dx

;********** Check if card is present  *******************
         call SetBaseAddress
         add  esp,4
         mov  boardid,ax
         cmp  ax,-1
         popad
         jnz  read_back_ok    ; Read_back bit indicates card is present

Card_ID_Failed:
        ; Why it failed ...
         mov    di,offset b_err
         mov    byte ptr ds:[di+06],'C' ; put a  failure in msg line
         mov    byte ptr ds:[di+07],'A' ; put a  failure in msg line
         mov    byte ptr ds:[di+08],'R' ; put a  failure in msg line
         mov    byte ptr ds:[di+09],'D' ; put a  failure in msg line
         mov    byte ptr ds:[di+10],' ' ; put a  failure in msg line
         mov    byte ptr ds:[di+11],'N' ; put a  failure in msg line
         mov    byte ptr ds:[di+12],'O' ; put a  failure in msg line
         mov    byte ptr ds:[di+13],'T' ; put a  failure in msg line
         mov    byte ptr ds:[di+14],' ' ; put a  failure in msg line
         mov    byte ptr ds:[di+15],'R' ; put a  failure in msg line
         mov    byte ptr ds:[di+16],'E' ; put a  failure in msg line
         mov    byte ptr ds:[di+17],'S' ; put a  failure in msg line
         mov    byte ptr ds:[di+18],'P' ; put a  failure in msg line
         mov    byte ptr ds:[di+19],'O' ; put a  failure in msg line
         mov    byte ptr ds:[di+20],'N' ; put a  failure in msg line
         mov    byte ptr ds:[di+21],'D' ; put a  failure in msg line
         mov    byte ptr ds:[di+22],'I' ; put a  failure in msg line
         mov    byte ptr ds:[di+23],'N' ; put a  failure in msg line
         mov    byte ptr ds:[di+24],'G' ; put a  failure in msg line
         mov    ax,not_available        ; card address not valid
         jmp   T_INITX                  ; Exit with error

Read_back_OK:
;********** Read-Back Bit is OK card is present ************

got_V_Card:
; ******** Card Appears to be valid ***********************



        mov   bx,[parm_bx]              ; restore request packet pointer
        mov   es,[parm_es]              ; .



        call _DisableEverything

Mpeg_installed:

          cmp BoardID,1234                 ; Is this the xxx card
          je  lite_card

          ; Install/enable extra feature on the card

lite_card:

; Code below will read the palette from the sytem DAC and Program the
; the overlay cards DAC with the Matching Palette
;          Call _Vidinit
;           push  Msg_PFi_Len
;           push  ds
;           push  offset Msg_PFi
;           call  _WriteCon
;           call  _NewLine
;           Call _VidSoftSnoop   ; load Card's DAC from the system DAC
;           push  Msg_PFc_Len
;           push  ds
;           push  offset Msg_PFc
;           call  _WriteCon
;           call  _NewLine
;
;
;        cmp frame_info,0
;        je  skip_palette_print
;;KLLLLLL temp info
;; Print Palette Info on the system screen
;        push  ecx
;        mov   ecx,256
;
;pal_loop:
;        mov   si,offset pal_raw
;        mov   di,offset msg_pali
;        shl   ecx,2
;        add   si,cx
;        shr   ecx,2
;        sub   ecx,1
;        mov   ds:[si+3],cl
;        add   ecx,1
;        pushad
;         mov    ecx,4
;         call   tochar
;           push  Msg_Pal_Len
;           push  ds
;           push  offset Msg_Pal
;           call  _WriteCon
;           call  _NewLine
;        popad
;        loop pal_loop
;skip_palette_print:
;        mov   si,offset pal_raw
;
;           ;Set A timer for now to tell us to check for pallet changes
;           ;every so often (if it has changed it will be reloaded).
;           mov  ax,offset PaletteCheck ; Handler to check for pallete change
;           mov  bx,100                    ; Notify once every 3 Second
;           mov  dl,DevHlp_tickCount
;           call Device_hlp


; Sample has no H/W Interrupts so skip this code
;;------------------------------------------------------------
;; Attach the DD to IRQ for interrupts
;;  Not all PC allow interrupt shareing. We will first try to get the
;;  interrupt as Shared and if that fails we try it as Unshared
;;  and if that fails the DD will fail the Init
;;------------------------------------------------------------
;         mov     ax, offset _TEXT:INT_HAND     ; Handler
;         sub     bx, bx                        ; zero bx
;         mov     bl, Intr_level                ; IRQ channel Number
;         mov     dh, 1                         ; Share interrupt
;                                               ;   not all PCs support share
;         mov     dl, DevHlp_SetIRQ             ; Set the IRQ
;         call    device_hlp                    ;
;         mov     ax, 05                        ; assume IRQ linkage failed
;         jnc     got_intr
;         mov     ax, offset _TEXT:INT_HAND     ; Handler
;         sub     bx, bx                        ; zero bx
;         mov     bl, Intr_level                ; IRQ channel Number
;         mov     dh, 0                         ; Don't share interrupt
;                                               ;   not all PCs support share
;         mov     dl, DevHlp_SetIRQ             ; Set the IRQ
;         call    device_hlp                    ;
;         jnc     Got_intr
;         mov     di,offset b_irq
;         mov     byte ptr ds:[di-1],'*'        ; put a '*' by failure in msg line
;         mov     ax, 05                        ; assume IRQ linkage failed
;         jmp     T_INITX                       ; Exit with error
;got_intr:                                      ; OK we got our Interrupt
;;------------------------------------------------------------
;; Indicate the Stack Usage for the interrupt processor
;;------------------------------------------------------------
;         mov     bx, offset StackUsage
;         mov     SU_flags,       01  ; Handler enables interrupts
;         mov     al,Intr_Level       ; IRQ  Number
;         mov     ah,     0
;         mov     SU_iIRQ,        ax  ; IRQ Channel Number
;         mov     SU_cbStackCLI,1000  ; 100 bytes used during CLI
;         mov     SU_cbStackSTI, 200  ; 100 bytes used during STI
;         mov     SU_cbStackEOI, 200  ; 200 bytes used during EOI
;         mov     SU_cNest,       02  ; Nest 2 interrupts
;         mov     dl, DevHlp_RegisterStackUsage
;         call    device_hlp          ;
;         mov     ax, 04              ; assume Stack usage failed
;         jc      T_INITX



; Allocate a GDT Selector
;
        mov     ax, ds                          ; es gets upper address
        mov     es, ax
        lea     di, Selector1                   ; Get the Selector Address
        mov     cx, 1                           ; One selector
        mov     dl, DevHlp_AllocGDTSelector

        call  device_hlp
        mov     ax,not_available          ; Assume allocate GDT failed
        jc      T_INITX                   ; Exit with error
;
; Get FLAT selector
;
        mov     ax,DOS32FLATDS                  ; Get r/w FLAT selector
        mov     FlatSel,ax                      ; Save for later
        mov     fs,ax                           ; setup flat Selector

;Map Physical Address to GDT selector for all can access (Interrupt and Task time)
        mov     ax,msw_phys_add              ; Physical Address to be mapped
        mov     bx,lsw_phys_add              ; Physical Address to be mapped
        mov     si, Selector1                ; Get the Selector Address
        mov     cx, 8192                     ; Lenght of area to be mapped
        mov     dl, DevHlp_PhystoGDTSelector
        call  device_hlp
        mov     ax,not_available             ; Assume allocate GDT failed
        jc      T_INITX                      ; Exit with error



; Initialize the card
        PUSHFD
        CLI

        POPFD


;!!!!!!!!  Get Addess of DOS Varible (need time info)
        mov     al,1                ; Get Global Info Seg
        mov     dl,DevHlp_GetDOSVar ; Function = GetDOSVar
        call    device_hlp          ; Call DevHlp
        jc      T_INITX_F           ; If Error occured exit with error
        push    es
        mov     es,ax               ; Selector
        les     bx,es:[bx]          ; get pointer  to pointer
        mov     [Ginfo_Seg],bx      ; Global Info Segment
        mov     [Ginfo_offset],es   ; Global Info Offset
        pop     es

        jmp     T_INIT_OK

T_INITX_F:
        mov     ax,not_available      ; Could Not Initialize
        jmp     T_INITX

T_INIT_OK:

         mov   bx,[parm_bx]             ; restore request packet pointer
         mov   es,[parm_es]             ; .
         sub   ax,ax                  ; indicate no error
         cmp   frame_info,1           ; Print out Config Info
         je    T_INITX
         jmp   init_done

T_INITX:
        ; Set up Info ... to display
         push   ax
         mov    di,offset b_io
         mov    si,offset RMBase
         mov    cx,2
         call   tochar

         mov    di,offset b_id
         mov    si,offset boardid
         mov    cx,2
         call   tochar

;         mov    di,offset b_irq
;         mov    si,offset intr_level
;         mov    cx,1
;         call   tochar

         mov    di,offset b_io
         mov    si,offset RMBase
         mov    cx,2
         call   tochar

         mov    al,Byte ptr named+6      ; PDD name/number
         mov    di,offset b_num
         mov    ds:[di],al

         mov    ax,stdout               ; standard output handle
         push   ax                      ; 
         push   ds                      ; address of message
         mov    ax,offset _DATA:msg_10
         push   ax
         mov    ax,msg_10_len           ; length of message
         push   ax                      ; 
         push   ds                      ; address to word that
         mov    ax,offset _DATA:wlen     ; receives bytes written
         push   ax                      ; 
         call   DosWrite                ; transfer to OS/2
         mov   bx,[parm_bx]             ; restore request packet pointer
         mov   es,[parm_es]             ; .

         pop    ax

; Print to Console Init Completed Success/Fail message
         push   ax                      ; Get Inits Status
         mov    cx,ax
         mov    ax,stdout               ; standard output handle
         push   ax                      ; 
         push   ds                      ; address of message
         cmp    cx,0
         je     init_done_ok_msg
         ; Init Failed Message
         mov    ax,offset _DATA:msg_fa
         push   ax
         mov    ax,msg_fa_len           ; length of message
         jmp    init_done_msg
init_done_ok_msg:
         ; Init Failed Message
         mov    ax,offset _DATA:msg_ok
         push   ax
         mov    ax,msg_ok_len           ; length of message
init_done_msg:
         push   ax                      ; 
         push   ds                      ; address to word that
         mov    ax,offset _DATA:wlen     ; receives bytes written
         push   ax                      ; 
         call   DosWrite                ; transfer to OS/2

         mov   bx,[parm_bx]             ; restore request packet pointer
         mov   es,[parm_es]             ; .
         pop   ax
Init_done:
         lend
         ret
EndProc INIT
;INIT     ENDP

;---------------------------------------------------------------------------
; FDEVICE
;
; Find Parms on the Device= Statement from the Config.Sys
; from a list of items to search for
;
; INPUTS:
;
;   ES:DI = pointer to parms on the DEVICE= statement
;      SI = Pointer to list of Items to search for on the DEVICE=
;      BX = Size of an Entry in the Table SI points to
;      CL = Nuber of Entries in the Table SI points to
;
;
; OUTPUT:
;      CL = Number of the Entry where a match was found
;           (0        = first  entry)
;           (1        = Second entry)
;           (input CX = no match found)
;      DI = Pointer to the Item found on Deveice =
;---------------------------------------------------------------------------
FDEVICE proc  near

         mov   dx,si
         mov   ah,cl
find_Item:
         mov   cx,0
         mov   cl,ah                    ; Entries in table
         mov   si,dx                    ; index for base addr table

next_Item:
         push  cx
         push  di
         mov   cx,bx                    ; size of each table entry

next_I_byte:
         mov   al,es:[di]
         cmp   al, 00h                  ; is it the end of data
         je    end_D_parms
         cmp   ds:[si],al
         jne   try_next_I
         inc   di
         inc   si
         loop  next_I_byte              ; Check next byte of Item
         mov   cx,di
         pop   di
         mov   di,cx                    ; di points to byte after found string
         pop   cx
         jmp   valid_Item               ; valid address was coded

try_next_I:
         add   si,cx                    ; Start of next table entry
         pop   di
         pop   cx
         loop  next_Item
         inc   di                       ; next byte in device= statement
         jmp   find_Item

end_D_parms:
         pop   di
         pop   cx
         mov   cx,0                     ; Item not found


valid_Item:
         sub   di, bx                   ; Pointer to item found

fdevice_exit:
         sub   ah, cl                   ; Entry where match was found
         mov   cl, ah

        ret
FDEVICE endp

;---------------------------------------------------------------------------
; TOCHAR
;
; Convert Hex String to Character for display
;
; INPUTS:
;
;   DS:SI = pointer to Hex String to Convert
;   DS:DI = Pointer to Place to put Char String
;      CX = Number of bytes in input hex string
;
;
; OUTPUT:
;
;---------------------------------------------------------------------------
TOCHAR proc  near

        push  bx
        add   si,cx
        sub   si,1
next_Char:
        MOV   al,ds:[SI]
        dec   si
        mov   bl,al
        shr   al,4
        and   al,0Fh
        cmp   al,9
        ja    char_A_F_1
                                  ; Convert for 0 to 9
        or    al,30h
        jmp   got_char_1

char_A_F_1:                       ; Convert for A to F
        sub   al,9
        or    al,40h

got_char_1:
        mov   ds:[di],al        ; Save Char Result
        inc   di                ; Next Char Postion to write

        ; ---- second digit in byte
        mov   al,bl
        and   al,0Fh
        cmp   al,9
        ja    char_A_F_2
                                  ; Convert for 0 to 9
        or    al,30h
        jmp   got_char_2

char_A_F_2:                       ; Convert for A to F
        sub   al,9
        or    al,40h

got_char_2:
        mov   ds:[di],al        ; Save Char Result
        inc   di                ; Next Char Postion to write

        loop  next_char

        pop   bx
        ret
TOCHAR endp

;---------------------------------------------------------------------------
; TOHEX
;
; Convert Char String to Hex number
;
; INPUTS:
;
;   ES:SI = pointer to Char String to Convert
;   DS:DI = Pointer to Place to put Hex String
;      CX = Number of bytes in input hex string (must be even 2,4,6,8,..)
;
;
; OUTPUT:
;      CX  = 0 success
;      CX != 0 Error
;---------------------------------------------------------------------------
TOHEX proc  near
        push  bx
        add   si,cx
        sub   si,2
next_hex:
        MOV   al,es:[SI]
        mov   ah,al
        and   ah,0F0h
        cmp   ah,40h         ; Upper case A-F
        je    hex_A_F
        cmp   ah,60h         ; Lower case a-f
        je    hex_A_F
        cmp   ah,30h         ; Number 0-9
        je    num_0_9
        jmp   to_hex_done
        ;Got a number  0-9

num_0_9:
        and    al,0Fh
        jmp    to_hex_write

hex_A_F:
        and    al,0Fh
        cmp    al,1
        jl     to_hex_done
        cmp    al,6h
        jg     to_hex_done
        add    al,9h
        jmp    to_hex_write

to_hex_write:
        mov    dl,al
        shl    dl,4

; odd Digit
        MOV   al,es:[SI+1]
        mov   ah,al
        and   ah,0F0h
        cmp   ah,40h         ; Upper case A-F
        je    hex_A_F_2
        cmp   ah,60h         ; Lower case a-f
        je    hex_A_F_2
        cmp   ah,30h         ; Number 0-9
        je    num_0_9_2
        jmp   to_hex_done
        ;Got a number  0-9

num_0_9_2:
        and    al,0Fh
        jmp    to_hex_write_2

hex_A_F_2:
        and    al,0Fh
        cmp    al,1
        jl     to_hex_done
        cmp    al,6h
        jg     to_hex_done
        add    al,9h
        jmp    to_hex_write_2

to_hex_write_2:
        or     al,dl
        mov    ds:[di],al
        sub    si,2
        inc    di
        sub    cx,2
        jne    next_hex

to_hex_done:
        pop   bx
        ret
TOHEX  endp
Procedure _WriteCon, NEAR
        ASSUME cs:INIT_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters on stack
        Msg_off                 equ ebp+6
        Msg_sel                 equ ebp+8
        Msg_Len                 equ ebp+10
   ;*********************************************

                LBegin   0
         pushad
         mov    ax,stdout               ; standard output handle
         push   ax                      ; 
         mov    ax,[msg_sel]
         push   ax                      ; address of message
         mov    ax,[msg_off]
         push   ax
         mov    ax,[Msg_len]            ; length of message
         push   ax                      ; 
         push   ds                      ; address to word that
         mov    ax,offset _DATA:wlen     ; receives bytes written
         push   ax                      ; 
         call   DosWrite                ; transfer to OS/2

        popad
        lend
        ret  6
ENDPROC _WriteCon

Procedure _NewLine, NEAR
        ASSUME cs:INIT_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
   ;*********************************************
   ; Parameters on stack
   ;    - None
   ;*********************************************

                LBegin   0
         pushad
         mov    ax,stdout               ; standard output handle
         push   ax                      ; 
         push   ds                      ; address of message
         mov    ax,offset msg_nl
         push   ax
         mov    ax,2                    ; length of message
         push   ax                      ; 
         push   ds                      ; address to word that
         mov    ax,offset _DATA:wlen     ; receives bytes written
         push   ax                      ; 
         call   DosWrite                ; transfer to OS/2

        popad
        lend
        ret
ENDPROC _NewLine


Procedure SetBaseAddress, NEAR
        ASSUME cs:INIT_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING

   ; Validate card is installed at the address and working ath this address
   ; 
   ; Note: The Board_N parm passed in is unused and on output
   ;       AX will have the Board ID or -1 if board not detected
   ; 
   ;*********************************************
   ; Parameters on stack
        address                 equ ebp+6
        board_n                 equ ebp+8
   ;*********************************************

                LBegin   0
                xor bx,bx
                mov di,[address]

;******** ADD CODE HERE ...........****************************************
;******** ADD CODE HERE ...........****************************************
;******** ADD CODE HERE ...........****************************************
;******** ADD CODE HERE ...........****************************************
;******** ADD CODE HERE ...........****************************************
; Code should verify the card is installed and function at this address
; ....Temp code for this sample assumes card is working.............

                mov ax,0
                jmp @@END
@@Fail:
                mov ax,-1

@@End:
        lend
        ret
ENDPROC SetBaseAddress


INIT_TEXT ENDS
END
