;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
; This file implements C callable runtime routines
; Implemented in assembler prevents use of C runtime provided routine
;******************************************************************************


;******************************************************************************
;
; anlmul.asm - assembler implemented 'C' callable long divide
;
; This file implements a C callable routine for long divide.
; Implemented in assembler prevents use of C runtime provided routine
;******************************************************************************

;include parse.inc
;include vapi.mac

.386p

INCL_DOSMISC    EQU     1
INCL_DOSERRORS  EQU     1
INCL_TYPES      EQU     1
INCL_DEF        EQU     1

include devsym.inc
include basemaca.inc
include basedef.inc


_DATA   SEGMENT  DWORD USE16 PUBLIC 'DATA'      ; changed from code to data
;       ASSUME   CS: FLAT, DS: DATA, SS: FLAT, ES: FLAT

_DATA   ENDS


_TEXT   SEGMENT  DWORD USE16 PUBLIC 'CODE'
        ASSUME   CS: FLAT, DS: FLAT, SS: FLAT, ES: FLAT


;_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
;        ASSUME cs:_TEXT


PUBLIC __aNulmul
PUBLIC __aNlmul

; extern long near pascal _aNlmul(long mul1, long mul2)
; This routine multiplies two long integers and returns result in AX:DX
;
__aNulmul label NEAR
__aNlmul PROC NEAR
        PUSH    BP
        MOV     BP, SP
        MOV     AX, [BP+06]
        MOV     BX, [BP+0Ah]
        OR      BX, AX
        MOV     BX, [BP+08]
        JNZ     @F
        MOV     AX, [BP+04]
        MUL     BX
        MOV     SP, BP
        POP     BP
        RET     0008

        @@:
        MUL     BX
        MOV     CX, AX
        MOV     AX, [BP+04]

        MUL     WORD PTR [BP+0Ah]
        ADD     CX, AX
        MOV     AX, [BP+04]
        MUL     BX
        ADD     DX, CX
        MOV     SP, BP
        POP     BP
        RET     0008

__aNlmul ENDP




;******************************************************************************
;
; anldiv.asm - assembler implemented 'C' callable long divide
;
; This file implements a C callable routine for long divide.
; Implemented in assembler prevents use of C runtime provided routine
;******************************************************************************

PUBLIC __aNldiv

; extern long near pascal _aNldiv(long divisor, long dividend)
; This routine divides two long integers and returns the quotient in AX:DX
;
__aNldiv PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    DI
        PUSH    SI
        PUSH    BX
        XOR     DI,DI
        MOV     AX,[BP+06]
        OR      AX,AX
        JGE     label120
        INC     DI
        MOV     DX,[BP+04]
        NEG     AX
        NEG     DX
        SBB     AX,0000
        MOV     [BP+06],AX
        MOV     [BP+04],DX
label120:
        MOV     AX,[BP+0Ah]
        OR      AX,AX
        JGE     label138
        INC     DI
        MOV     DX,[BP+08]
        NEG     AX
        NEG     DX
        SBB     AX,0000
        MOV     [BP+0Ah],AX
        MOV     [BP+08],DX
label138:
        OR      AX,AX
        JNZ     label151
        MOV     CX,[BP+08]
        MOV     AX,[BP+06]
        XOR     DX,DX
        DIV     CX
        MOV     BX,AX
        MOV     AX,[BP+04]
        DIV     CX
        MOV     DX,BX
        JMP     label189
label151:
        MOV     BX,AX
        MOV     CX,[BP+08]
        MOV     DX,[BP+06]
        MOV     AX,[BP+04]
label15C:
        SHR     BX,1
        RCR     CX,1
        SHR     DX,1
        RCR     AX,1
        OR      BX,BX
        JNZ     label15C
        DIV     CX
        MOV     SI,AX
        MUL     WORD PTR [BP+0Ah]
        XCHG    CX,AX
        MOV     AX,[BP+08]
        MUL     SI
        ADD     DX,CX
        JB      label185
        CMP     DX,[BP+06]
        JA      label185
        JB      label186
        CMP     AX,[BP+04]
        JBE     label186
label185:
        DEC     SI
label186:
        XOR     DX,DX
        XCHG    SI,AX
label189:
        DEC     DI
        JNZ     label193
        NEG     DX
        NEG     AX
        SBB     DX,+00
label193:
        POP     BX
        POP     SI
        POP     DI
        MOV     SP,BP
        POP     BP
        RET     0008
__aNldiv ENDP

PUBLIC __aNldiv
PUBLIC __aNuldiv

; extern long near pascal _aNldiv(unsigned  long divisor, unsigned long dividend)
; This routine divides two long integers and returns the quotient in AX:DX
;
__aNuldiv PROC NEAR
        PUSH    BP
        MOV     BP,SP
        PUSH    DI
        PUSH    SI
        PUSH    BX
        XOR     DI,DI
        MOV     AX,[BP+06]
        OR      AX,AX
        JGE     alabel120
        INC     DI
        MOV     DX,[BP+04]
        NEG     AX
        NEG     DX
        SBB     AX,0000
        MOV     [BP+06],AX
        MOV     [BP+04],DX
alabel120:
        MOV     AX,[BP+0Ah]
        OR      AX,AX
        JGE     alabel138
        INC     DI
        MOV     DX,[BP+08]
        NEG     AX
        NEG     DX
        SBB     AX,0000
        MOV     [BP+0Ah],AX
        MOV     [BP+08],DX
alabel138:
        OR      AX,AX
        JNZ     alabel151
        MOV     CX,[BP+08]
        MOV     AX,[BP+06]
        XOR     DX,DX
        DIV     CX
        MOV     BX,AX
        MOV     AX,[BP+04]
        DIV     CX
        MOV     DX,BX
        JMP     alabel189
alabel151:
        MOV     BX,AX
        MOV     CX,[BP+08]
        MOV     DX,[BP+06]
        MOV     AX,[BP+04]
alabel15C:
        SHR     BX,1
        RCR     CX,1
        SHR     DX,1
        RCR     AX,1
        OR      BX,BX
        JNZ     alabel15C
        DIV     CX
        MOV     SI,AX
        MUL     WORD PTR [BP+0Ah]
        XCHG    CX,AX
        MOV     AX,[BP+08]
        MUL     SI
        ADD     DX,CX
        JB      alabel185
        CMP     DX,[BP+06]
        JA      alabel185
        JB      alabel186
        CMP     AX,[BP+04]
        JBE     alabel186
alabel185:
        DEC     SI
alabel186:
        XOR     DX,DX
        XCHG    SI,AX
alabel189:
        DEC     DI
        JNZ     alabel193
        NEG     DX
        NEG     AX
        SBB     DX,+00
alabel193:
        POP     BX
        POP     SI
        POP     DI
        MOV     SP,BP
        POP     BP
        RET     0008
__aNuldiv ENDP


_TEXT   ENDS
END
