;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
.386p

_DATA           SEGMENT DWORD USE32 PUBLIC 'DATA'       ; Global data segment
_DATA           ENDS

_TEXT           SEGMENT DWORD USE32 PUBLIC 'CODE'
                ASSUME  CS:FLAT, DS:FLAT, ES:FLAT, SS:FLAT

extrn  Init                    : near
extrn  IDCEntryFromAudioPDD_c  : near
extrn  IDCEntryFromWakeupPDD_c : near

; Route calls from 16:16 PDDs to 16:32 VDD code
;
; Stack
;            --------
;       +20 | ulFunc | Function code
;           |--------|
;       +16 |  ul1   | usually, PDD handle (index into Adapters table)
;           |--------|
;       +12 |  ul2   | Function specific parm (usually, not used)
;           |--------|
;       +8  |  sel   | Return selector
;           |--------|
;       +4  | offset | Return offset
;           |--------|
; SS:EBP -> |  ebp   | Callers frame pointer
;            --------

ulFunc  EQU DWORD PTR [ebp+20]  ; Pascal conventions push parms left to right
ul1     EQU DWORD PTR [ebp+16]  ; 8 bytes for 16:32 far return address
ul2     EQU DWORD PTR [ebp+12]

        public  IDCEntryFromAudioPDD
IDCEntryFromAudioPDD PROC FAR
        push    ebp
        mov     ebp, esp
        push    ds                              ; Preserve callers registers
        push    es
        mov     ax, SEG FLAT:_DATA
        push    ulFunc                          ; Propagate the parms (pascal)
        mov     ds, ax
        push    ul1
        mov     es, ax
        push    ul2
        call    IDCEntryFromAudioPDD_c
        pop     es                              ; Restore callers registers
        pop     ds
        leave                                   ; Restore stack frame
        db      67h                             ; Force 16:16 return
        ret     0Ch                             ; Return far to PDD
IDCEntryFromAudioPDD ENDP

        public  IDCEntryFromWakeupPDD
IDCEntryFromWakeupPDD PROC FAR
        push    ebp
        mov     ebp, esp
        push    ds                              ; Preserve callers registers
        push    es
        mov     ax, SEG FLAT:_DATA
        push    ulFunc                          ; Propagate the parms (pascal)
        mov     ds, ax
        push    ul1
        mov     es, ax
        push    ul2
        call    IDCEntryFromWakeupPDD_c
        pop     es                              ; Restore callers registers
        pop     ds
        leave                                   ; Restore stack frame
        db      67h                             ; Force 16:16 return
        ret     0Ch                             ; Return far to PDD
IDCEntryFromWakeupPDD ENDP

_TEXT           ENDS
end Init        ; Set VDD entrypoint
