/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* init.asm - VDD initialization
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* This file contains the VDD initialization routine.  It is called by the
* loader during system initialization (boot).
* Purpose:
*    Parse config.sys command line
*    Establish communication with Physical Device Driver(s)
*    Hook Virtual DOS Machine events (create session, close session)
*
* After initialization, this segment is discardable.  That is, the OS
* may, at its leasure, throw this segment away.  As VDDs are structured
* like DLLs, the OS locks the .sys file so it can re-load this segment.
* Being initialization code, this segment is never again needed and
* remains permanently discarded.
*
* Note: The OS/2 Virtual Dev Help calls (VDHxxx) use pascal calling convention
* and preserve registers according to 'C' standards.
* EBX, EBP, ESI, EDI and the segment regs are preserved.
* Calling code has to protect ECX and EDX when it matters.
*
******************************************************************************/

#pragma code_seg ("CINIT_TEXT");        // Segment discarded after boot

#include <mvdm.h>
#include <idc_vdd.h>                    // Wakeup PDD IDC protocol

#include "audiovdd.h"
#include "data.h"
#include "ddstring.h"
#include "events.h"
#include "audioreq.h"


//                                      ------------------------- ParseConfig -
// Parse config.sys VDD parameters.
// Command line has list of PDDs that should be opened.
// The PDDs are opened and channels are established for
// VDD-PDD communication.
//
// The command line string (passed in) is ASCII nul terminated.
// Tabs can exist as well as trailing spaces.  Leading spaces normally
// don't exist, but can.
//
BOOL ParseConfig (char *Parms)
{
   char Ch;

   // There is only one parameter - name of audio PDD.
   // If not specified, we can't open the PDD, abort
   if (Parms == NULL)
      return (FALSE);

   Ch = *Parms;
   while (Ch != 0 && Ch < ' ')                  // Skip leading spaces
      Ch = *++Parms;

   dd_memset (szAudioDDName, '\0', sizeof(szAudioDDName));
   dd_strncpy (szAudioDDName, Parms, sizeof(szAudioDDName) - 1);

   return (TRUE);
}


//                                      -------------------- CreateSemaphores -
//
// This routine creates the two semaphores.
//
BOOL CreateSemaphores (void)
{
   if ( VDHCreateSem (&hsemEvent, VDH_EVENTSEM) == FALSE )
      return (FALSE);

   VDHResetEventSem (hsemEvent);

   if ( VDHCreateSem (&hsemMutex, VDH_MUTEXSEM) == FALSE )
      return (FALSE);
   return (TRUE);
}

                                        //------------------ InstallUserHooks -
BOOL InstallUserHooks (void)
{
   return ( VDHInstallUserHook (VDM_TERMINATE,   Terminate)  == TRUE &&
            VDHInstallUserHook (VDM_CREATE,      Create)     == TRUE &&
            VDHInstallUserHook (VDM_PDB_CHANGE,  PDBChange)  == TRUE &&
            VDHInstallUserHook (VDM_PDB_DESTROY, PDBDestroy) == TRUE );
}


//                                      ---------------------------- BlankPad -
// Given an 8 character ascii Z string, pad the string so
// that there is no ascii nul in the 8 character positions.
//
void BlankPad (char *pName)
{
   int I = 0;

   while (pName[I] != '\0')
      I++;

   for (; I < 8; I++)
      pName[I] = ' ';
}


//                                      ---------------------------- OpenPDDs -
// This routine calls VDHOpenPDD.
// On this action, the OS matches the name we provide to the
// name by which the PDD registered.
// It returns a status code and if succesful, the address of
// the Physical Device Drivers VDD IDC entry point.
// The OS sends a message to the PDD (message 0) which gives
// our entry point to the PDD.
//
// The string compare is case insensitive, but it has some
// trouble when the PDD registers with a name that is blank padded.
// This routine tries to open the PDD with the name provided.
// If that fails, it blank pads and retries.
//
BOOL OpenPDDs (void)
{
   ULONG ulRC;

   pWakeupDD = (FPFNPDDUL)
      VDHOpenPDD (szWakeupDDName, (FPFNVDD)IDCEntryFromWakeupPDD);
   pAudioDD  = (FPFNPDDUL)
      VDHOpenPDD (szAudioDDName, (FPFNVDD)IDCEntryFromAudioPDD);

   if (pWakeupDD == NULL)
      {
      BlankPad (szWakeupDDName);
      pWakeupDD = (FPFNPDDUL)
         VDHOpenPDD (szWakeupDDName, (FPFNVDD)IDCEntryFromWakeupPDD);
      }

   if (pAudioDD == NULL)
      {
      BlankPad (szAudioDDName);
      pAudioDD = (FPFNPDDUL)
         VDHOpenPDD (szAudioDDName, (FPFNVDD)IDCEntryFromAudioPDD);
      }

   if (pWakeupDD == NULL || pAudioDD == NULL)
      return (FALSE);

   // Make sure we're connected to a PDD that knows
   // how to talk to us.
   // Should the PDD wish to fake us out, it can return our
   // level to match - and program to meet the interface.

   ulRC = pAudioDD (PDDFUNC_QUERYPROTOCOL, IDC_PROTOCOL_LEVEL, 0);
   if (ulRC != IDC_PROTOCOL_LEVEL)
      return (FALSE); // PDD-VDD levels incompatible

   // Meeting interface of audiovdd, assign a handle
   // This VDD supports only one audio pdd - no handle needed
   //
   pAudioDD (PDDFUNC_ASSIGNHANDLE, 0, 0);

   //
   // Call Audio PDD - Get I/O information for adapter.
   //
   pAdapterInfo = (PADAPTERINFO) pAudioDD (PDDFUNC_GETIOPORTINFO, 0, 0);
   if (pAdapterInfo == NULL)
      return (FALSE);

   //
   // Call wakeup DD - Get information about the entire device
   // This information is also given to the audio PDD during its
   // initialization.  The information provided here should be
   // consistent with that provided by the audio PDD.
   //
   pWakeupSpecs = (PMAD16SPECS) pWakeupDD (IDCGETDEVICEINFO, 0, 0);
   if (pWakeupSpecs == NULL)
      return (FALSE);

   return (TRUE);
}


//                                      --------------------------- ClosePDDs -
// This routine is called only when the VDD initialization fails.
// Re-open the PDDs; but this time, give them a NULL IDC address.
//
// Returns (nothing)
//
void ClosePDDs (void)
{
   if (pAudioDD)
      {
      pAudioDD  (PDDFUNC_OPENPDD, 0, 0);
      pAudioDD = NULL;
      }

   if (pWakeupDD)
      {
      pWakeupDD  (PDDFUNC_OPENPDD, 0, 0);
      pWakeupDD = NULL;
      }
}

// void SaveDS (void);
// #pragma aux SaveDS = "mov ax, ds" \
//                      "mov usDataSel, ax";

//                                      -------------------------------- Init -
// Virtual device driver initialization
// Done at system boot and then discarded
//
BOOL pascal Init (char *Parms)
{
   //
   // Establish address of our Port Hook functions
   //
   dd_memset (&iohHookInfo, '\0', sizeof(iohHookInfo));
   iohHookInfo.ioh_pbihByteInput  = &ByteInputHook;
   iohHookInfo.ioh_pbohByteOutput = &ByteOutputHook;

   //
   // Parse our config.sys command line to get name of the audio PDD.
   // Should no parm be present, fail the load.
   if ( ParseConfig (Parms) == FALSE ||
        CreateSemaphores () == FALSE )
      {
      return (FALSE);
      }

   // Open the audio and wakeup device drivers
   // Should either not be present, the system has already displayed
   // an error message about failing to load the PDD, fail quietly.
   // Actually, there is no quiet fail for VDD, so load successfully,
   // but load in a state where the VDD will do no work.
   // To fail the load of the VDD when a PDD isn't present presents an
   // image that the VDD is also for some reason unhappy.
   //
   if ( OpenPDDs () == FALSE )
      {
      ClosePDDs ();
      }
   else
      {
      if (InstallUserHooks () == FALSE)
         {
         ClosePDDs ();
         return (FALSE);
         }
      }

   return (TRUE);
}
