/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* events.c - Catch DOS session create/terminate and other user hook events.
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*
******************************************************************************/

#pragma data_seg ("_DATA");

#include <conio.h>                      // Port I/O functions
#include <mvdm.h>
#include <idc_vdd.h>                    // Wakeup PDD IDC protocol

#include "audiovdd.h"
#include "data.h"
#include "ddstring.h"
#include "events.h"
#include "audioreq.h"

//                                      -------------------------- PropVerify -
// Function is called when user modifies our DOS property.
// We don't actually do anything here.  The function is
// required for use with enumeration properties.
//
#pragma off (unreferenced);
BOOL pascal PropVerify (int Operation, HVDM hvdm, int cb, char *pSt)
{
   return (TRUE);
}
#pragma on (unreferenced);


//                                      ------------------------------ Create -
// Routine is called every time a DOS session is created.
//
BOOL pascal Create (HVDM hvdm)
{
   HVDM_Current = hvdm;         // Set variable in instance data

   if ( VDHInstallIOHook (0, pWakeupSpecs->usSBBase,
                             pWakeupSpecs->usSBRange,
                             &iohHookInfo, 0) == FALSE )
      return (FALSE);

   return (TRUE);
}


//                                      --------------------------- PDBChange -
// Routine is called every time the current executing DOS
// application changes.
// The parm received points to the program segment prefix for
// the currently executing application.
// The PDB is remembered in instance data segment for reference.
// When ownership of the hardware is attained, the current application
// is remembered so that the hardware can be released when that
// application terminates.
// See PDBDestroy for description of hardware release.
//
#pragma off (unreferenced);
BOOL pascal PDBChange (HVDM hvdm, USHORT segPDB)
{
   PDB_Current = segPDB;
   return (TRUE);
}
#pragma on (unreferenced);


//                                      -------------------------- PDBDestroy -
// A DOS application is terminating.
//
// If pretending there is no hardware and this app was the one to
// first touch the hardware for this VDM, then return to default state.
//
// If this session has ownership of the hardware device and this application
// was the one who initiated ownership, then release the adapter.
//
//
BOOL pascal PDBDestroy (HVDM hvdm, USHORT segPDB)
{
   if (PretendNoHW_pdb == segPDB)       // If pretending there is no hardware
      {                                 // and this app was the first to touch
      PretendNoHW_pdb = 0;              // the hardware, then stop pretending.
      }

   else if (hvdm == hvdm_Owning &&      // If this application owns the h/w
            segPDB == pdb_Owning)       // then release to others.
      {
      ReleaseAccess();
      }
   return (TRUE);
}


//                                     ---------------------------- Terminate -
// DOS session is terminating.
// If this DOS session owns hardware, release
//
BOOL pascal Terminate (HVDM hvdm)
{
   if (hvdm == hvdm_Owning)
      {
      ReleaseAccess();
      }
   return (TRUE);
}


//                                      ---------------------- MaybeRequestHW -
// Function is called the first time a DOS session steps on
// a protected resource.  It provides a layer above the
// RequestHW routine.  A DOS property is queried.  If set to
// disable access to audio hardware, then the session does not
// compete for hardware access.
// The resulting behavior is the same as would be encountered
// by trying to gain access (being denied), displaying popup
// and have the user respond that they do not need the hardware (ignore).
// Advantage is the user's activity is not interrupted by the popup.
//
// RETURNS
//    TRUE  - Hardware access gained
//    FALSE - Denied - virtualize hardware as not present

BOOL MaybeRequestHW (void)
{
   BOOL fRetVal = TRUE;
   char *pValue;

   pValue = (char *) VDHQueryProperty (szPropNameAudio);
   if (pValue)
      {
      if (dd_strcmp (pValue, szEnumPrevent) == 0) // Is property set to disable
         {                                      // access to audio part?
         fRetVal = FALSE;                       // Yes, set for no access
         }
      VDHFreeMem (pValue);
      }

   if (fRetVal)                                 // If not excluded from access
      {                                         // Ask audio PDD for hardware.
      fRetVal = RequestAccess ();               // May block waiting.
      }

   if (fRetVal == FALSE)
      {
      PretendNoHW_pdb = PDB_Current;            // Per VDM data variables
      }
   return (fRetVal);
}

//                                      ----------------------- ByteInputHook -
// Capture DOS session IN instructions that
// attempted to step on the protected hardware.
//
#pragma off (unreferenced);
BYTE pascal ByteInputHook (ULONG Port, PCRF pcrf)
{
   BYTE bIn;

   // If we've been here before and decided to virtualize the
   // hardware as non-existant, then behave like non-existant hardware

   if (PretendNoHW_pdb)
      return (0xFF);

   if (MaybeRequestHW() == FALSE)
      return (0xFF);

   // The session has been given direct access to the
   // protected ports, subsequent port operations
   // (by this session/application) will not be trapped.

   bIn = inp (Port);    // Do transaction for the DOS app, return data read
   return (bIn);
}
#pragma on (unreferenced);


//                                      ---------------------- ByteOutputHook -
// Capture DOS session OUT instructions that
// attempted to step on the protected hardware.
//
#pragma off (unreferenced);
void pascal ByteOutputHook (BYTE bData, ULONG Port, PCRF pcrf)
{
   // If we've been here before and decided to virtualize the
   // hardware as non-existant, then send the OUT to bit-bucket.

   if (PretendNoHW_pdb)
      return;

   if (MaybeRequestHW() == FALSE)
      return;

   // The session has been given direct access to the
   // protected ports, subsequent port operations
   // (by this session/application) will not be trapped.

   outp (Port, bData);  // Do transaction for the DOS app
   return;
}
#pragma on (unreferenced);
