;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
; data.c - VDD data (instance data, init data)
;
;
; The following IBM OS/2 source code is provided to you solely for the
; the purpose of assisting you in your development of OS/2 device drivers.
; You may use this code in accordance with the IBM License Agreement
; provided in the IBM Device Driver Source Kit for OS/2.
;******************************************************************************
;
; VDDs have various types of data.
;    - Global
;    - Instance
;    - Initialization
; Each of these types of data comes in differing varieties
;    - Swappable
;    - Discardable
;    - Permanentely present
;
; To identify the different parts of the VDD image, we define code and
; data segments - and assign their meaning at link time.
;
; Link386 uses the following segment descriptions in .DEF files to
; assign attributes to segments.
;    SHARED         - Segment is common to all instances (global)
;    NONSHARED      - Segment is unique to each instance
;    DISCARDABLE    - When swapping, pages can be re-loaded from source
;    NONDISCARDABLE - When swapping, pages have to be swapped to recover
;    RESIDENT       - Pages of this segment don't get swapped
;
; The Watcom 32-bit C compiler provides a pragma for defining segment use.
; For example, "#pragma data_seg (SWAPINSTDATA)"
; Conceptually, this works enough to define data of differing types.
;
; Unfortunately, the compiler includes the noted statement in its
; DGROUP definition -- this instructs the linker to combine all of the
; member segments into one larger segment.
; This has the undesired side effect of having all the data segments have
; the same attributes.  That is, there becomes no difference between
; instance and global data.
;
; To work around this problem, we declare data here (in assembler) so that
; the C compiler doesn't have an opportunity to group the segments.
;
; By convention, global data is declared in C, instance and init in assembler
;
; The data.h header file is used to reference the data in this assembler file.
;
;*****************************************************************************/
.386p

                public  _HVDM_Current
                public  _PDB_Current
                public  _PretendNoHW_pdb
                public  _szWakeupDDName

        ASSUME  CS:FLAT, DS:FLAT, ES:FLAT, SS:FLAT

_TEXT           SEGMENT DWORD USE32 PUBLIC 'CODE'
_TEXT           ENDS

_DATA           SEGMENT DWORD USE32 PUBLIC 'DATA'       ; Global data segment
_DATA           ENDS

CINIT_DATA      SEGMENT DWORD USE32 PUBLIC 'DATA'
_szWakeupDDName db      "MAD16$", 0, 0, 0       ; szWakeupDDName [9]
CINIT_DATA      ENDS

SWAPINSTDATA    SEGMENT DWORD USE32 PUBLIC 'DATA'
_HVDM_Current    dd      0
_PDB_Current     dw      0
_PretendNoHW_pdb dw      0
SWAPINSTDATA    ENDS

END
