/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* audiovdd.h - Prototypes for communication with audio physical device drivers
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Prototypes and structures needed to meet
* communication protocol of audiovdd.sys.
*
******************************************************************************/

//
// Define ulFuncs for communicaiton between
// PDD and VDD IDC entrypoints.
// Also define version constant to indicate the highest
// functions we will send and can receive.
//

#define PDDFUNC_OPENPDD         0       // Open request sent to PDD by OS
#define PDDFUNC_QUERYPROTOCOL   1       // Insure PDD & VDD are of same level
#define PDDFUNC_ASSIGNHANDLE    2       // Inform PDD of its IDC handle
#define PDDFUNC_OPENDEVICE      3       // Request adapter owndership
#define PDDFUNC_CLOSEDEVICE     4       // Relinquish HW back to PDD control
#define PDDFUNC_GETIOPORTINFO   5       // Provide address of port I/O info

// Inter-Device Communication (IDC) function
// codes for calls from PDD
#define VDDFUNC_INTERRUPT       0       // (not used)
#define VDDFUNC_CLOSE           1       // Audio PDD is done with hardware

#define IDC_PROTOCOL_LEVEL      0x0501  // Max values of above defines


// PDD returns a pointer to ADAPTERINFO data structure
// to describe its hardware.
typedef struct
   {
   ULONG ulPort;
   ULONG ulRange;
   } IORANGE;
typedef struct
   {
   USHORT  usIRQLevel;
   USHORT  usDMALevel;
   ULONG   ulNumPorts;                  // number of port ranges
   IORANGE Range[1];                    // Unbounded array holding IORANGEs
} ADAPTERINFO;
typedef ADAPTERINFO *PADAPTERINFO;
