/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
*     WSSUTIL.c - WSS functions resident after initialization
*
*******************************************************************************
*
* Contains code to parse configuration string and program the
*         Sound System architecture
*
*         Sound System (Analog Devices AD1848, Crystal Semiconductor CS4231)
*
******************************************************************************/

#define  INCL_16
#define  INCL_DOSINFOSEG
#include <os2.h>

#include <conio.h>              // Watcom intrinsic port i/o routines

#include "idc_vdd.h"
#include "data.h"
#include "wss.h"
#include "util.h"

//                                              ------------ WSS_ReadIndirect -
// Read an         Sound System indirect register
// On AD1848, index is 4 bits
// On CS4231, index is 5 bits
//
BYTE WSS_ReadIndirect (BYTE Index)
{
   BYTE IndexValue;
   BYTE bVal;

   IndexValue = inp (Specs.usWSSBase);          // Preserve bits 7..5
   IOdelay ();
   IndexValue &= 0xE0;
   IndexValue |= (Index & 0x1F);                // Index is lower 5 bits
   outp (Specs.usWSSIndex, IndexValue);         // Set the index register
   IOdelay ();
   bVal = inp (Specs.usWSSData);                // Read accompanying data
   IOdelay ();
   return (bVal);
}


//                                      ------------------- WSS_WriteIndirect -
// Write one of the         Sound System
// indirect registers.
//
VOID WSS_WriteIndirect (BYTE Index, BYTE Value)
{
   BYTE IndexValue;
   INT  I;

   IndexValue = inp (Specs.usWSSIndex);              // Preserve bits 7..5
   IOdelay ();
   IndexValue &= 0xE0;
   IndexValue |= (Index & 0x1F);                     // Index is lower 5 bits
   outp (Specs.usWSSIndex, IndexValue);              // Set the index register
   IOdelay ();
   outp (Specs.usWSSData, Value);                    // Send accompanying data
   IOdelay ();

   // CS4231 and CS4248 have a bug.  After writing CDF register,
   // the part will claim to be ready to talk, but it is not ready.
   // To work around, must delay 10 microseconds before polling.
   // Then, after getting success, wait an additional 1 millisecond
   // before continuing.
   if (IndexValue == WSS_CLOCK_AND_DATA_FORMAT)
      {
      for (I = 0; I < 5; I++)   // Figure 3 microseconds per IN
         inp (Specs.usWSSBase);
      }
}

//                                      ------------------ WSS_SaveMixerState -
// Save WSS mixer registers to indicated structure
//
VOID WSS_SaveMixerState (PMIXERSTATE pState)
{
   pState->Left_Input_Control       = WSS_ReadIndirect (WSS_LEFT_INPUT_CONTROL);
   pState->Right_Input_Control      = WSS_ReadIndirect (WSS_RIGHT_INPUT_CONTROL);
   pState->Left_AUX1_Input_Control  = WSS_ReadIndirect (WSS_LEFT_AUX1_INPUT_CONTROL);
   pState->Right_AUX1_Input_Control = WSS_ReadIndirect (WSS_RIGHT_AUX1_INPUT_CONTROL);
   pState->Left_AUX2_Input_Control  = WSS_ReadIndirect (WSS_LEFT_AUX2_INPUT_CONTROL);
   pState->Right_AUX2_Input_Control = WSS_ReadIndirect (WSS_RIGHT_AUX2_INPUT_CONTROL);
   pState->Left_Output_Control      = WSS_ReadIndirect (WSS_LEFT_OUTPUT_CONTROL);
   pState->Right_Output_Control     = WSS_ReadIndirect (WSS_RIGHT_OUTPUT_CONTROL);
}

//                                      ------------------- WSS_SetMixerState -
// Set WSS mixer registers to indicated value
//
VOID WSS_SetMixerState (PMIXERSTATE pState)
{
   WSS_WriteIndirect (WSS_LEFT_INPUT_CONTROL,       pState->Left_Input_Control);
   WSS_WriteIndirect (WSS_RIGHT_INPUT_CONTROL,      pState->Right_Input_Control);
   WSS_WriteIndirect (WSS_LEFT_AUX1_INPUT_CONTROL,  pState->Left_AUX1_Input_Control);
   WSS_WriteIndirect (WSS_RIGHT_AUX1_INPUT_CONTROL, pState->Right_AUX1_Input_Control);
   WSS_WriteIndirect (WSS_LEFT_AUX2_INPUT_CONTROL,  pState->Left_AUX2_Input_Control);
   WSS_WriteIndirect (WSS_RIGHT_AUX2_INPUT_CONTROL, pState->Right_AUX2_Input_Control);
   WSS_WriteIndirect (WSS_LEFT_OUTPUT_CONTROL,      pState->Left_Output_Control);
   WSS_WriteIndirect (WSS_RIGHT_OUTPUT_CONTROL,     pState->Right_Output_Control);
}

//                                      ------------------------ WSS_ClearPEN -
// On returning from execution of DOOM game on the 82C929, the
// playback enable bit of the itnerface configuration register
// is sometimes erroneously set to be in playback mode.
//
// This routine does a read/modify write on that register to
// clear the playback and record bits.
// These bits are modifiable without setting MCE
//
VOID WSS_ClearPEN (VOID)
{
   BYTE bTemp;

   bTemp = WSS_ReadIndirect (WSS_INTERFACE_CONFIGURATION);
   bTemp &= 0xCC; // Turn off playback/record bits and reserved bits
   WSS_WriteIndirect (WSS_INTERFACE_CONFIGURATION, bTemp);
}
