/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* WSS.h - Defines and prototypes for code in .C file of same name
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
******************************************************************************/

// Useful defines for programming         sound system hardware
// Indirect registers

#define WSS_LEFT_INPUT_CONTROL          0
#define WSS_RIGHT_INPUT_CONTROL         1
#define WSS_LEFT_AUX1_INPUT_CONTROL     2
#define WSS_RIGHT_AUX1_INPUT_CONTROL    3
#define WSS_LEFT_AUX2_INPUT_CONTROL     4
#define WSS_RIGHT_AUX2_INPUT_CONTROL    5
#define WSS_LEFT_OUTPUT_CONTROL         6
#define WSS_RIGHT_OUTPUT_CONTROL        7
#define WSS_CLOCK_AND_DATA_FORMAT       8
#define WSS_INTERFACE_CONFIGURATION     9
#define WSS_PIN_CONTROL                 0xA
#define WSS_TEST_AND_INITIALIZATION     0xB
#define WSS_MISCELLANEOUS_INFO          0xC
#define WSS_DIGITAL_MIX                 0xD
#define WSS_UPPER_BASE_COUNT            0xE
#define WSS_LOWER_BASE_COUNT            0xF
#define WSS_RESERVED_BIT                0x10    // Used on CS4231

BOOL   WSS_IsValidBaseAddr (USHORT usBaseAddr);
VOID   WSS_SetBase (USHORT usBasePort);
BYTE   WSS_ReadIndirect (BYTE Index);
VOID   WSS_WriteIndirect (BYTE Index, BYTE Value);
USHORT WSS_SetClockAndDataFormat (USHORT usClockRate);    // 11025 or 44100
USHORT WSS_SetInterfaceConfig (BYTE Value);
VOID   WSS_UnMuteEverything (VOID);
VOID   WSS_MuteEverything (VOID);
VOID   WSS_SaveMixerState (PMIXERSTATE pState);
VOID   WSS_SetMixerState (PMIXERSTATE pState);
VOID   WSS_ClearPEN (VOID);
VOID   WSS_EnableInterrupts (VOID);
USHORT WSS_QueryPartType (VOID);
USHORT WSS_Setup (VOID);
