;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
; UTILA.asm - Device driver utility functions in assembler
;
;
; The following IBM OS/2 source code is provided to you solely for the
; the purpose of assisting you in your development of OS/2 device drivers.
; You may use this code in accordance with the IBM License Agreement
; provided in the IBM Device Driver Source Kit for OS/2.
;******************************************************************************
;
; Common functions for the device driver which need to be in assembler
;
;******************************************************************************
        .386p

_DATA   SEGMENT WORD PUBLIC USE16 'DATA'        ; Watcom initialized data
_DATA   ENDS

_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'        ; Watcom generated code

; Route PDD IDC request to 'C' code to implement
; 16:16 entry from 16:16 caller
; Called using _System calling conventions (similar to C).
; Parms were pushed right to left and we don't do the clean up
;
; Stack
;            --------
;       +8  |  fpv   | Second parm (far pointer to void)
;           |--------|
;       +6  | usFunc | usFunc (word)
;           |--------|
;       +2  | sel/ofs| Return address
;           |--------|
; SS:EBP -> |   bp   | Callers frame pointer
;            --------
usFunc  EQU  WORD PTR [bp+6]
fpv     EQU DWORD PTR [bp+8]

        PUBLIC  _IDCEntry_PDD
        EXTERN  IDCEntry_PDD_c:near
_IDCEntry_PDD PROC FAR ; 16:16 entry from 16:16 ; PDD calls PDD
        push    bp
        mov     bp, sp
        push    ds                              ; Preserve callers DS
        mov     ax, seg _DATA                   ; Load DS for use by C code
        push    fpv                             ; Propagate the parms (_System)
        mov     ds, ax
        push    usFunc
        call    IDCEntry_PDD_c
        add     sp, 6                           ; Trash the parms
        pop     ds                              ; Restore callers DS
        leave
        ret                                     ; Caller pops the stack
_IDCEntry_PDD ENDP


; Route VDD IDC request to C code to implement
; 16:16 entry from 16:32 caller
;
; Called from VDD using pascal calling conventions:
;       Parms pushed left to right, callie clears the stack
;
ulFunc  EQU DWORD PTR [bp+18]   ; Pascal conventions push parms left to right
ul1     EQU DWORD PTR [bp+14]   ; 8 bytes for 16:32 far return address
ul2     EQU DWORD PTR [bp+10]   ; 2 bytes for save of callers stack frame ptr

        PUBLIC  IDCEntry_VDD
        EXTERN  IDCEntry_VDD_c:near
IDCEntry_VDD PROC FAR  ; 16:16 entry from 16:32 ; VDD calls PDD
        push    bp
        mov     bp, sp
        push    ds
        mov     ax, seg _DATA
        push    ulFunc                          ; pascal calling convention
        mov     ds, ax
        push    ul1
        push    ul2
        call    IDCEntry_VDD_c
        shl     edx, 16                         ; Move DX:AX return value
        and     eax, 0000FFFFh                  ; into eax
        pop     ds
        or      eax, edx
        leave
        db      66h                             ; Force next instruction 32-bit
        ret     12                              ; 16:32 far return, pop parms
IDCEntry_VDD ENDP

_TEXT   ENDS

END
