/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* util.c - resident utility functions
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
******************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <conio.h>              // Watcom intrinsic port i/o routines

#include <os2.h>
#ifdef _PDD_
#include <dhcalls.h>            // 'C' callable kernel device helper functions
#endif
#include "util.h"


//                                      --------------------- OPL3AllNotesOff -
// Program OPL-3 chip (Yamaha YMF-262) to turn off all notes
// Specs call for 3.3 microsecond delay after writing index reg and
// 23.3 microsecond delay after writing data before doing other actions.
//
void OPL3AllNotesOff (void)
{
   int I;

   //Very slow
   //for (I = 0xB0; I <= 0xB8; I++)
   //   {
   //   outp (0x388, I); IOdelay (4);     // for all OPL-2 operators
   //   outp (0x389, 0); IOdelay (24);    // Turn off bit-5 (key-on bit)
   //   outp (0x38A, I); IOdelay (4);     // for all OPL-3 operators
   //   outp (0x38B, 0); IOdelay (24);    // Turn off bit-5 (key-on bit)
   //   }

   for (I = 0xB0; I <= 0xB8; I++)
      {
      outp (0x388, I); IOdelay ();      // for all OPL-2 operators
      outp (0x389, 0); IOdelay ();      // Turn off bit-5 (key-on bit)
      outp (0x38A, I); IOdelay ();      // for all OPL-3 operators
      outp (0x38B, 0); IOdelay ();      // Turn off bit-5 (key-on bit)
      }
}


//                                      ---------------------------- IOdelay -
// Delay execution to support back to back I/O instructions
// The OS/2 kernel calculates the relative speed of the machine
// at system boot and advertises a variable -- which we resolve
// as a dynamic link at load time.
// By looping this many times, a very slow device, the 8042
// keyboard controller will be ready for the next bus I/O.
//
// In testing this driver on 60 and 90 Mhz Pentium machines,
// speed related problems were encountered that were cured
// using this function.
// The routine below has the advantage that the time delay is
// consistent regardless of slow or fast machines.
//
#ifdef _PDD_
#pragma aux DOSIODELAYCNT "*";  // Don't add a leading underscore to symbol
extern USHORT DOSIODELAYCNT;
void IOdelay (void)
{
   int D = DOSIODELAYCNT;
   int I;

   I = D;            // Delay 1/2 microsecond each loop
   while (--I)
      ;
}
#endif
