/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* TRACE.C - Code to assist debug of driver
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Should be linked to device driver code as discardable code (init only)
*
*/

#define INCL_NOPMAPI
#define DRV_16
#include <os2.h>

#include "idc_vdd.h"
#include "data.h"
#include "util.h"
#include "ddstring.h"
#include "trace.h"

// Trace_Init is in init.c

void Trace_Save_Message (char far *St)
{
   if (pTraceBuf && St)
      {
      // Copy the string into the message trace buffer.
      // Buffer is circular.  Strings are separated by ascii nuls.
      do {
         *(pTraceBuf+TraceIndex) = *St;
         if (++TraceIndex == TRACEBUFSIZE-1)    // Point to next position
            TraceIndex = 0;
         St++;
         }
      while (*St != '\0');

      *(pTraceBuf+TraceIndex) = '\n';           // Add new line character
      if (++TraceIndex == TRACEBUFSIZE-1)
         TraceIndex = 0;

      *(pTraceBuf+TraceIndex) = '\0';           // Initialized next pos to nul
      }
}
