/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* STRATEGY.C - Device driver strategy routine processing
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*
******************************************************************************/

#include <stdlib.h>             // For min macro
#include <string.h>             // _memset

#define  INCL_16
#define  INCL_DOSINFOSEG
#include <os2.h>

#include "reqpkt.h"
#include "strategy.h"
#include "util.h"
#include "idc_vdd.h"
#include "data.h"
#include "string.h"
#include "trace.h"
#include "ioctl.h"
#include "mad16.h"

void StrategyErr (REQPACKET far *rpP)
{
   rpP->Status = RPDONE | RPERR | RPUNKCMND;
}

void StrategySuccess (REQPACKET far *rpP)
{
   rpP->Status = RPDONE;
}

void (*StrategyFuncs[]) (REQPACKET far *rpP) =
{
   StrategyInit,                        // 0   inintialize                  b c
   StrategyErr,                         // 1   media check                  b
   StrategyErr,                         // 2   build bpb                    b
   StrategyErr,                         // 3   reserved
   StrategyErr,                         // 4   read(input)                  b c
   StrategyErr,                         // 5   nondestructive read no wait    c
   StrategyErr,                         // 6   input status                   c
   StrategyErr,                         // 7   input flush                    c
   StrategyErr,                         // 8   write(output)                b c
   StrategyErr,                         // 9   write verify                 b c
   StrategyErr,                         // a   output status                  c
   StrategyErr,                         // b   output flush                   c
   StrategyErr,                         // c   reserved
   StrategySuccess,                     // d   open                         b c
   StrategySuccess,                     // e   close                        b c
   StrategyErr,                         // f   removable media              b
   StrategyIOCTL,                       // 10  generic ioctl                b c
   StrategyErr,                         // 11  reset media                  b
   StrategyErr,                         // 12  get logical drive map        b
   StrategyErr,                         // 13  set logical drive map        b
   StrategyErr,                         // 14  deinstall                      c
   StrategyErr,                         // 15  portaccess                     c
   StrategyErr,                         // 16  partitionable fixed disks    b
   StrategyErr,                         // 17  get fixed disk logical map   b
   StrategyErr,                         // 18  reserved
   StrategyErr,                         // 19  reserved
   StrategyErr,                         // 1a  reserved
   StrategyInit,                        // 1b  Init for BASEDEVs
   StrategySuccess,                     // 1c  Shutdown
   StrategyErr,                         // 1d  get capabilities <new for 2.0>
   StrategyErr,                         // 1e  reserved
   StrategySuccess                      // 1f  init complete
};
USHORT MaxStrategyFuncs = sizeof(StrategyFuncs)/sizeof(USHORT);

//                                      ---------------------- MAD16_Strategy -
// Device driver entrypoint from kernel.
// Using Watcom compiler, we can tell the compiler that
// parameters to the function arrive in registers.
//
// Dispatch request to appropriate function
// using table of function pointers.
//
#pragma aux MAD16_Strategy parm [es bx];        // Watcom pragma
void far MAD16_Strategy (REQPACKET far *rpP)
{
   if (rpP->Command > (UCHAR) MaxStrategyFuncs)
      rpP->Status = RPDONE | RPERR | RPUNKCMND;
   else
      StrategyFuncs[rpP->Command](rpP);
}
