/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* SNDBLAST.c - Code to program Sound Blaster and similar adapters
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Programming control for Sound Blaster similar adapters
* This provides the basis of device reset, command write and data read
* operations necessary to program devices that have programming interface
* based on the Sound Blaster interface.
*
*/

#define  INCL_16
#define  INCL_DOSINFOSEG
#include <os2.h>
#include <dhcalls.h>
#include <conio.h>              // Watcom intrinsic port i/o routines
#include <dos.h>                // Watcom intrinsic enable/disable interrupts
#include "idc_vdd.h"
#include "data.h"
#include "util.h"
#include "sndblast.h"


BOOL SB_IsValidBaseAddr (USHORT BaseAddr)
{
   return (BaseAddr == 0x220 ||
           BaseAddr == 0x240);
}

/*                                      ---------------------------- SB_Reset -
** Sound Blaster device reset at specified address.
** Reset technique taken from Thunder Board programmers reference
** Returns zero for success
*/
USHORT SB_Reset (VOID)
{
   USHORT usRC;
   BYTE   bIn;
   INT    I;

   if (!SB_IsValidBaseAddr (Specs.usSBBase))
      {
      int3 (); // coding error
      return (1);
      }

   // Card is reset when 1 is written to 2x6
   // Reset occurs on the write, card starts loading
   // defaults when the reset state is removed.
   // Typically, 100 microseconds are required for state load

   outp (Specs.usSBBase + 6, 1);        // Output reset command
   for (I = 0; I < 35; I++)             // Figure about 3 u-sec per bus I/O
      bIn = inp (Specs.usSBBase+6);
   outp (Specs.usSBBase + 6, 0);        // Remove reset state
   bIn = SB_Read ();                    // Card sends AA for reset success

   usRC = (bIn != 0xAA);                // Return zero for success
   return (usRC);
}


/*                                      ------------------------- SB_CmdWrite -
** Send command to Sound Blaster or Sound Blaster
** compatible enhanced signal processor
** Returns zero for success, 1 for timeout
*/
USHORT SB_CmdWrite (BYTE bCmd)
{
   BYTE bIn;
   int  I;

   if (!SB_IsValidBaseAddr (Specs.usSBBase))
      {
      int3 (); // coding error
      return (1);
      }

   for (I = 0; I < 100; I++)
      {
      bIn = inp (Specs.usSBBase + 0x0C); // Read until high bit becomes zero
      if ((bIn & 0x80) == 0)
         break;
      }
   if ((bIn & 0x80) != 0)               // If byte is still one, timeout
      {
      return (1);
      }

   outp (Specs.usSBBase + 0x0C, bCmd);  // Write the command
   IOdelay ();
   return (0);
}


/*                                      ----------------------------- SB_Read -
** Read byte from Sound Blaster DSP port.
** Returns value read or FF if timeout
*/
BYTE SB_Read (VOID)
{
   BYTE  bIn;
   int   I;

   if (!SB_IsValidBaseAddr (Specs.usSBBase))
      {
      int3 (); // coding error
      return (1);
      }

   for (I = 0; I < 1000; I++)
      {
      bIn = inp (Specs.usSBBase + 0x0E); // Wait until data is available
      if ((bIn & 0x80) != 0)            // Indicated when msb is one
         break;
      }
   if ((bIn & 0x80) == 0)               // If msb is still zero, timeout
      {
      return (0xff);
      }

   bIn = inp (Specs.usSBBase + 0x0A);   // Read byte from read data port
   IOdelay ();
   return (bIn);
}



/*                                      -------------------- SB_GetDSPVersion -
** Returns sound blaster version or -1 for not found
**
** Known return values (following reset)
**    CARD                  FIRST CALL   SECOND CALL
**    ------------------    ----------   -----------
**    SB Pro MCV         ->   03 02         03 02
**    PAS-16             ->   02 00         01 30  (fails Clone check)
**    Jazz-16 (Dec 1993) ->   03 01         03 01
*/
USHORT SB_GetDSPVersion (VOID)
{
   USHORT RetVal;
   BYTE bIn;

   SB_CmdWrite (0xE1);                  // Get Sound Blaster DSP Version
   RetVal = SB_Read ();                 // Read Major version (byte)
   if (RetVal == 0)                     // Special leading zero for SB-Pro MCV
      RetVal = SB_Read ();
   bIn    = SB_Read ();                 // Read Minor version (byte)
   RetVal = (RetVal << 8) + bIn;

   return (RetVal);
}


/*                                      ----------------------- SB_MixerWrite -
** Send command to Sound Blaster mixer
*/
VOID SB_MixerWrite (BYTE Index, BYTE Value)
{
   if (!SB_IsValidBaseAddr (Specs.usSBBase))
      {
      int3 (); // coding error
      return;
      }

   outp (Specs.usSBBase + 0x04, Index);
   IOdelay ();
   outp (Specs.usSBBase + 0x05, Value);
   IOdelay ();
}
