;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
; SEGS.ASM - Define order of device driver segments
;
;
; The following IBM OS/2 source code is provided to you solely for the
; the purpose of assisting you in your development of OS/2 device drivers.
; You may use this code in accordance with the IBM License Agreement
; provided in the IBM Device Driver Source Kit for OS/2.
;******************************************************************************
;
; Contains segment object definitions
; Must be first object given to the linker.
;
; This assembler file modifies the segment ordering so that the device header
; is at offset zero of the first segment (which must be a data segment) and
; that all non-initialization code resides in the second segment (code segment)
;
; MODIFICATION HISTORY
; DATE       PROGRAMMER   COMMENT
; 09-Nov-94  Joe Nord     Creation
; 05-Dec-94  Joe Nord     Changed name of 'C' strategy function
; 17-Jan-95  Joe Nord     Ported to Watcom WASM and eliminated strategy func
;******************************************************************************

; With no assembler code, the Watcom compiler generates the following segments:
;    0001:0000 0289DH     _TEXT                  CODE
;    0002:0000 0053EH     CONST                  DATA
;    0002:053E 00000H     CONST2                 DATA
;    0002:053E 000FDH     _DATA                  DATA
;    0002:063C 005A4H     _BSS                   BSS
; Bringing in DHCALLS.lib provides an additional code segment "CODE"

_DATA   SEGMENT WORD PUBLIC USE16 'DATA'        ; Watcom initialized data
_DATA   ENDS
_BSS    SEGMENT WORD PUBLIC USE16 'BSS'
_BSS    ENDS
CONST   SEGMENT WORD PUBLIC USE16 'DATA'
CONST   ENDS
CONST2  SEGMENT WORD PUBLIC USE16 'DATA'
CONST2  ENDS

ENDDATA SEGMENT WORD PUBLIC USE16 'ENDDATA'
PUBLIC  _EndOfDataSegment
_EndOfDataSegment dw 0
ENDDATA ENDS


_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'        ; Watcom generated code
_TEXT   ENDS

ENDCODE SEGMENT WORD PUBLIC USE16 'ENDCODE'
PUBLIC  _EndOfCodeSegment
_EndOfCodeSegment dw 0
ENDCODE ENDS

; Note, if DevHelp calls are needed after
; after initialization, move this segment
; to just before the _TEXT segment.
CODE    SEGMENT WORD PUBLIC USE16 'CODE'        ; DHCALLS.lib
CODE    ENDS                                    ; Only the ones we use

; Tell linker to treat each of these individual
; segments as part of a larger whole (the group)
DGROUP  GROUP   _DATA, _BSS, CONST, CONST2, ENDDATA
CGROUP  GROUP   _TEXT, CODE, ENDCODE

END
