/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* REQPKT.H - Request package data structure
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
******************************************************************************/

typedef struct {                             /* template for request header */
   UCHAR  Length;                            /* request packet length */
   UCHAR  Unit;                              /* unit code for block DD only */
   UCHAR  Command;                           /* command code */
   USHORT Status;                            /* return status */
   UCHAR  Reserved[4];                       /* reserved bytes */
   ULONG  QLink;                             /* queue linkage */
   union {                                   /* command-specific data */
      struct {
         UCHAR Dummy1;
         PFN   DevhlpEntry;                  /* dev help address */
         CHAR *ArgP;                         /* argument pointer */
         UCHAR Dummy3;
      } InitIn;
      struct {
         UCHAR  Dummy1;
         USHORT CodeEnd;                   /* final code offset */
         USHORT DataEnd;                   /* final data offset */
         ULONG  Dummy2;
         UCHAR  Dummy3;
      } InitOut;
      struct {
         UCHAR Category;                    /* category code */
         UCHAR Function;                    /* function code */
         VOID *ParamBufP;                   /* address of parameter buffer */
         VOID *DataBufP;                    /* address of data buffer */
         USHORT SysFileNum;                 /* system file number */
         USHORT ParamLen;                   /* IOCTL2 only (pkt Len > 12) */
         USHORT DataLen;                    /* Length parms are In/Out */
      } Ioctl;
      struct {
         USHORT SysFileNum;
      } Open;
      struct {
         USHORT SysFileNum;
      } Close;
   } Packet;
} REQPACKET;


/* Constants relating to the Strategy Routines
*/
#define RPERR     0x8000                        // return error
#define RPDONE    0x0100                        // return successful
#define RPGENFAIL 0x000C                        // General failure
#define RPUNKCMND 0x0003                        // Unknown command
