/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* QMAD16.c - Application to query settings on MAD16 device
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Contains code to generate a 32-bit OS/2 application.
*
* Application sends IOCTLs to the device driver and displays information
* to the screen.
*
* As BASEDEVs load before display support, messages get queued and then
* displayed all at once -- often soon erased by another activity before
* they can be read.
*
* To work around this problem and to provide a means of displaying the
* device configuration to a user or to an install program, the device
* driver supports a set of IOCTLS.
*
* This application uses these IOCTLs to get the messages and device
* configuration - and displays that information.  Purely a diagnostic.
*
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define INCL_DOSDEVICES                         // DosDevIOCtl
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>

#include "ioctl.h"
#include "idc_vdd.h"

typedef struct {
   BOOL Help;
} OPTIONS;

OPTIONS    Options;
HFILE      DevHandle;

CHAR       MsgBuf [32*1024];                    // Variables set by PDD
USHORT     MsgBufIndex;                         // during IOCTL processing
ULONG      SizeofMsgBuf = sizeof (MsgBuf);
ULONG      SizeofIndex  = sizeof (MsgBufIndex);
ULONG      ulAudioMode; // 0==SB, 1==WSS
ULONG      ulSizeofMode = sizeof (ulAudioMode);

MAD16SPECS Specs;
ULONG      SizeofSpecs = sizeof (Specs);

void P (char *pSt)
{
   printf ("%s\n", pSt);
}

void HelpDisplay (void)
{
P("This application acts as a companion to the MAD16.ADD device driver.");
P("It can be a useful diagnostic when installing OPTi 82C928/82C928 based");
P("devices such as the Media Magic ISP16, Reveal or Boca Research audio cards.");
P("");
P("The application communicates with the MAD16.add driver to query device");
P("configuration and to relay information displayed during system boot.");
P("");
P("Displayed information includes the configured settings for CD-ROM and");
P("audio device (base I/O address, IRQ and DMA).  Some of this information");
P("is the same as that displayed with the OS/2 resource manager (RMVIEW)");
P("");
P("The application also displays all the messages that the device driver");
P("displayed during system boot.  These can easily be missed during the");
P("boot process as the screen is cleared shortly after they are displayed.");
P("");
P("Showing this information later can be useful should the device driver");
P("detect an error condition.  For example, the device driver may discover");
P("some reason why it cannot load.  Without the error message routing provided");
P("by this applicaiton, the device driver can indicate the reason that it was");
P("unable to perform the directed action.");
P("");
P("Usage: \"QMAD16\"   == Display information from device driver");
P("       \"QMAD16 ?\" == This help text");
}

ULONG Init (int argc, char *argv[])             // Parse command line options
{
   int  AI;

   for (AI = 1; AI < argc; AI++)
      {
      if (strcmp (argv[AI], "-?") == 0 ||
          strcmp (argv[AI], "-h") == 0 ||
          strcmp (argv[AI], "?") == 0)
         {
         Options.Help = TRUE;
         }
      }
   return (0);
}


ULONG Open (VOID)
{
   ULONG ulRC;
   PSZ   pszFileName     = "\\DEV\\MAD16$";     // Open device, not a file
   INT   DosOpenFlags    = 0;
   ULONG ulOpenMode      = 0;
   ULONG ulFileSize      = 0;
   ULONG ulFileAttribute = 0;
   ULONG ulActionTaken   = 0;

   DosOpenFlags = OPEN_ACTION_FAIL_IF_NEW +     // Create if new file, or
                  OPEN_ACTION_OPEN_IF_EXISTS;   // update in place if exists.

   ulOpenMode   = OPEN_ACCESS_READWRITE +       // Read/Write file
                  OPEN_SHARE_DENYREADWRITE +    // Exclusive access
                  OPEN_FLAGS_FAIL_ON_ERROR;     // No system popups on errors

   ulRC = DosOpen (pszFileName,     // in
                   &DevHandle,      // in out (handle addr in, handle out)
                   &ulActionTaken,  //    out
                   ulFileSize,      // in
                   ulFileAttribute, // in
                   DosOpenFlags,    // in
                   ulOpenMode,      // in
                   NULL);           // in

   if (ulRC != 0)
      {
      printf ("QMAD16 DosOpen ulRC:%d\n", ulRC);
      switch (ulRC)
         {
         case ERROR_PATH_NOT_FOUND:
            printf ("ERROR_PATH_NOT_FOUND\n");
            printf ("   - MAD16.add device driver isn't loaded\n");
            break;
         case ERROR_DEVICE_IN_USE:
            printf ("ERROR_DEVICE_IN_USE\n");
            printf ("   - MAD16.add device driver is in use\n");
            break;
         default:
            break;
         }
      }
   return (ulRC);
}


VOID DisplayDateTime (VOID)
{
   time_t TheTime;

   time (&TheTime);
   printf ("%s\n", ctime(&TheTime));
}

ULONG FetchData (void)
{
   ULONG ulRC;

   memset (&MsgBuf, '\0', sizeof (MsgBuf));
   MsgBufIndex = 0;
   ulAudioMode = 0;

   ulRC = DosDevIOCtl
             (DevHandle,                // Device Handle
              IOCTLCATEGORY,            // Category (user defined)
              FUNCGETMSGBUF,            // User defined function 40
              &MsgBufIndex,             // pParmList
              SizeofIndex,              // Length of parmlist
              &SizeofIndex,             // Where to updated size
              &MsgBuf,                  // Address of data
              SizeofMsgBuf,             // Size of data sent down
              &SizeofMsgBuf);           // Size of data on return

   if (ulRC == 0) {
      ulRC = DosDevIOCtl
                (DevHandle,             // Device Handle
                 IOCTLCATEGORY,         // Category (user defined)
                 FUNCGETSPECS,          // User defined function 40+zero
                 NULL,                  // pParmList
                 0,                     // Length of parmlist
                 NULL,                  // Where to updated size
                 &Specs,                // Address of data
                 SizeofSpecs,           // Size of data sent down
                 &SizeofSpecs);         // Size of data on return
      }

   if (ulRC == 0) {
      ulRC = DosDevIOCtl
                (DevHandle,             // Device Handle
                 IOCTLCATEGORY,         // Category (user defined)
                 FUNCQUERYAUDIOMODE,    // User defined function 40+zero
                 NULL,                  // pParmList
                 0,                     // Length of parmlist
                 NULL,                  // Where to updated size
                 &ulAudioMode,          // Address of data
                 ulSizeofMode,          // Size of data sent down
                 &ulSizeofMode);        // Size of data on return
      }

   if (ulRC)
      printf ("QMAD16: DosDevIOCTL ulRC:%d\n", ulRC);

   return (ulRC);
}


ULONG Display (void)
{
   ULONG ulRC = 0;
   BOOL  Wrapped = FALSE;
   int   I;

   DisplayDateTime ();
   printf ("Messages from device driver\n"
           "---------------------------\n");

   //
   // Buffer is circular - MsgBufIndex points to the position
   // that will receive the first character of the next message.
   //
   I = MsgBufIndex;
   for (I = MsgBufIndex; I < SizeofMsgBuf; I++)
      {
      if (MsgBuf[I])
         putchar (MsgBuf[I]);
      }
   for (I = 0; I < MsgBufIndex; I++)
      {
      if (MsgBuf[I])
         putchar (MsgBuf[I]);
      }

   printf ("\nMAD16 hardware configuration\n"
           "----------------------------\n");

   printf ("OPTi MAD16   82C%d\n", Specs.usMad16PartNum);
   if (Specs.usMad16PartNum == 928)
      printf ("Revision     %c\n", Specs.usMad16Revision);
   printf ("Mad16Base    %X\n", Specs.usMad16Base);
   printf ("Mad16Range   %d\n", Specs.usMad16Range);
   printf ("DecodeWidth  %d\n", Specs.usMad16DecodeWidth);
   printf ("WSSCodecType ");
   switch (Specs.usWSSCodecType)
      {
      case 'A': printf ("Analog Devices\n");        break;
      case 'C': printf ("Crystal Semiconductor\n"); break;
      default : printf ("Unknown\n");
      }
   printf ("WSSGrade     %c\n", Specs.usWSSGrade);
   printf ("WSSBase      %X\n", Specs.usWSSBase);
   printf ("WSSRange     %d\n", Specs.usWSSRange);
   printf ("WSSIRQ       %d\n", Specs.usWSSIRQ);
   printf ("WSSDMA       %d\n", Specs.usWSSPlayDMA);
   printf ("SBBase       %X\n", Specs.usSBBase);
   printf ("SBRange      %d\n", Specs.usSBRange);
   printf ("SBIRQ        %d\n", Specs.usSBIRQ);
   printf ("SBDMA        %d\n", Specs.usSBDMA);

   printf ("CDType       ");
   switch (Specs.usCDType)
      {
      case 'N': printf ("None\n");       break;
      case 'S': printf ("Sony31A\n");    break;
      case 'P': printf ("Panasonic\n");  break;
      case 'M': printf ("Mitsumi\n");    break;
      case 'I': printf ("IDE\n");        break;
      default:
         printf ("Unknown\n"); break;
      }

   if (Specs.usCDType != 'N')
      {
      printf ("CDBase       %X\n", Specs.usCDBase);
      printf ("CDRange      %d\n", Specs.usCDRange);
      if (Specs.usCDType == 'I')
         printf ("CD2ndPort    %x\n", Specs.usCDBase + 0x206);

      printf ("CDIRQ        ");
      if (Specs.usCDIRQ == 0)
         printf ("None\n");
      else
         printf ("%d\n", Specs.usCDIRQ);
      if (Specs.usCDDMA != 0)
         printf ("CDDMA        %d\n", Specs.usCDDMA);
      }
   printf ("OPL3Base     %X\n", Specs.usOPL3Base);
   printf ("OPL3Range    %d\n", Specs.usOPL3Range);

   printf ("\nCurrent audio mode\n"
           "------------------\n");
   if (ulAudioMode == 0)
      printf ("Sound Blaster\n");
   else
      printf ("Business Audio\n");

   return (ulRC);
}


int main (int argc, char *argv[])
{
   ULONG ulRC = 0;

   //setbuf (stdout, 0);

   printf ("\n");
   Init (argc, argv);                           // Parse command line options

   if (Options.Help)
      {
      HelpDisplay ();
      return (0);
      }

   ulRC = Open ();
   if (ulRC)
      return (ulRC);
   ulRC = FetchData ();
   if (ulRC == 0)
      ulRC = Display ();
   DosClose (DevHandle);

   return (ulRC);
}
