/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* MADUTIL.c - MAD16 routines that stay resident after initialization
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* MAD16 hardware programming routines that need to remain resident
* after initialization.
*
******************************************************************************/

#define  INCL_16
#define  INCL_DOSINFOSEG
#include <os2.h>

#include <conio.h>              // Watcom intrinsic port i/o routines
#include <dos.h>                // Watcom intrinsic enable/disable interrupts

#include "idc_vdd.h"
#include "data.h"
#include "mad16.h"
#include "util.h"
#include "wss.h"

//                                      ------------------------ Mad16_SetReg -
// Write a MAD16 configuration register
//
VOID Mad16_SetReg (INT Reg, BYTE Value)
{
   BYTE pw;

   pw = 0xE2 + (Specs.usMad16PartNum - 928); // Make pw E2 for 928, E3 for 929
   if (Reg >= ISPBase && Reg <= MC7_PORT)
      {
      _disable ();
      outp (ISPPW_PORT, pw);            // I/O operations must be back to back
      IOdelay ();
      outp (Reg, Value);                // Any other I/O terminates cycle
      IOdelay ();
      _enable ();
      }
}


//                                      ----------------------- Mad16_SetMode -
// After initialization, set mode to the indicated state.
//
USHORT Mad16_SetMode (AUDIOMODES TargetMode)
{
   USHORT usRC = 0;
   BOOL   fNativeOnEntry;

   fNativeOnEntry = ((MC1 & MC1_MODE_WSS) == MC1_MODE_WSS);

   switch (TargetMode)
      {
      case MODENATIVE :
           if (! fNativeOnEntry)
              {
              OPL3AllNotesOff();

              MC1 &= MC1_MODE_CLEAR;
              MC1 |= MC1_MODE_WSS;
              Mad16_SetReg (MC1_PORT, MC1);
              WSS_SaveMixerState (&SBMixerState);
              WSS_SetMixerState  (&WSSMixerState);
              WSS_ClearPEN ();  // Force audio part to no playback/record
              }
           break;
      case MODESOUNDBLASTER :
           if (fNativeOnEntry)
              {
              WSS_SaveMixerState (&WSSMixerState);
              WSS_SetMixerState  (&SBMixerState);
              MC1 &= MC1_MODE_CLEAR;
              Mad16_SetReg (MC1_PORT, MC1);
              }
           break;
      default:
           usRC = 1;
      }

   return (usRC);
}
