/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* MAD16.h - prototypes for various device wakeup functions
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
******************************************************************************/

#define ISPBase    0xF8C
#define ISPPW_PORT (ISPBase+3)  // Password register (write "E2")
#define MC1_PORT   (ISPBase+1)  // SB/WSS, PowerUp, SoundBaseIO, CD Select
#define MC2_PORT   (ISPBase+2)  // CD Base, OPL3/4, CD IRQ, CD DMA
#define MC3_PORT   (ISPBase+3)  // Sound Blaster and CD IRQ/DMA/MIDI selections
#define MC4_PORT   (ISPBase+4)  // User programmable general purpose reg
#define MC5_PORT   (ISPBase+5)  // Diagnostic register
#define MC6_PORT   (ISPBase+6)  // 82C929 MPU-401 config register
#define MC7_PORT   (ISPBase+7)  // 82C929 specific

//
// Useful bit definitions for programming the
// configuration registers of the OPTI 82C928.
//
#define MC1_MODE_CLEAR   0x7F   // Clear bit 7
#define MC1_MODE_SB      0x00   // Bit-7 off
#define MC1_MODE_WSS     0x80
#define MC1_POWERDOWN    0x40

#define MC1_BASE_CLEAR   0xCF   // Clear bits 5..4
#define MC1_BASE_SB220   0x00   // These SB values are for 82C928 only
#define MC1_BASE_SB240   0x30   // Set bit-4 to give WSS address of 604
#define MC1_BASE_WSS530  0x00   // Implies SB address of 220 on 82C928
#define MC1_BASE_WSSE80  0x10   // 929 only (12-bits required for decode)
#define MC1_BASE_WSSF40  0x20   // 929 only (12-bits required for decode)
#define MC1_BASE_WSS604  0x30   // Implies SB address of 240 on 82C928.

#define MC1_CD_CLEAR     0xF1   // Clear bits 3..1
#define MC1_CD_DISABLE   0
#define MC1_CD_SONY31A   0x02
#define MC1_CD_MITSUMI   0x04
#define MC1_CD_PANASONIC 0x06
#define MC1_CD_IDE       0x08   // Secondary IDE (don't allow primary)

#define MC1_GAME_CLEAR   0xFE   // Clear bit 0
#define MC1_GAME_DISABLE 0x01

#define MC2_CDBASE_CLEAR 0x3F   // Clear bits 7..6
#define MC2_CDBASE_320   0xC0
#define MC2_CDBASE_330   0x40
#define MC2_CDBASE_340   0
#define MC2_CDBASE_360   0x80

#define MC2_OPL_CLEAR    0xDF   // Turn off OPL bit
#define MC2_OPL_4        0x20   // Leve off for OPL-3

#define MC2_CDIRQ_CLEAR  0xE3   // Clear bits 4..2
#define MC2_CDIRQ_NONE   0
#define MC2_CDIRQ_3      0x0C   // Valid only for 928
#define MC2_CDIRQ_5      0x04
#define MC2_CDIRQ_7      0x08
#define MC2_CDIRQ_9      0x10
#define MC2_CDIRQ_10     0x14
#define MC2_CDIRQ_11     0x18

#define MC2_CDDMA_CLEAR  0xFC   // Clear bits 2..1
#define MC2_CDDMA_NONE   0x03
#define MC2_CDDMA_1      0x02   // DMA 1-3 only valid for Sony or Panasonic
#define MC2_CDDMA_2      0x01   // For 928
#define MC2_CDDMA_0      0x01   // For 929

#define MC2_CDDMA_3      0
#define MC2_CDDMA_5      0      // DMA 5-7 only valid for Mitumi & IDE
#define MC2_CDDMA_6      0x01   // NOTE: Upper DMA channels don't work on 928
#define MC2_CDDMA_7      0x02   // and are not valid options on 929

#define MC3_SBIRQ_CLEAR  0x3F   // Clear SB IRQ bits (7..6)
#define MC3_SBIRQ_NONE   0xC0
#define MC3_SBIRQ_5      0x80
#define MC3_SBIRQ_7      0
#define MC3_SBIRQ_11     0x40   // For 82C928
#define MC3_SBIRQ_10     0x40   // For 82C929

#define MC3_SBDMA_CLEAR  0xCF   // Clear SB DMA bits (5..4)
#define MC3_SBDMA_NONE   0x30
#define MC3_SBDMA_1      0
#define MC3_SBDMA_2      0x10   // For 82C928
#define MC3_SBDMA_0      0x10   // For 82C929
#define MC3_SBDMA_3      0x20

#define MC3_FMAP_CLEAR   0xF7   // Clear bit 3
#define MC3_FMAP_SNGL    0x08

#define MC3_ENMIDI_CLEAR 0xFB   // Clear bit 2 (this parm 928 only)
#define MC3_ENMIDI       0x04   // Enable FM MIDI when in WSS mode

#define MC3_SBBASE_CLEAR 0xFB   // Clear bit 2 (this parm 929 only)
#define MC3_SBBASE_220   0      // On 929, this bit selects base address
#define MC3_SBBASE_240   0x04   // for Sound Blaster mode. (220 or 240).

#define MC3_SEL_CLEAR    0xFC   // Clear bits 1..0
#define MC3_SEL_MC4      0
#define MC3_SEL_MC5      0x01
#define MC3_SEL_SB_IN    0x02
#define MC3_SEL_SB_CMD   0x03

#define MC4_SBVER_CLEAR  0xFC   // Clear bits 1..0
#define MC4_SBVER_15     0x01
#define MC4_SBVER_20     0x00
#define MC4_SBVER_32     0x02
#define MC4_SBVER_44     0x03
#define MC4_OPTI_VER_CLR 0xC7   // Clear bits 5..3

// Note: Bits 5..3 are used to set/read OPTi version
// Bit 5 is set to one to enable version set.
// Bits 4..3 are 00 -> 'B'
// Bits 4..3 are 01 -> 'C'
// Advise from OPTi, set only the SB Version bits

#define MC5_EM           0x80   // Command Emulation Enable Used with MC6,7
#define MC5_EI           0x40   // Emulation interrupt.
#define MC5_SHPASS       0x20   // Protect shadow registers
#define MC5_SPACCESS     0x10   // Enable access to CODEC when in SB mode
#define MC5_CFIFO_PDMA   0x08   // Enable command FIFO in Sound Blaster mode
#define MC5_EPENB_CDMA   0x04   // Enable volume effect for SB Pro mixer
#define MC5_CFIX_PEN     0x02   // Enable fix for CS4248/4231 sync delays
#define MC5_EISEL        0x01   // EI select. If 0 IRQ9. If 1 IRQ10

USHORT Mad16_Wakeup (PSZ pszLine);              // mad16.c
VOID Mad16_SetReg (INT Reg, BYTE Value);        // madutil.c
USHORT Mad16_SetMode (AUDIOMODES TargetMode);   // madutil.c
