/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* IOCTL.C - Device driver strategy IOCTL routine processing
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*
******************************************************************************/

#include <stdlib.h>             // For min macro
#include <string.h>             // _memset

#define  INCL_16
#define  INCL_DOSINFOSEG
#include <os2.h>

#include "reqpkt.h"
#include "util.h"
#include "idc_vdd.h"
#include "data.h"
#include "string.h"
#include "trace.h"
#include "ioctl.h"
#include "mad16.h"


//                                      ---------------------- IoctlGetMsgBuf -
// Provide trace message buffer and index to app
//    IOCTL Param field == Buffer index
//    IOCTL Data  field == Buffer data
//
void IoctlGetMsgBuf (REQPACKET far *rpP)
{
   size_t Tmp;

   _fmemcpy (rpP->Packet.Ioctl.ParamBufP, &TraceIndex, sizeof(TraceIndex));

   Tmp = min (rpP->Packet.Ioctl.DataLen, TRACEBUFSIZE);
   rpP->Packet.Ioctl.DataLen = Tmp;
   _fmemcpy (rpP->Packet.Ioctl.DataBufP, pTraceBuf, Tmp);

   rpP->Status = RPDONE;
}

//                                      ----------------------- IoctlGetSpecs -
// Provide device specifications to app
//    IOCTL Parm field == unused
//    IOCTL Data field == Buffer data
//
void IoctlGetSpecs (REQPACKET far *rpP)
{
   size_t Tmp;

   Tmp = min (rpP->Packet.Ioctl.DataLen, sizeof (Specs));
   _fmemcpy (rpP->Packet.Ioctl.DataBufP, pSpecs, Tmp);
   rpP->Packet.Ioctl.DataLen = Tmp;
   rpP->Status = RPDONE;
}

//                                      ------------------ IoctlQueryAudioMode -
// App queries current audio mode (WSS, SB)
//    IOCTL Parm field == unused
//    IOCTL Data field == Buffer data (ULONG) set as
//                        0->Sound Blaster mode, 1->WSS
//
void IoctlQueryAudioMode (REQPACKET far *rpP)
{
   ulTemp = ((MC1 & ~MC1_MODE_CLEAR) == MC1_MODE_WSS);
   if (rpP->Packet.Ioctl.DataLen == sizeof(ULONG))
      _fmemcpy (rpP->Packet.Ioctl.DataBufP, &ulTemp, sizeof(ULONG));
   rpP->Status = RPDONE;
}

void (*IoctlFuncs[]) (REQPACKET far *rpP) =
{
   IoctlGetMsgBuf,
   IoctlGetSpecs,
   IoctlQueryAudioMode
};
USHORT MaxIoctlFuncs = sizeof(IoctlFuncs)/sizeof(USHORT);

//                                      ----------------------- StrategyIOCTL -
// IOCTL processing.
// Routine is called from strategy entrypoint when the
// strategy command indicates generic IOCTL.
//
void StrategyIOCTL (REQPACKET far *rpP)
{
   UCHAR Func = rpP->Packet.Ioctl.Function;

   if (rpP->Packet.Ioctl.Category != IOCTLCATEGORY ||
       Func < 0x40 ||
       Func > 0x40 + MaxIoctlFuncs - 1)
      {
      rpP->Status = RPERR | RPDONE | RPUNKCMND;
      return;
      }

   IoctlFuncs [Func - 0x40] (rpP);
}
