/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* INIT.C - Device driver initialization
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Contains device driver strategy initialization
* This is the substance of this device driver as all processing occurs
* during initialization.
*
* Code parses config.sys command line and performs actions based on the parms.
*
* PURPOSE: Wakeup hardware devices that require tickling from software
*          to come to life.
*
* For example, the Media Magic audio card powers up with only the
* Sound Blaster hardware enabled (at default locations).
* No CD-ROM enabled, no CS4231 audio CODEC enabled.
* By providing parm to this driver, the code will turn on the Media Magic
* device at the indicated settings.  Settings are particular to the device.
*
******************************************************************************/

#define  INCL_16
#define  INCL_DOSINFOSEG
#include <os2.h>
#include <dhcalls.h>

#include "reqpkt.h"
#include "strategy.h"
#include "header.h"
#include "idc_vdd.h"
#include "data.h"
#include "util.h"
#include "mad16.h"
#include "ddstring.h"
#include "trace.h"

extern USHORT _near EndOfDataSegment;
extern USHORT _near EndOfCodeSegment;

//
// Markers for segment truncation
//
USHORT StartInitData = 1;       // Variables must have an initial value
                                // This effects its position in data segment
PSZ pszCmndLine      = NULL;

//
// ASCII Z-String used to register for PDD-VDD IDC must
// Name is copied from header at runtime.
//
char  szPddName [9]  = {0};

//Variables used to allocate swappable memory
SEL   Sel        = 0;
ULONG Bonus      = 0;           // VMAlloc/VMLock require bonus parameter
LIN   pPages     = 0;           // Linear address of pagelist array
LIN   pLock      = 0;           // Linear address of lock handle
#define PAGECOUNT ((TRACEBUFSIZE-1)/4096+1)
PAGELIST Pages [PAGECOUNT] = {0,0};
ULONG LockHandle = 0;

void StartInitCode (void)
{
}

void CopyNameFromHeader (void)
{
   int I;

   // Copy device driver name from header.
   // Where the header has space in name, stop the copy.
   dd_memset (szPddName, '\0', sizeof(szPddName));
   for (I = 0; I < sizeof(szPddName)-1 ; I++)
      {
      if (Devhdr[0].name[I] <= ' ')
         break;
      szPddName[I] = Devhdr[0].name[I];
      }
}

//                                      -------------------------- Trace_Init -
// Allocate swappable data for storage of trace infomation.
//
// See trace.c for description of trace buffer
//
USHORT Trace_Init (void)
{
   USHORT usRC;

   //Commented code does physical memory allocation
   //usRC = DevHelp_AllocGDTSelector (&Sel, 1);
   //if (usRC)
   //   return (usRC);
   //
   //usRC = DevHelp_AllocPhys (4*1024, MEMTYPE_ABOVE_1M, &ulTemp);
   //if (usRC)
   //   return (usRC);
   //DevHelp_PhysToGDTSelector (ulTemp, 4*1024, Sel);
   //pTraceBuf = MAKEP (Sel, 0);
   //dd_memset (pTraceBuf, '\0', 4*1024);
   //return (usRC);

   // Seemingly a simple task, there are lots of steps.

   pTraceBuf = NULL;

   usRC = DevHelp_AllocGDTSelector (&Sel, 1);
   if (usRC)
      return (usRC);
   usRC = DevHelp_VMAlloc
          (VMDHA_SWAP, TRACEBUFSIZE, -1, (PLIN)&ulTemp, (PPVOID)&Bonus);
   if (usRC)
      return (usRC);

   pPages = (LIN)&Pages;
   DevHelp_VirtToLin (SELECTOROF(pPages), OFFSETOF(pPages), &pPages);
   pLock = (LIN)&LockHandle;
   DevHelp_VirtToLin (SELECTOROF(pLock), OFFSETOF(pLock), &pLock);
   usRC = DevHelp_VMLock (0, (LIN) ulTemp, TRACEBUFSIZE, pPages, pLock, &Bonus);
   if (usRC)
      return (usRC);
   usRC = DevHelp_LinToGDTSelector (Sel, ulTemp, TRACEBUFSIZE);
   DevHelp_VMUnLock (pLock);
   if (usRC == 0)
      {
      pTraceBuf = MAKEP (Sel, 0);
      dd_memset (pTraceBuf, '\0', TRACEBUFSIZE);
      }
   return (usRC);
}


//                                      ------------------------ StrategyInit -
// Device driver initialization routine.
// Is called twice (once per device header).
// All the work is done on the first init.
// On the second, the code and data segments are truncated
// to discard that which is not needed beyond initialization.
//
// Two device headers are used so that this device driver
// can respond to multiple names.
//
VOID StrategyInit (REQPACKET far *rpP)
{
   USHORT usRC;

   if (fInited)  // Final init call?
      {
      //
      // Truncate data and code segments
      //
      rpP->Packet.InitOut.CodeEnd = (USHORT)&StartInitCode;
      rpP->Packet.InitOut.DataEnd = (USHORT)&StartInitData;
      rpP->Status = RPDONE;
      return;
      }
   fInited = TRUE;

   Device_Help = rpP->Packet.InitIn.DevhlpEntry;
   pszCmndLine = rpP->Packet.InitIn.ArgP;

   usRC = Trace_Init ();
   if (usRC != 0)
      {
      rpP->Status = RPDONE + RPERR;
      return;
      }

   //
   // The PDD has a data structure which describes the hardware
   // on the adapter board.  This information is needed local to
   // this PDD, in other PDDs and in the VDD.
   // Create assorted addresses to make the structure accessible.
   //
   pSpecs = &Specs;
   dd_memset (pSpecs, '\0', sizeof(Specs));
   DevHelp_VirtToLin (SELECTOROF(pSpecs), OFFSETOF(pSpecs), (PLIN)&pLinSpecs);

   //
   // Register this device driver with OS/2 resource manager
   //


   //
   // Call function that brings device to life
   //
   usRC = Mad16_Wakeup (pszCmndLine);

   if (usRC == 0)
      {
      CopyNameFromHeader ();
      usRC = DevHelp_RegisterPDD ((NPSZ)szPddName, (PFN)IDCEntry_VDD);
      }

   rpP->Packet.InitOut.CodeEnd = (USHORT)&EndOfCodeSegment;
   rpP->Packet.InitOut.DataEnd = (USHORT)&EndOfDataSegment;

   //
   // Even with failure, load successfully
   // Staying loaded gives the user an opportunity to view
   // the diagnostic information via IOCTL from application.
   //
   rpP->Status = RPDONE; // RPERR + 15          // Fail quietly (unload)

}
