/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* idc_vdd.h - Prototypes for functions for mad16 PDD-VDD IDC
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* This header is used common between the PDD, VDD and applications that
* communicate with the PDD via IOCTL
*
******************************************************************************/

#pragma pack (1)        // Force byte structure alignment

#ifndef __IBMC__        // Following is only for the PDD and VDD
ULONG FAR pascal IDCEntry_VDD (ULONG ulFunc, ULONG ul1, ULONG ul2); // ASM
#endif

//
// Structure which describes the MAD16 hardware.
// Should be considered *read-only* by everyone except mad16.add
// Address of this structure can be queried via IDC call.
// A few of these fields are actually constants.  Storing them
// here makes it easier to display from the diagnostic application.
//
typedef struct
        {
        USHORT  usStrucSize;                    // Size of this structure
        USHORT  usMad16PartNum;                 // 928 or 929
        USHORT  usMad16Revision;                // 928 only ('B' or 'C')
        USHORT  usMad16Base;                    // Address of OPTi part (0xF8F)
        USHORT  usMad16Range;                   // 8
        USHORT  usMad16DecodeWidth;             // 10 for 928, 12 for 929
        USHORT  usWSSCodecType;                 // 'C', 'A'
        USHORT  usWSSGrade;                     // 'J', 'K'
        USHORT  usWSSBase;
        USHORT  usWSSRange;
        USHORT  usWSSIndex;
        USHORT  usWSSData;
        USHORT  usWSSIRQ;                       // Device interrupt
        USHORT  usWSSPlayDMA;
        USHORT  usWSSRecordDMA;
        USHORT  usSBBase;
        USHORT  usSBRange;                      // Set to 16
        USHORT  usSBIRQ;
        USHORT  usSBDMA;
        USHORT  usCDType;                       // Valid = N, S, P, M, I
        USHORT  usCDBase;                       // Default 340
        USHORT  usCDRange;                      // IDE:8 Sony:4 Mitsumi:3 Pan:4
                                                // IDE also has 1 at Base+0x206
        USHORT  usCDIRQ;                        // 0 means no IRQ
        USHORT  usCDDMA;                        // 0 means no DMA
        USHORT  usOPL3Base;
        USHORT  usOPL3Range;
        } MAD16SPECS;
typedef MAD16SPECS *PMAD16SPECS;


//
// Declarations to assist other drivers
// calling into the wakeup PDD.
//
typedef enum
        {
        IDCOPEN,
        IDCRESERVED,
        IDCGETDEVICEINFO,
        IDCSETMODE,
        IDCOPL3ALLNOTESOFF
        } IDCFUNCS;

typedef enum                    // Used for setting audio mode
        {
        MODENATIVE,
        MODESOUNDBLASTER
        } AUDIOMODES;
#pragma pack ()
