/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* IDC_VDD.C - Device driver inter-device communication routines for VDDs
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Contains device driver routines for communicating with other device drivers.
*
******************************************************************************/

#define  INCL_16
#define  INCL_DOSINFOSEG
#include <os2.h>
#include <dhcalls.h>

#include "util.h"
#include "idc_vdd.h"
#include "data.h"
#include "mad16.h"

#pragma off (unreferenced);

ULONG IDCVddSuccess (ULONG ul1, ULONG ul2)
{
   return (TRUE);
}

//                                      -------------------------- IDCVddOpen -
// OS/2 MVDM kernel calls us to provide the IDC address
// of the Virtual Device driver.
// The VDD can also call (with address of NULL) to terminate
// future IDC between the drivers.
//
ULONG IDCVddOpen (ULONG ul1, ULONG ul2)
{
   // Nothing to do, we don't call the VDD
   return (TRUE);
}

ULONG IDCVddUnsupported (ULONG ul1, ULONG ul2)
{
   return (FALSE);
}

ULONG IDCVddReserved (ULONG ul1, ULONG ul2)
{
   return (FALSE);
}

//                                      ----------------- IDCVddGetDeviceInfo -
// Return linear address of buffer holding description
// of the base address, IRQ and other information
// about the device.
//
ULONG IDCVddGetDeviceInfo (ULONG ul1, ULONG ul2)
{
   return ((ULONG)pLinSpecs);
}

//                                      ------------------ IDCVddSetAudioMode -
// VDD instructs us to configure the device for
// either the device native mode or Sound Blaster
// compatible mode.
// PARMS: (ul1)
//    0 -> Set Native mode
//    1 -> Set Sound Blaster mode
//
// RETURNS:
//    TRUE  -> Success
//    FALSE -> Failed
//
ULONG IDCVddSetMode (ULONG ul1, ULONG ul2)
{
   USHORT usRC;

   usRC = Mad16_SetMode (ul1);

   return (usRC == 0);
}

//                                      ---------------------- IDCVddMuteOPL3 -
// OPL-3 FM - Turn off all notes
//
ULONG IDCVddOPL3AllNotesOff (ULONG ul1, ULONG ul2)
{
   OPL3AllNotesOff();
   return (TRUE);
}


ULONG (*IDCVddFuncs[]) (ULONG ul1, ULONG ul2) =
{
   IDCVddOpen,          // MVDM kernel defined
   IDCVddSuccess,       // Reserved (mvdm shutdown?)
   IDCVddGetDeviceInfo,
   IDCVddSetMode,
   IDCVddOPL3AllNotesOff
};
USHORT MaxIDCVddFuncs = sizeof(IDCVddFuncs)/sizeof(USHORT);


//                                      ---------------------- IDCEntry_VDD_c -
// Interface for other VDDs to call this device driver
//
ULONG pascal IDCEntry_VDD_c (ULONG ulFunc, ULONG ul1, ULONG ul2)
{
   if (ulFunc > MaxIDCVddFuncs)
      {
      return (FALSE);
      }
   else
      {
      return (IDCVddFuncs [ulFunc](ul1,ul2));
      }
}
