/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* IDC_PDD.h - Device driver inter-device communication headers for PDDs
*
* Copyright (c) Cystal Semiconductor 1995.
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Contains device driver routines for communicating with other device drivers.
*
******************************************************************************/

//
// basedev.h
//


    // constant definitions
#define CMD_DEVINFO  0

#define DEV_NOASIC   0
#define DEV_WSSPAL   1
#define DEV_THINKPAD 2
#define DEV_MAD16    3
#define DEV_OPTi929  4
#define DEV_GALLANT  5

#define CD_SONY      1
#define CD_MITSUMI   2
#define CD_PANASONIC 3


typedef struct {
   ULONG  ulCmd;
   VOID  *pBufP;
} PDD_IDC;

typedef struct {
   USHORT dev_type;
   union {
      struct {
         USHORT base_addr;
         USHORT codec_int;
         USHORT playback_dma;
         USHORT capture_dma;
      } crystal;
   } dev;
} DEV_INFO;


// public function prototypes
USHORT FAR _cdecl IDCEntry_PDD (PDD_IDC *rpP);  // ASM
ULONG _System IDCEntry_PDD_c (PDD_IDC *rpP);    // C
