/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* IDC_PDD.C - Device driver inter-device communication routines for PDDs
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Contains device driver routines for communicating with other device drivers.
*
******************************************************************************/

#define  INCL_16
#define  INCL_DOSINFOSEG
#include <os2.h>
#include <dhcalls.h>

#include "util.h"
#include "idc_vdd.h"
#include "idc_pdd.h"
#include "data.h"
#include "mad16.h"

//                                      ------------------------ IDCEntry_PDD -
// 16:16 entry from 16:16 caller
// Provide interface for audio PDD to call this device driver
//
// Execution is routed here via assembler stub
// so that we can load and *restore* the DS selector.
//
ULONG _System IDCEntry_PDD_c (PDD_IDC *rpP)
{
   DEV_INFO *pDevInfo;
   ULONG    ulRC;
   USHORT   usType;

   switch (rpP->ulCmd) {
      case CMD_DEVINFO:
         // set pointer to data structure
         pDevInfo = (DEV_INFO *) rpP->pBufP;

         if (Specs.usMad16PartNum == 928)
            usType = DEV_MAD16 + 0x80;     // Turn on the hex 80 bit to tell the
         else                              // audio PDD to unmute AUX-2.
            usType = DEV_OPTi929 + 0x80;   // This makes OPL-3 audible

         // get current configuration
         if (pDevInfo)
            {
            pDevInfo->dev_type                 = usType;
            pDevInfo->dev.crystal.base_addr    = Specs.usWSSBase;
            pDevInfo->dev.crystal.codec_int    = Specs.usWSSIRQ;
            pDevInfo->dev.crystal.playback_dma = Specs.usWSSPlayDMA;
            pDevInfo->dev.crystal.capture_dma  = Specs.usWSSRecordDMA;
            }
         ulRC = 0; // Success
         break;

      default:
         ulRC = 1; // Failed
         break;
   }

   // success!
   return (ulRC);
}
