/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* HEADER.C - Device driver header (DevHdr)
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Contains device header  ( first element of data segment )
* Must be first data object given to the linker.
*
******************************************************************************/

#include <os2.h>

#include "reqpkt.h"
#include "strategy.h"
#include "idc_pdd.h"
#include "header.h"

#define RESERVED_4BYTES 0


/*                          15 = 1    character device
**                          14 = 0    offset to idc entry point is not set
**                          13 = 0    for block device driver use only
**                          12 = 0    shared device
**                          11 = 1    open / close is required
**                          10 = 0    reserved
**   001 -OS2 driver         9 = 0    9..7 device level
**   010 -has ioct2 support  8 = 1
**   011 -Uses Cap. Bit      7 = 1
**                           6 = 0    reserved (os/2 1.x IOCTLs)
**                           5 = 0    reserved
**                           4 = 0    reserved
**                           3 = 0    clock device
**                           2 = 0    null device
**                           1 = 0    stdout device
**                           0 = 0    stdin device
*/
#define DEV_ATTRIB1 0x8980     /*  1000 1001 1000 0000 */
#define DEV_ATTRIB2 0xC980     /*  1100 1001 1000 0000 */


/*
** 5..31 = 0    reserved
**     4 = 0    Want InitComplete / shutdown packets
**     3 = 0    Participate in Adapter Device Driver Init (ADD)
**     2 = 0    Parrallel Port Support
**     1 = 1    32 Bit Addressibility
**     0 = 1    DosDevIoct2 Support
*/
#define DEV_CAPS 0x00000003         /* 0000 0000 0000 0011 */

DEVHDR Devhdr[2] =
{
   {&Devhdr[1],                               // pNext
   DEV_ATTRIB1,
   MAD16_Strategy,                            // Offset to strategy routine
   NULL,                                      // IDC entrypoint for PDDs
   "MAD16$  ",                                // Name of device driver
   RESERVED_4BYTES,                           // 8 bytes reserved
   RESERVED_4BYTES,
   DEV_CAPS
   },

   { -1,                                      // pNext - Filled in by kernel
   DEV_ATTRIB2,
   MAD16_Strategy,                            // Offset to strategy routine
   IDCEntry_PDD,                              // IDC entrypoint for PDDs
   "CRYSTAL$",                                // Name of device driver
   RESERVED_4BYTES,                           // 8 bytes reserved
   RESERVED_4BYTES,
   DEV_CAPS
   }
};
