/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* util.h - Prototypes for functions and data in .C file of same name
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
******************************************************************************/

#ifndef size_t
#define size_t unsigned
#endif
void *dd_memcpy (void *__s1, const void *__s2, size_t __n );
void __far *dd_fmemcpy (void __far *__s1, const void __far *__s2, size_t __n);
void *dd_memset (void *__s, int __c, size_t __n);
void *dd_memchr (const void *__s, int __c, size_t __n);
int dd_toupper (int ch);
char *dd_strcpy (CHAR *str1P, CHAR *str2P);
char *dd_strncpy (char *__s1, const char *__s2, size_t __n);
char *dd_strcat (char *__s1, const char *__s2);
int dd_strcmp (const char *__s1, const char *__s2);
int dd_stricmp (const char *__s1, const char *__s2);
int dd_strncmp (const char *__s1, const char *__s2, size_t __n);
int dd_strincmp (const char *__s1, const char *__s2, size_t __n);

#define BASE10 10
#define BASE16 16
USHORT ascii_to_ushort (char *srcP, USHORT *numP, USHORT usBase);

#define MAXTOKENSIZE 64
typedef struct {
   BOOL   fColonFound;
   BOOL   fNumericFound;
   USHORT usValue;                      // Number on right side of colon
   CHAR   szKeyword [MAXTOKENSIZE];     // String on left side of colon
   CHAR   szValue [MAXTOKENSIZE];       // String on right side of colon
   } PARSEDTOKEN;
typedef PARSEDTOKEN *PPARSEDTOKEN;

void NextToken (char **ppSt);
void SplitToken (char *pszLine, PPARSEDTOKEN pParsedToken);
