/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* DDPRINTF.C - Device driver string display
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
*******************************************************************************
*
* Routines can be called during device driver initialization to display
* strings to the video terminal.
* Should be linked to device driver code as discardable code (init only)
*
*/

#define INCL_NOPMAPI
#define DRV_16
#include <os2.h>
#include <dhcalls.h>

#include "util.h"
#include "ddstring.h"
#include "ddprintf.h"
#include "trace.h"

#define CR 0x0d
#define LF 0x0a

#define LEADING_ZEROES          0x8000
#define SIGNIFICANT_FIELD       0x0007

typedef unsigned short WORD;
typedef unsigned long DWORD;

char ddhextab[]="0123456789ABCDEF";

                                        //----------- ddprintf_DecWordToASCII -
char far * ddprintf_DecWordToASCII(char far *StrPtr, WORD wDecVal, WORD Option)
{
  BOOL fNonZero=FALSE;
  WORD Digit;
  WORD Power=10000;

  while (Power)
     {
     Digit=0;
     while (wDecVal >=Power)                   //Digit=wDecVal/Power;
        {
        Digit++;
        wDecVal-=Power;
        }

     if (Digit)
        fNonZero=TRUE;

     if (Digit ||
         fNonZero ||
         (Option & LEADING_ZEROES) ||
         ((Power==1) && (fNonZero==FALSE)))
         {
         *StrPtr=(char)('0'+Digit);
         StrPtr++;
         }

     if (Power==10000)
        Power=1000;
     else if (Power==1000)
        Power=100;
     else if (Power==100)
        Power=10;
     else if (Power==10)
        Power=1;
     else
        Power=0;
     } // end while

  return (StrPtr);
}

                                        //----------- ddprintf_DecLongToASCII -
char far * ddprintf_DecLongToASCII(char far *StrPtr, DWORD lDecVal,WORD Option)
{
   BOOL  fNonZero=FALSE;
   DWORD Digit;
   DWORD Power=1000000000;                      // 1 billion

   while (Power)
      {
      Digit=0;                                                                        // Digit=lDecVal/Power
      while (lDecVal >=Power)                   // replaced with while loop
         {
         Digit++;
         lDecVal-=Power;
         }

      if (Digit)
         fNonZero=TRUE;

      if (Digit ||
          fNonZero ||
          (Option & LEADING_ZEROES) ||
          ((Power==1) && (fNonZero==FALSE)))
         {
         *StrPtr=(char)('0'+Digit);
         StrPtr++;
         }

      if (Power==1000000000)                    // 1 billion
         Power=100000000;
      else if (Power==100000000)
         Power=10000000;
      else if (Power==10000000)
         Power=1000000;
      else if (Power==1000000)
         Power=100000;
      else if (Power==100000)
         Power=10000;
      else if (Power==10000)
         Power=1000;
      else if (Power==1000)
         Power=100;
      else if (Power==100)
         Power=10;
      else if (Power==10)
         Power=1;
      else
         Power=0;
      }
   return (StrPtr);
}
                                        //----------- ddprintf_HexWordToASCII -
char far * ddprintf_HexWordToASCII(char far *StrPtr, WORD wHexVal, WORD Option)
{
   BOOL fNonZero=FALSE;
   WORD Digit;
   WORD Power=0xF000;
   WORD ShiftVal=12;

   while (Power)
      {
      Digit=(wHexVal & Power)>>ShiftVal;
      if (Digit)
         fNonZero=TRUE;

      if (Digit ||
          fNonZero ||
          (Option & LEADING_ZEROES) ||
          ((Power==0x0F) && (fNonZero==FALSE)))
         //*StrPtr++=(char)('0'+Digit);
         *StrPtr++=ddhextab[Digit];

      Power>>=4;
      ShiftVal-=4;
      } // end while

   return (StrPtr);
}

                                        //----------- ddprintf_HexLongToASCII -
char far * ddprintf_HexLongToASCII(char far *StrPtr, DWORD wHexVal, WORD Option)
{
   BOOL  fNonZero=FALSE;
   DWORD Digit;
   DWORD Power=0xF0000000;
   DWORD ShiftVal=28;

   while (Power)
      {
      Digit=(wHexVal & Power)>>ShiftVal;
      if (Digit)
         fNonZero=TRUE;

      if (Digit ||
          fNonZero ||
          (Option & LEADING_ZEROES) ||
          ((Power==0x0F) && (fNonZero==FALSE)))
          *StrPtr++=ddhextab[Digit];

      if (Power==0xF0000000)                  // 1 billion
         Power=0xF000000;
      else if (Power==0xF000000)
         Power=0xF00000;
      else if (Power==0xF00000)
         Power=0xF0000;
      else if (Power==0xF0000)
         Power=0xF000;
      else if (Power==0xF000)
         Power=0xF00;
      else if (Power==0xF00)
         Power=0xF0;
      else if (Power==0xF0)
         Power=0xF;
      else Power=0;

      ShiftVal-=4;
      } // end while

   return (StrPtr);
}

char dd_BuildString[1024];

                                        //-------------------------- ddprintf -
VOID cdecl ddprintf (char far *DbgStr , ...)
{
   char far *BuildPtr=dd_BuildString;
   char far *pStr=(char far *) DbgStr;
   char far *SubStr;
   union {
         VOID    far *VoidPtr;
         WORD    far *WordPtr;
         DWORD   far *LongPtr;
         DWORD far *StringPtr;
         } Parm;
   WORD wBuildOption;

   Parm.VoidPtr=(VOID far *) &DbgStr;
   Parm.StringPtr++;                            // skip size of string pointer

   while (*pStr)
      {
      // don't overflow target
      if (BuildPtr >= (char far *) &dd_BuildString[1024-2])
         break;

      switch (*pStr)
         {
         case '%':
            wBuildOption=0;
            pStr++;
            if (*pStr=='0')
               {
               wBuildOption|=LEADING_ZEROES;
               pStr++;
               }
            if (*pStr=='u')                                                         // always unsigned
               pStr++;

            switch(*pStr)
               {
               case 'x':
                  BuildPtr=ddprintf_HexWordToASCII(BuildPtr, *Parm.WordPtr++,wBuildOption);
                  pStr++;
                  continue;

               case 'd':
                  BuildPtr=ddprintf_DecWordToASCII(BuildPtr, *Parm.WordPtr++,wBuildOption);
                  pStr++;
                  continue;

               case 's':
                  SubStr=(char far *)*Parm.StringPtr;
                  while (*BuildPtr++ = *SubStr++);
                  Parm.StringPtr++;
                  BuildPtr--;                      // remove the \0
                  pStr++;
                  continue;

               case 'l':
                  pStr++;
                  switch (*pStr)
                  {
                  case 'x':
                  BuildPtr=ddprintf_HexLongToASCII(BuildPtr, *Parm.LongPtr++,wBuildOption);
                  pStr++;
                  continue;

                  case 'd':
                     BuildPtr=ddprintf_DecLongToASCII(BuildPtr, *Parm.LongPtr++,wBuildOption);
                     pStr++;
                     continue;
                  } // end switch
                  continue;                        // dunno what he wants

               case 0:
                  continue;
               } // end switch
            break;

      case '\\':
         pStr++;
         switch (*pStr)
            {
            case 'n':
            *BuildPtr++=CR;
            *BuildPtr++=LF;
            pStr++;
            continue;

            case 'r':
            *BuildPtr++=CR;
            pStr++;
            continue;

            case 0:
            continue;
            break;
            } // end switch

         break;
         } // end switch

      *BuildPtr++=*pStr++;
      } // end while

   *BuildPtr=0;                                 // cauterize the string
   ddputstring((char far *) dd_BuildString);    // display
}

// Following declarations are need for
// string display from basedev
#define MSG_REPLACEMENT_STRING               1178       /*replacement string */
//UCHAR szStringOut [CCHMAXPATH];
MSGTABLE StringOutMsg = {MSG_REPLACEMENT_STRING, 1, NULL};

                                        //----------------------- ddputstring -
VOID ddputstring (char far *St)
{
   //int      iMsgLength;
   //char far *TempSt;
   //
   //TempSt = St;
   //iMsgLength = 0;
   //while (*TempSt != '\0')
   //   {
   //   TempSt++;
   //   iMsgLength++;
   //   }               // Should strcat a \r\n to the string.
   //DosPutMessage (1, iMsgLength, St);         // For ring-3 initialization

   Trace_Save_Message (St);
   StringOutMsg.MsgStrings[0] = St;
   DevHelp_Save_Message ((NPBYTE)&StringOutMsg);

   //dd_strcpy (szStringOut, (NPBYTE)St);      // For ring-0 initialization
   //szStringOut [CCHMAXPATH-1] = '\0';
}
