/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************
* DATA.C - Device driver data
*
*
* The following IBM OS/2 source code is provided to you solely for the
* the purpose of assisting you in your development of OS/2 device drivers.
* You may use this code in accordance with the IBM License Agreement
* provided in the IBM Device Driver Source Kit for OS/2.
******************************************************************************/

#define  INCL_16
#define  INCL_DOSINFOSEG
#include <os2.h>

#include "idc_vdd.h"
#include "data.h"
#include "mad16.h"

//
// NOTE: All variables intended to be global throughout the life
// of the device driver (accessible after initialization) must be
// explicitly initiailizted.
// Non initialized variables will be placed in the compiler generated BSS
// segment, which is AFTER the last data item retained after initialization.
//

PFN             Device_Help = NULL;  // Referenced by dhcalls.lib
PMAD16SPECS     pLinSpecs   = NULL;  // Linear address of Specs
PMAD16SPECS     pSpecs      = NULL;  // 16:16 pointer to Specs
MAD16SPECS      Specs       = {0};   // Data structure describing adapter
BOOL            fInited     = FALSE;
ULONG           ulTemp      = 0;

OPTIONS         Options     = {0};
PCHAR           pTraceBuf   = NULL;
USHORT          TraceIndex  = 0;

//
// MediaChips(OPTi) MAD16 configuration registers
// Define data elements and default values.
//
BYTE MC1 = MC1_MODE_WSS | MC1_BASE_WSS530 | MC1_CD_DISABLE;
BYTE MC2 = MC2_CDIRQ_NONE | MC2_CDDMA_NONE;
BYTE MC3 = MC3_SBIRQ_7 | MC3_SBDMA_1 | MC3_ENMIDI;
BYTE MC4 = MC4_SBVER_32;
BYTE MC5 = 0;
BYTE MC6 = 0x03;
BYTE MC7 = 0x0A; // Maybe 0A    // MC7 is read by VOLTSR for r/w volume ctrl
                                // bit-7 gets turned on if SB base is 240
//
// Defaults for attenuation are set in the below structure.
// Values change as programs modify the mixer settings
// and as modes change between WSS and Sound Blaster modes.
// Separate mixer states are maintained for each mode.
//
MIXERSTATE      WSSMixerState =
                {
                0x28,           // Left_Input_Control
                0x28,           // Right_Input_Control
                0x14,           // Left_AUX1_Input_Control
                0x14,           // Right_AUX1_Input_Control
                0x0F,           // Left_AUX2_Input_Control
                0x0F,           // Right_AUX2_Input_Control
                0x14,           // Left_Output_Control
                0x14            // Right_Output_Control
                };

MIXERSTATE      SBMixerState =
                {
                0x28,           // Left_Input_Control
                0x28,           // Right_Input_Control
                0x14,           // Left_AUX1_Input_Control
                0x14,           // Right_AUX1_Input_Control
                0x0F,           // Left_AUX2_Input_Control
                0x0F,           // Right_AUX2_Input_Control
                0x14,           // Left_Output_Control
                0x14            // Right_Output_Control
                };
