/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#pragma linkage(_RGB16_to_PAL8, system)
extern void _RGB16_to_PAL8 ( USHORT *ImageIn,
                             BYTE   *ImageOut,
                             ULONG  LineSize,
                             ULONG  X_width,
                             ULONG  Y_height,
                             ULONG  scale);
   // Converts a RGB16 image to a PAL8 image
   // A lookup table is used for the conversion and dithering is preformed
   // The ImageOut buffer may NOT be the same as the ImageIn buffer.
   // LineSize indicates the number of bytes that should be skipped in
   // the out put data stream after a each line is written (for example
   // if XGA with the sreen width = 1024 and output X_width = 320, then
   // Linesize = 1024-320 = 704
   // X_width  size of input image width
   // Y_height size of input image height
   // Scale increase the output image by 2 if = 1

#pragma linkage(_RGB16_to_IPAL8, system)
extern void _RGB16_to_IPAL8 ( USHORT *ImageIn,
                              BYTE   *ImageOut,
                              ULONG  LineSize,
                              ULONG  X_width,
                              ULONG  Y_height,
                              ULONG  scale);
   // Converts a RGB16 image to a inverted PAL8 image
   // A lookup table is used for the conversion and dithering is preformed
   // The ImageOut buffer may NOT be the same as the ImageIn buffer.
   // LineSize indicates the number of bytes that should be skipped in
   // the out put data stream after a each line is written (for example
   // if XGA with the sreen width = 1024 and output X_width = 320, then
   // Linesize = 1024-320 = 704
   // X_width  size of input image width
   // Y_height size of input image height
   // Scale increase the output image by 2 if = 1

#pragma linkage(_RGB16_to_IRGB24, system)
extern void _RGB16_to_IRGB24 ( USHORT *ImageIn,
                              BYTE   *ImageOut,
                              ULONG  X_width,
                              ULONG  Y_height,
                              ULONG  scale);
   // Converts a RGB16 image to a inverted RGB24 image
   // The ImageOut buffer may NOT be the same as the ImageIn buffer.
   // X_width  size of input image width  in PELs
   // Y_height size of input image height in PELs
   // Scale increase the output image by 2 if = 1

#pragma linkage(_RGB16_B_W_Line, system)
extern void _RGB16_B_W_Line ( USHORT *ImageIn,
                              ULONG  X_left,
                              ULONG  Y_top,
                              ULONG  X_width,
                              ULONG  Y_height);
   // Draw a black and white Rectangle in a 160x120 RGB16 image
   // The input Rectange coordinates are give in 640x480 coordinates

#pragma linkage(_RGB16_to_YUV24, system)
extern void _RGB16_to_YUV24 ( USHORT *ImageIn,
                              BYTE   *ImageOut,
                              ULONG  X_width,
                              ULONG  Y_height);
   //  Convert a Width x Height 16-bit RGB:565 image (Intel
   //  format) to Y, U, V using tables for optimal speed.

#pragma linkage(_YUV411_to_RGB16, system)
extern void _YUV411_to_RGB16 ( USHORT *ImageIn,
                              BYTE   *ImageOut,
                              ULONG  X_width,
                              ULONG  Y_height);
   //  Convert a Width x Height 16-bit YUV411 image (PCVIDEO format) to RGB16
   //  Intel format 5-Red, 6-Green, 5-Blue).

#pragma linkage(_YUV411_to_IRGB24, system)
extern void _YUV411_to_IRGB24 ( USHORT *ImageIn,
                                BYTE   *ImageOut,
                                ULONG  X_width,
                                ULONG  Y_height);
   //  Convert a Width x Height 16-bit YUV411 image (PCVIDEO format) to an
   //  Inverted RGB24 image ( 8-Red, 8-Green, 8-Blue).

//  Convert a Width x Height YUV422 image to an
//  Inverted RGB24 image ( 8-Red, 8-Green, 8-Blue).
#pragma linkage(_YUV411_to_IRGB24, system)
extern void _YUV422_to_IRGB24 ( USHORT *ImageIn,
                                BYTE   *ImageOut,
                                ULONG  X_width,
                                ULONG  Y_height);
