/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/*----------------------------------------------------------------



  SOURCE FILE NAME:  SWVRCAPT.C


  DESCRIPTION:

 This module contains the ring 3 logic for controlling video capture
 hardware.  This logic will migrate into MCD's for video capture hardware.

* MODIFICATION HISTORY:                                                *
* DATE      DEVELOPER   DEFECT  CHANGE DESCRIPTION                     *
* ---       ---------   ------  ------------------------               *
* 06/06/94  SOLoughlin  12566   Fix Metaware Compiler Error/Warnings   *
*                                                                      *
 ----------------------------------------------------------------------*/

#define INCL_DOS
#define INCL_GPI
#define INCL_DOSMEMMGR
#include <os2.h>
#include <os2me.h>
#include <stdlib.h>
#include <stdio.h>
#include <vidvci.h>   /* Capture device driver info structure */

#include <vsdcmds.h>   // Command interfcae for Video VSD
//#include <swvridll.h>
#include <string.h>
#define INCL_DBCSCRT_NOSTRINGS
//#include <mmiocrt.h>                /* 7/xx/92 Other DBCS string manip. not in C/2...PJR */
//#include <rgbconv.h>                /* RBG conversion Routines             */
#include <pcvideo.h>
#include <vsdini.h>


char *szToken, *stop;
CHAR    pszINIFile[260];
PSZ  pszKey, pszValue, pszLineFound, pszData, pszChips;
char szKey[20], szChips[20],szData[200];
char szBuffer[120];
WORD XCutPoint0, XCutPoint1, YCutPoint0, YCutPoint1;
WORD wMinFilter, wMedFilter, wMaxFilter;
char    szCfgFileSpec[256];
BYTE bHZoomFactor;      /* Current horizontal zoom factor (0-3) */
BYTE bVZoomFactor;      /* Current vertical zoom factor (0-3) */
BYTE bHZoomAdjust;
BYTE bVZoomAdjust;
WORD wBoardType;
WORD wImageWidth;
WORD wImageHeight;
WORD wImageType;
int  iVideoMode;        /* Current graphics mode */
//CFGSTRUCT config;
//ACQUISITIONRECT AcquisitionWindow[2] = {
//                {0x00, 0x1C, 0x2F8, 0x21C},
//                {0x00, 0x1C, 0x278, 0x1F4}
//                };
BYTE    aDefColorTbl[NO_COLOR_CONTROLS];        /* Defaults color table */
MODE    aDefMode[NO_VIDEO_MODES+1];             /* Defaults mode dependent parameters */
WORD    aModeRange[NO_SKEW_FACTORS] = {DISPWINSKEWXRANGE,DISPWINSKEWYRANGE,
        DISPADDRSKEWXRANGE,DISPADDRSKEWYRANGE,SHIFTCLOCKSTARTRANGE,
        PALETTESKEWRANGE,PLLDIVISORRANGE};
char    aDevString[16][80];     /* for saving platform specific */
                                /* initialization data.  Support up to */
                                /* 16 different platforms and each platform */
                                /* 80 characters */
int     DevCnt=0;               /* number of valid platform entries found */
                                /* in the initialization file */


/************************************************************************
* PCV_LoadConfiguration                                                 *
*                                                                       *
* Reads in the PC Video configuration file.                             *
*                                                                       *
* Exit: return code                                                     *
*       = TRUE     Success                                              *
*       = FALSE    File does not exist or is Invalid                    *
************************************************************************/
ULONG PCV_LoadConfiguration(PSZ PDD_NAME, PVOID * INIBuffer,
                           ULONG * ulINIFileSize, HFILE  * hfINIHandle)
{
int   fd, i, j;
int   iRegCount, iChipsCount, iRegIndex=0;
WORD  *Ptr;             /* Word pointer */
BYTE  *bPtr;            /* Byte pointer */
// WORD  wTemp;         /* 12566 - MW Compiler Warning-unused variable */
PSZ     p, pszEnv;
PSZ     pszINIBuffer;
ULONG   rc=MCIERR_SUCCESS;
CFGSTRUCT * config;

/* Get a buffer for HVSD state Information                                */
rc = DosAllocMem ( (PVOID *) &config, (ULONG) sizeof(CFGSTRUCT),
                  PAG_COMMIT | PAG_READ | PAG_WRITE);

if (rc) {
   return VSDERR_INSUFFICIENT_MEMORY;
} /* endif */

*INIBuffer     = config;
*ulINIFileSize = sizeof(CFGSTRUCT);

  /******************************************/
  /* Open and read in VBLASTER.ini file     */
  /******************************************/
  if (!DosScanEnv("MMBASE", &pszEnv))
    {
      strcpy(pszINIFile, pszEnv);

      if (p = strchr(pszINIFile, ';')) *p = 0;

      strcat(pszINIFile, "\\");
    }
  else
    {
      strcpy(pszINIFile, "c:\\");
    }

   strcat(pszINIFile, PDD_NAME);
   strcat(pszINIFile, ".INI");

   rc = ReadFileToBuffer(pszINIFile,
                        (ULONG)OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE,
                        &pszINIBuffer,
                        ulINIFileSize,
                        hfINIHandle);
  if (rc)
     return(MCIERR_INI_FILE);


//  pszINIBuffer = *INIBuffer;

////#ifdef DOSLIB
//        getcwd((LPSTR) &szCfgFileSpec,144);
//        strcpy (szCfgFileSpec,"D:\\MMOS2");
//        i = strlen(szCfgFileSpec)-1;
//        if ( szCfgFileSpec[i] == '\\')
//           strcat(szCfgFileSpec,"pcvideo.ini");
//        else
//           strcat(szCfgFileSpec,"\\pcvideo.ini");
////#else
////        GetWindowsDirectory((LPSTR) &szCfgFileSpec,144);
////        wsprintf((LPSTR) &szCfgFileSpec,"%s\\pcvideo.ini",(LPSTR) &szCfgFileSpec);
////#endif
//        if((fd = fileopen((LPSTR) &szCfgFileSpec, "r")) == -1)
//            return(FALSE);                      /* File does not exist. */
//        fileclose(fd);

  if (IniQuery(pszINIBuffer, "pcvideo", "BufferType",
           &pszLineFound, (PSZ)szData))
     {
     return(MCIERR_INI_FILE);
     }
  else
     {
     if (stricmp(szData,"RGB16")==0)
          wBoardType=BT_RGB16;               /* RGB16 */
     else if (stricmp(szData,"RGB24")==0)
          wBoardType=BT_RGB24;               /* RGB24 */
     else if (stricmp(szData,"YUV411")==0)   /* YUV411 */
          wBoardType=BT_YUV411;
     else return(MCIERR_INI_FILE);           /* Boardtype not support */
     config->wBoardType=wBoardType;
     }

  config->wCfgFlags = 0;                    /* Init to zero */

  if (IniQuery(pszINIBuffer, "pcvideo", "PLL",
           &pszLineFound, (PSZ)szData))
     return(MCIERR_INI_FILE);
  else
     if (stricmp(szData,"Yes")==0)
          config->wCfgFlags |= CF_HASPLL;
     else config->wCfgFlags &= ~CF_HASPLL;

  if (IniQuery(pszINIBuffer, "pcvideo", "PortAddr",
           &pszLineFound, (PSZ)szData))
     return(MCIERR_INI_FILE);
  else
     config->wPortAddr=strtoul(szData, &stop,0);

  if (IniQuery(pszINIBuffer, "pcvideo", "VideoAddr",
           &pszLineFound, (PSZ)szData))
     return(MCIERR_INI_FILE);
  else
     config->wVideoAddr=strtoul(szData, &stop,0);

  if (IniQuery(pszINIBuffer, "pcvideo", "VideoFormat",
           &pszLineFound, (PSZ)szData))
     return(MCIERR_INI_FILE);
  else
     if ( stricmp(szData, "NTSC") == 0 )
          config->wCfgFlags |= CF_NTSC;       /* NTSC */
     else if ( (stricmp(szData, "SECAM") == 0) &&
               (wBoardType != BT_YUV411) )
          config->wCfgFlags |= CF_SECAM;      /* SECAM */
     else
          config->wCfgFlags |= CF_PAL;        /* PAL */

  if (IniQuery(pszINIBuffer, "pcvideo", "VideoSource",
           &pszLineFound, (PSZ)szData))
     return(MCIERR_INI_FILE);
  else
     config->wVideoSource=strtoul(szData, &stop,0);

  if (IniQuery(pszINIBuffer, "pcvideo", "PALAcquisitionWindow",
           &pszLineFound, (PSZ)szData))
     return(MCIERR_INI_FILE);
  else {
     szToken = strtok(szData, " ");
     Ptr = &config->wPALAcqWindow[0];
     while ( szToken !=NULL){
           *Ptr=strtoul(szToken,&stop,0); /* Convert data to value */
           Ptr++;                         /* Increase word pointer */
           szToken=strtok(NULL," ");      /* Get the next token string */
           }
     }

  if (IniQuery(pszINIBuffer, "pcvideo", "NTSCAcquisitionWindow",
           &pszLineFound, (PSZ)szData))
     return(MCIERR_INI_FILE);
  else {
     szToken = strtok(szData, " ");
//   Ptr = &AcquisitionWindow[1].aX1;
     Ptr = &config->wNSTCAcqWindow[0];
     while ( szToken !=NULL){
           *Ptr=strtoul(szToken,&stop,0); /* Convert data to value */
           Ptr++;                         /* Increase word pointer */
           szToken=strtok(NULL," ");      /* Get the next token string */
           }
     }

  if (IniQuery(pszINIBuffer, "pcvideo", "RegCount", &pszLineFound, (PSZ)szData))
     return(MCIERR_INI_FILE);
  else
     iRegCount=config->PCVideoTable.cPCVideoRegs=strtoul(szData, &stop,0);
     for( i=0; i<iRegCount; i++){    /* Loop to get the register value */
         sprintf(szKey,"Reg%X",iRegIndex);
         if( IniQuery(pszINIBuffer,"pcvideo", szKey, &pszLineFound, (PSZ)szData))
            i--;                     /* Skip register does not exist */
         else {
            config->PCVideoTable.aPCVideoRegs[i].rIndex=iRegIndex;
            config->PCVideoTable.aPCVideoRegs[i].rData=strtoul(szData,&stop,0);
            }
         iRegIndex++;                /* Increase register index */
         }

  if (IniQuery(pszINIBuffer, "I2CChips", "ChipsCount", &pszLineFound, (PSZ)szData))
     return(MCIERR_INI_FILE);
  else
     iChipsCount=config->PhixelTable.cPhixelChips=strtoul(szData, &stop,0);
     for(i=0; i<iChipsCount; i++){
         sprintf(szKey,"Chip%d", i+1);
         IniQuery(pszINIBuffer, "I2CChips", szKey, &pszLineFound, (PSZ)szChips);
         strcpy(config->PhixelTable.aPhixelChips[i].aChipID, szChips);
         IniQuery(pszINIBuffer, szChips, "I2CAddr", &pszLineFound, (PSZ)szData);
         config->PhixelTable.aPhixelChips[i].wPhixelAddr=strtoul(szData, &stop,0);
         IniQuery(pszINIBuffer, szChips, "RegCount", &pszLineFound, (PSZ)szData);
         iRegCount=config->PhixelTable.aPhixelChips[i].cPhixelRegs=strtoul(szData,&stop,0);
         for( j=0; j<iRegCount;j++)  {/* Initialize PHIXELCHIP */
              sprintf(szKey,"Reg%X", j);
              IniQuery(pszINIBuffer, szChips, szKey, &pszLineFound, (PSZ)szData);
              config->PhixelTable.aPhixelChips[i].aPhixelRegs[j].rIndex=j;
              config->PhixelTable.aPhixelChips[i].aPhixelRegs[j].rData=strtoul(szData,&stop,0);
              }
         }

  if (IniQuery(pszINIBuffer, "Filter","Min", &pszLineFound, (PSZ)szData))
     wMinFilter = 0x8A;
  else
     wMinFilter = strtoul(szData,&stop,0);

  if (IniQuery(pszINIBuffer, "Filter","Med", &pszLineFound, (PSZ)szData))
     wMedFilter = 0x2A;
  else
     wMedFilter = strtoul(szData,&stop,0);

  if (IniQuery(pszINIBuffer, "Filter","Max", &pszLineFound, (PSZ)szData))
     wMaxFilter = 0x4A;
  else
     wMaxFilter = strtoul(szData,&stop,0);


  if (!(IniQuery(pszINIBuffer, "Filter", "XCutPoint0", &pszLineFound, (PSZ)szData)))
     XCutPoint0 = strtoul(szData,&stop,0);
  if (!(IniQuery(pszINIBuffer, "Filter", "XCutPoint1", &pszLineFound, (PSZ)szData)))
     XCutPoint1 = strtoul(szData,&stop,0);
  if (!(IniQuery(pszINIBuffer, "Filter", "YCutPoint0", &pszLineFound, (PSZ)szData)))
     YCutPoint0 = strtoul(szData,&stop,0);
  if (!(IniQuery(pszINIBuffer, "Filter", "YCutPoint1", &pszLineFound, (PSZ)szData)))
     YCutPoint1 = strtoul(szData,&stop,0);

  /* Initialize aMode */
  for( i=0; i<NO_VIDEO_MODES; i++){
      sprintf(szKey, "Mode%d", i);
      IniQuery(pszINIBuffer, "ModeInfo", szKey, &pszLineFound, (PSZ)szBuffer);
      szToken=strtok(szBuffer," ");       /* Get token string */
      Ptr= &config->aMode[i].DispWinSkewX; /* Get destination pointer */
      while ( szToken !=NULL){
          *Ptr=strtoul(szToken,&stop,0);  /* Convert data to value */
          Ptr++;                          /* Increase word pointer */
          szToken=strtok(NULL," ");       /* Get the next token string */
      }
  }

  if (IniQuery(pszINIBuffer, "ModeInfo", "CurVideoMode", &pszLineFound, (PSZ)szBuffer)==0){
      szToken=strtok(szBuffer," ");       /* Get token string */
      Ptr= &config->aMode[NO_VIDEO_MODES].DispWinSkewX;
                                          /* Get destination pointer */
      while ( szToken !=NULL){
          *Ptr=strtoul(szToken,&stop,0);  /* Convert data to value */
          Ptr++;                          /* Increase word pointer */
          szToken=strtok(NULL," ");       /* Get the next token string */
      }
  }

  /* Initialize mode defaults table */
  for( i=0; i<NO_VIDEO_MODES; i++){
      sprintf(szKey, "Mode%d", i);
      IniQuery(pszINIBuffer, "ModeDef", szKey, &pszLineFound, (PSZ)szBuffer);
      szToken=strtok(szBuffer," ");       /* Get token string */
      Ptr= &aDefMode[i].DispWinSkewX;     /* Get destination pointer */
      while ( szToken !=NULL){
          *Ptr=strtoul(szToken,&stop,0);  /* Convert data to value */
          Ptr++;                          /* Increase word pointer */
          szToken=strtok(NULL," ");       /* Get the next token string */
      }
  }
  Ptr= &aDefMode[NO_VIDEO_MODES].DispWinSkewX;
  for (i=0;i<sizeof(MODE)/2;i++)
     *Ptr++ = (WORD)0;

  /* Initialize color control */
  IniQuery(pszINIBuffer, "ColorCtrl", "Controls", &pszLineFound, (PSZ)szBuffer);
  szToken = strtok(szBuffer," ");     /* Get token string */
  bPtr= config->bColorSettings;
  while ( szToken !=NULL){
      *bPtr=strtoul(szToken,&stop,0); /* Convert data to value */
      bPtr++;                         /* Increase byte pointer */
      szToken=strtok(NULL," ");       /* Get the next token string */
      }

  /* Initialize color defaults table */
  IniQuery(pszINIBuffer, "ColorDef", "Controls", &pszLineFound, (PSZ)szBuffer);
  szToken = strtok(szBuffer," ");     /* Get token string */
  bPtr= &aDefColorTbl[0];
  while ( szToken !=NULL){
      *bPtr=strtoul(szToken,&stop,0); /* Convert data to value */
      bPtr++;                         /* Increase byte pointer */
      szToken=strtok(NULL," ");       /* Get the next token string */
      }

  for (j=0; j < config->PCVideoTable.cPCVideoRegs; j++)
     if (config->PCVideoTable.aPCVideoRegs[j].rIndex == 0x50) {
        config->wCfgFlags |= (config->PCVideoTable.aPCVideoRegs[j].rData & REPLICATE_ON);
      break;
      }

  /* Initialize default Audio Setting */
  if (IniQuery(pszINIBuffer, "Audio", "Volume",
           &pszLineFound, (PSZ)szData))
     config->bVolume = 0;
  else
     config->bVolume = strtoul(szData, &stop,0);

  /* Initialize default Tuner Type Settings */
  if (IniQuery(pszINIBuffer, "Tuner", "Type",
           &pszLineFound, (PSZ)szData))
     config->bTunerType = 0;
  else
     if (stricmp(szData,"BG")==0)
          config->bTunerType = 1;
     else if (stricmp(szData,"I")==0)
          config->bTunerType = 2;
          else config->bTunerType = 0;

  /* Initialize default RFRegion Settings */
  if (IniQuery(pszINIBuffer, "Tuner", "RFRegion",
           &pszLineFound, (PSZ)szData))
     config->bRFRegion = 1;
  else
     config->bRFRegion = strtoul(szData, &stop,0);


  /* Initialize default Channel Settings */
  if (IniQuery(pszINIBuffer, "Tuner", "Channel",
           &pszLineFound, (PSZ)szData))
     config->wChannel = 5;
  else
     config->wChannel = strtoul(szData, &stop,0);

  /* Initialize default Channel Finetune Settings */
  if (IniQuery(pszINIBuffer, "Tuner", "Finetune",
           &pszLineFound, (PSZ)szData))
     config->ulFinetune = 0;
  else
     config->ulFinetune = strtoul(szData, &stop,0);

*ulINIFileSize = sizeof(CFGSTRUCT);

  return(MCIERR_SUCCESS);
}


/************************************************************************
* PCV_LoadDefaultModes                                                  *
*                                                                       *
* Reads in the PC Video configuration file Defaults values              *
* for Video MOdes                                                       *
*  Must call  PCV_LoadConfiguration First                               *
*                                                                       *
* Exit: return code                                                     *
*       = TRUE     Success                                              *
*       = FALSE    File does not exist or is Invalid                    *
************************************************************************/
ULONG PCV_LoadDefaultModes(PVOID pMode)
{
int   i, j;
WORD    *Ptr, *Ptr2;            /* Word pointer */
ULONG   rc=MCIERR_SUCCESS;

/* Copy Default Info from Video Modes to user Buffer */
 Ptr= & aDefMode[0].DispWinSkewX;        /* Get source pointer */
 Ptr2 = (WORD *)pMode;                   /* Get Destination pointer */
 for(i=0;i< NO_VIDEO_MODES;i++){         /* Set Mode table */
    for ( j=0;j<sizeof(MODE)/2;j++){     /* Formate the mode data */
      *Ptr2 = *Ptr;                      /* Copy Data */
      Ptr++;                             /* Advanced Source pointer */
      Ptr2++;                            /* Advanced Destination pointer */
    }
 }

 return(MCIERR_SUCCESS);
}

/************************************************************************
* PCV_LoadDefaultColors                                                 *
*                                                                       *
* Reads in the PC Video configuration file Defaults values              *
* for Color adjustments                                                 *
*  Must call  PCV_LoadConfiguration First                               *
*                                                                       *
* Exit: return code                                                     *
*       = TRUE     Success                                              *
*       = FALSE    File does not exist or is Invalid                    *
************************************************************************/
ULONG PCV_LoadDefaultColors(PVOID pColor)
{
int     i;
BYTE    *Ptr, *Ptr2;            /* Word pointer */
ULONG   rc=MCIERR_SUCCESS;

/* Copy Default Info from Video Modes to user Buffer */
 Ptr= & aDefColorTbl[0];                 /* Get source pointer */
 Ptr2 = pColor;                          /* Get Destination pointer */
 for ( i=0; i<NO_COLOR_CONTROLS; i++){                   /* Formate the CorlorCtrl data */
      *Ptr2 = *Ptr;                      /* Copy Data */
      Ptr++;                             /* Advanced Source pointer */
      Ptr2++;                            /* Advanced Destination pointer */
 }

 return(MCIERR_SUCCESS);
}

/************************************************************************
* PCV_SaveConfiguration                                                 *
*                                                                       *
* Saves the system configuration to pcvideo.ini.                        *
*                                                                       *
* Exit: return code                                                     *
*       = 1 TRUE   Success                                              *
*       = 0 FALSE  File does not exist.                                 *
*                                                                       *
* Note:   The configuration structure is given in PCVIDEO.H.            *
************************************************************************/
BOOL PCV_SaveConfiguration(PSZ PDD_NAME, PVOID INI_Parms, ULONG INI_Parms_Len)
{
FILE   *fd;
int     i,j;
int     iRegCount, iChipsCount;
WORD    *Ptr, *Ptr2;            /* Word pointer */
BYTE    *bPtr;                  /* Byte pointer */
char    szData[200], szBuffer[120], szData2[200];
CHAR    pszINIfile[260];
PSZ     pszINIBuffer;
ULONG   ulINIFileSize;
HFILE   hfINIHandle;
ULONG   rc;
CFGSTRUCT * config;
PSZ     p, pszEnv;

config = (CFGSTRUCT *)INI_Parms;

  /******************************************/
  /* Open and read in VBLASTER.ini file     */
  /******************************************/
  if (!DosScanEnv("MMBASE", &pszEnv))
    {
      strcpy(pszINIFile, pszEnv);

      if (p = strchr(pszINIFile, ';')) *p = 0;

      strcat(pszINIFile, "\\");
    }
  else
    {
      strcpy(pszINIFile, "c:\\");
    }

   strcat(pszINIFile, PDD_NAME);
   strcat(pszINIFile, ".INI");

   rc = ReadFileToBuffer(pszINIFile,
                        (ULONG)OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE,
                        &pszINIBuffer,
                        &ulINIFileSize,
                        &hfINIHandle);
  if (rc)
     return(MCIERR_INI_FILE);
//remove(pszINIFile);

//strcpy(pszINIfile, "c:\\MMOS2\\VIDVBC1$.INI");
//
//   rc = ReadFileToBuffer(pszINIfile,
//                        (ULONG)OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYREADWRITE,
//                        &pszINIBuffer,
//                        &ulINIFileSize,
//                        &hfINIHandle);
//  if (rc)
//     return(MCIERR_INI_FILE);


//if ((fd = fopen("c:\\MMOS2\\VBLAST.INI", "w+")) == NULL)
//    return 0;   /* Could not create file */

for (j=0; j < config->PCVideoTable.cPCVideoRegs; j++)    // Preserve the replicated filed bit
    if (config->PCVideoTable.aPCVideoRegs[j].rIndex == 0x50) {
        config->PCVideoTable.aPCVideoRegs[j].rData |= (config->wCfgFlags & REPLICATE_ON);
    break;
    }

/* Save PCVIDEO info */
rc = IniUpdate (pszINIBuffer, "PCVIDEO","BufferType", "YUV411");

if (wBoardType == BT_RGB16 )        /* RGB16 format */
    IniUpdate (pszINIBuffer, "PCVIDEO","BufferType", "RGB16");
else if (wBoardType == BT_RGB24 )           /* RGB24 format */
    IniUpdate (pszINIBuffer, "PCVIDEO","BufferType", "RGB24");
else                                /* YUV format */
    IniUpdate (pszINIBuffer, "PCVIDEO","BufferType", "YUV411");

if( (config->wCfgFlags & CF_HASPLL) == CF_HASPLL )
    IniUpdate (pszINIBuffer, "PCVIDEO","PLL", "Yes");
else
    IniUpdate (pszINIBuffer, "PCVIDEO","PLL", "No");

sprintf(szData, "0x%X", config->wPortAddr);
IniUpdate (pszINIBuffer, "PCVIDEO","PortAddr", szData);

sprintf(szData, "0x%02X", config->wVideoAddr);
IniUpdate (pszINIBuffer, "PCVIDEO","VideoAddr", szData);

if( (config->wCfgFlags & (CF_NTSC) ) == CF_NTSC ) /* NTSC format */
    IniUpdate (pszINIBuffer, "PCVIDEO","VideoFormat", "NTSC");
else if ((config->wCfgFlags & (CF_SECAM) ) == CF_SECAM)
    IniUpdate (pszINIBuffer, "PCVIDEO","VideoFormat", "SECAM");
else                        /* PAL format */
    IniUpdate (pszINIBuffer, "PCVIDEO","VideoFormat", "PAL");

sprintf(szData, "%d", config->wVideoSource);
IniUpdate (pszINIBuffer, "PCVIDEO","VideoSource", szData);

//Ptr= &AcquisitionWindow[0].aX1;         /* Get source pointer */
Ptr = &config->wPALAcqWindow[0];       /* Get source pointer */
strcpy(szBuffer, "");
for (i = 0; i<4; i++){
    sprintf(szData, "0x%02X ", *Ptr);
    strcat(szBuffer, szData);
    Ptr++;                              /* Advanced pointer */
    }
IniUpdate (pszINIBuffer, "PCVIDEO","PALAcquisitionWindow", szBuffer);

//Ptr= &AcquisitionWindow[1].aX1;         /* Get source pointer */
Ptr = &config->wNSTCAcqWindow[0];        /* Get source pointer */
strcpy(szBuffer, "");
for (i = 0; i<4; i++){
    sprintf(szData, "0x%02X ", *Ptr);
    strcat(szBuffer, szData);
    Ptr++;                              /* Advanced pointer */
    }
IniUpdate (pszINIBuffer, "PCVIDEO","NTSCAcquisitionWindow", szBuffer);

sprintf(szBuffer, "%d", config->PCVideoTable.cPCVideoRegs);
IniUpdate (pszINIBuffer, "PCVIDEO","RegCount", szBuffer);

/* Save PCVIDEO register value */
iRegCount=config->PCVideoTable.cPCVideoRegs;
for( i=0; i<iRegCount; i++){
   sprintf(szBuffer, "REG%X",  config->PCVideoTable.aPCVideoRegs[i].rIndex);
   sprintf(szData,   "0x%02X", config->PCVideoTable.aPCVideoRegs[i].rData);
   IniUpdate (pszINIBuffer, "PCVIDEO", szBuffer, szData);
      }

// **********************************************************************
/* Save Phixel Chips info */
iChipsCount=config->PhixelTable.cPhixelChips;
sprintf(szData, "%d", iChipsCount);
IniUpdate (pszINIBuffer, "I2CChips", "ChipsCount", szData);
for(i=0; i< iChipsCount; i++){
  sprintf(szBuffer, "Chip%d", i+1);
  sprintf(szData, "Chip%d", i+1);
  IniUpdate (pszINIBuffer, "I2CChips", szBuffer, config->PhixelTable.aPhixelChips[i].aChipID);
  }

// ************************************************************************
/* Save Phixel chips registers value */
for(i=0; i< iChipsCount; i++){
  sprintf(szData, "0x%X", config->PhixelTable.aPhixelChips[i].wPhixelAddr);
  IniUpdate (pszINIBuffer, config->PhixelTable.aPhixelChips[i].aChipID, "I2CAddr", szData);
  sprintf(szData, "%d", config->PhixelTable.aPhixelChips[i].cPhixelRegs);
  IniUpdate (pszINIBuffer, config->PhixelTable.aPhixelChips[i].aChipID, "RegCount", szData);

  iRegCount=config->PhixelTable.aPhixelChips[i].cPhixelRegs;
  for( j=0; j<iRegCount; j++){          /* Save register value */
    sprintf(szBuffer, "Reg%X", config->PhixelTable.aPhixelChips[i].aPhixelRegs[j].rIndex);
    sprintf(szData, "0x%02X", config->PhixelTable.aPhixelChips[i].aPhixelRegs[j].rData);
    IniUpdate (pszINIBuffer, config->PhixelTable.aPhixelChips[i].aChipID, szBuffer, szData);
  }
}
//*********************************************************************
/* Save Filter Info */
sprintf(szData, "0x%02X", wMinFilter);
IniUpdate (pszINIBuffer, "Filter", "Min", szData);

sprintf(szData, "0x%02X", wMedFilter);
IniUpdate (pszINIBuffer, "Filter", "Med", szData);

sprintf(szData, "0x%02X", wMaxFilter);
IniUpdate (pszINIBuffer, "Filter", "Max", szData);

sprintf(szData, "%d", XCutPoint0);
IniUpdate (pszINIBuffer, "Filter", "XCutPoint0", szData);

sprintf(szData, "%d", XCutPoint1);
IniUpdate (pszINIBuffer, "Filter", "XCutPoint1", szData);

sprintf(szData, "%d", YCutPoint0);
IniUpdate (pszINIBuffer, "Filter", "YCutPoint0", szData);

sprintf(szData, "%d", YCutPoint1);
IniUpdate (pszINIBuffer, "Filter", "YCutPoint1", szData);

// ***************************************************************
/* Save Mode Info */

sprintf(szData, "%d", NO_VIDEO_MODES);
IniUpdate (pszINIBuffer, "ModeInfo", "ModeCount", szData);

if (iVideoMode != NO_VIDEO_MODES) {
   Ptr2= & config->aMode[NO_VIDEO_MODES].DispWinSkewX;/* Destination ptr */
   Ptr = & config->aMode[iVideoMode].DispWinSkewX;    /* Source ptr      */
   for ( j=0;j<sizeof(MODE)/2;j++)
     *Ptr2++ = *Ptr++;
}

Ptr= & config->aMode[0].DispWinSkewX;    /* Get source pointer */
for(i=0;i< NO_VIDEO_MODES+1;i++){               /* Set Mode table */
   if (i != NO_VIDEO_MODES)
       sprintf(szBuffer, "Mode%d", i);
   else
       sprintf(szBuffer,"CurVideoMode");
   strcpy(szData2,"");
   for ( j=0;j<sizeof(MODE)/2;j++){     /* Formate the mode data */
     if ( *Ptr == (WORD) 0 )
        sprintf(szData, "%d ", *Ptr);
     else
        sprintf(szData, "0x%02X ", *Ptr);
     Ptr++;                             /* Advanced pointer */
     strcat(szData2,szData);
     }
   IniUpdate (pszINIBuffer, "ModeInfo", szBuffer, szData2);
   }

//*********************************************************************
/* Save mode defaults */

sprintf(szData, "%d", NO_VIDEO_MODES);
IniUpdate (pszINIBuffer, "ModeDef", "ModeCount", szData);

Ptr= & aDefMode[0].DispWinSkewX;        /* Get source pointer */
for(i=0;i< NO_VIDEO_MODES;i++){         /* Set Mode table */
   sprintf(szBuffer,"Mode%d",i);
   strcpy(szData2,"");
   for ( j=0;j<sizeof(MODE)/2;j++){     /* Formate the mode data */
     if ( *Ptr == (WORD) 0 )
        sprintf(szData, "%d ", *Ptr);
     else
        sprintf(szData, "0x%02X ", *Ptr);
     strcat(szData2, szData);
     Ptr++;                             /* Advanced pointer */
     }
   IniUpdate (pszINIBuffer, "ModeDef", szBuffer, szData2);
   }

//************************************************************************
/* Save color information */

bPtr= config->bColorSettings;            /* Get source pointer */
strcpy(szData2,"");
for ( i=0; i<7; i++){                   /* Formate the CorlorCtrl data */
     sprintf(szData, "0x%02X ", *bPtr);
     strcat(szData2, szData);
     bPtr++;
     }
IniUpdate (pszINIBuffer, "ColorCtrl", "Controls", szData2);

//************************************************************************
/* Save color defaults table */

bPtr= &aDefColorTbl[0];                 /* Get source pointer */
strcpy(szData2,"");
for ( i=0; i<7; i++){                   /* Formate the CorlorCtrl data */
     sprintf(szData, "0x%02X ", *bPtr);
     strcat(szData2, szData);
     bPtr++;
     }
IniUpdate (pszINIBuffer, "ColorDef", "Controls", szData2);

/* Save Tuner defaults                                                  */
//************************************************************************
 if  (config->bTunerType == 2 ) /* US Tuner */
     IniUpdate (pszINIBuffer, "Tuner", "Type", "I");
 else if (config->bTunerType == 1)
     IniUpdate (pszINIBuffer, "Tuner", "Type", "BG");
 else                        /* PAL format */
     IniUpdate (pszINIBuffer, "Tuner", "Type", "M");

 sprintf(szData, "%d", config->bRFRegion);
 IniUpdate (pszINIBuffer, "Tuner", "RFRegion", szData);

 sprintf(szData, "%d", config->wChannel);
 IniUpdate (pszINIBuffer, "Tuner", "Channel", szData);

 sprintf(szData, "%d", config->ulFinetune);
 IniUpdate (pszINIBuffer, "Tuner", "Finetune", szData);

 sprintf(szData, "0x%02X",config->bVolume);
 IniUpdate (pszINIBuffer, "Audio", "Volume", szData);



//************************************************************************

//************************************************************************
//        /* Save platform specific information */
//        if (DevCnt) {
//            stringf(szBuffer, "[PLATFORM]\r\n");
//            if(filewrite(fd, (LPSTR) szBuffer, strlen(szBuffer))!=
//                strlen(szBuffer))
//                return 0;
//            for(i=0; i<DevCnt; i++) {
//                if(filewrite(fd, (LPSTR)aDevString[i], strlen(aDevString[i]))!=
//                    strlen(aDevString[i]))
//                    return 0;
//            }
//        }
//
rc = WriteBufferToFile(hfINIHandle, pszINIBuffer);
rc = IniFileClose(hfINIHandle);
return(1);
}
//

