/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*************************START OF SPECIFICATIONS *************************/
/* SOURCE FILE NAME:  InitDLL.C                                           */
/*                                                                        */
/* DESCRIPTIVE NAME:  DLL Init/Term                                       */
/*                                                                        */
/*                                                                        */
/* STATUS: OS/2 Release 2.x                                               */
/*                                                                        */
/************************* END OF SPECIFICATIONS **************************/

#include        <stdio.h>

//define         INCL_32                        /* Set include file levels.  */
#define         INCL_DOS                       /* #define  INCL_DOSPROCESS. */
#define         INCL_ERRORS
#define         INCL_WIN
#define         INCL_GPI
#include        <os2.h>                        /* OS/2 headers.             */
#include        <os2me.h>                      /* MMPM/2 headers            */
#include        <vsdcmds.h>                    /* VSD interface             */
#include        <swvridll.h>                   /* VSD interface             */
//#include        <pmbitmap.h>

//#define         INCL_MMIO
//#define         INCL_MMIO_DOSIOPROC
//#include        <os2me.h>                      /* Multi-Media IO extensions.*/
//#include        <hhpheap.h>
//#include        <ioi.h>


//efine  MAX_NUM_HVSDS   64              // Maximun Number of HVSDs

/********************************************************************/
/*  DLL Global data - one copy in memory shared by all processes    */
/*                                                                  */
/*  NOTE - for some reason the compiler requires these global data  */
/*         variables to be inititialized or they will NOT be placed */
/*         in the SHR_SEG segment.  Why?  I don't know....          */
/********************************************************************/
#pragma data_seg (SHR_SEG)
HMODULE         hmodule = 0L;
ULONG           ulNeedResource = 1L;
ULONG           ulCodePage = 0L;
ULONG           ulLanguage = 0L;
LONG            lNameLength = 0L;
HVSD_INSTANCE * HVSD_LIST[MAX_NUM_HVSDS];
PDD_INSTANCE    PDD_Info[MAX_NUM_PDDS];
BYTE     The784Palette[256][3] = {
              0,   0,   0, 128,   0,   0,   0, 146,   0, 128, 128,   0,
              0,   0, 170, 128,   0, 128,   0, 146, 170, 193, 193, 193,
            170, 255, 170, 170, 182, 255,   0,  73, 170,   0,  73, 255,
              0, 109,   0,   0, 109,  85,   0, 109, 170,   0, 109, 255,
              0,  36,   0,   0, 146,  85,   0,  36, 170,   0, 146, 255,
              0, 182,   0,   0, 182,  85,   0, 182, 170,   0, 182, 255,
              0, 219,   0,   0, 219,  85,   0, 219, 170,   0, 219, 255,
            255, 219, 170,   0, 255,  85,   0, 255, 170, 255, 255, 170,
             43,   0,   0,  43,   0,  85,  43,   0, 170,  43,   0, 255,
             43,  36,   0,  43,  36,  85,  43,  36, 170,  43,  36, 255,
             43,  73,   0,  43,  73,  85,  43,  73, 170,  43,  73, 255,
             43, 109,   0,  43, 109,  85,  43, 109, 170,  43, 109, 255,
             43, 146,   0,  43, 146,  85,  43, 146, 170,  43, 146, 255,
             43, 182,   0,  43, 182,  85,  43, 182, 170,  43, 182, 255,
             43, 219,   0,  43, 219,  85,  43, 219, 170,  43, 219, 255,
             43, 255,   0,  43, 255,  85,  43, 255, 170,  43, 255, 255,
             85,   0,   0,  85,   0,  85,  85,   0, 170,  85,   0, 255,
             85,  36,   0,  85,  36,  85,  85,  36, 170,  85,  36, 255,
             85,  73,   0,  85,  73,  85,  85,  73, 170,  85,  73, 255,
             85, 109,   0,  85, 109,  85,  85, 109, 170,  85, 109, 255,
             85, 146,   0,  85, 146,  85,  85, 146, 170,  85, 146, 255,
             85, 182,   0,  85, 182,  85,  85, 182, 170,  85, 182, 255,
             85, 219,   0,  85, 219,  85,  85, 219, 170,  85, 219, 255,
             85, 255,   0,  85, 255,  85,  85, 255, 170,  85, 255, 255,
              0,   0,  85, 128,   0,  85,   0,  36,  85, 128,   0, 255,
            128,  36,   0, 128,  36,  85, 128,  36, 170, 128,  36, 255,
            128,  73,   0, 128,  73,  85, 128,  73, 170, 128,  73, 255,
            128, 109,   0, 128, 109,  85, 128, 109, 170, 128, 109, 255,
              8,   8,   8,  15,  15,  15,  23,  23,  23,  31,  31,  31,
             39,  39,  39,  46,  46,  46,  54,  54,  54,  62,  62,  62,
             70,  70,  70,  77,  77,  77,  85,  85,  85,  93,  93,  93,
            100, 100, 100, 108, 108, 108, 116, 116, 116, 124, 124, 124,
            255, 219,   0, 139, 139, 139, 147, 147, 147, 155, 155, 155,
            255, 182, 255, 170, 170, 170, 178, 178, 178, 185, 185, 185,
              0,  36, 255, 204, 204, 204, 209, 209, 209, 216, 216, 216,
            255, 182, 170, 232, 232, 232, 240, 240, 240, 247, 247, 247,
            255, 219, 255, 128, 146,  85, 128, 146, 170, 128, 146, 255,
            128, 182,   0, 128, 182,  85, 128, 182, 170, 128, 182, 255,
            128, 219,   0, 128, 219,  85, 128, 219, 170, 128, 219, 255,
            128, 255,   0, 128, 255,  85, 128, 255, 170, 128, 255, 255,
            170,   0,   0, 170,   0,  85, 170,   0, 170, 170,   0, 255,
            170,  36,   0, 170,  36,  85, 170,  36, 170, 170,  36, 255,
            170,  73,   0, 170,  73,  85, 170,  73, 170, 170,  73, 255,
            170, 109,   0, 170, 109,  85, 170, 109, 170, 170, 109, 255,
            170, 146,   0, 170, 146,  85, 170, 146, 170, 170, 146, 255,
            170, 182,   0, 170, 182,  85, 170, 182, 170,   0,  73,  85,
            170, 219,   0, 170, 219,  85, 170, 219, 170, 170, 219, 255,
            170, 255,   0, 170, 255,  85,   0,  73,   0, 170, 255, 255,
            213,   0,   0, 213,   0,  85, 213,   0, 170, 213,   0, 255,
            213,  36,   0, 213,  36,  85, 213,  36, 170, 213,  36, 255,
            213,  73,   0, 213,  73,  85, 213,  73, 170, 213,  73, 255,
            213, 109,   0, 213, 109,  85, 213, 109, 170, 213, 109, 255,
            213, 146,   0, 213, 146,  85, 213, 146, 170, 213, 146, 255,
            213, 182,   0, 213, 182,  85, 213, 182, 170, 213, 182, 255,
            213, 219,   0, 213, 219,  85, 213, 219, 170, 213, 219, 255,
            213, 255,   0, 213, 255,  85, 213, 255, 170, 213, 255, 255,
            255, 219,  85, 255,   0,  85, 255,   0, 170, 255, 255,  85,
            255,  36,   0, 255,  36,  85, 255,  36, 170, 255,  36, 255,
            255,  73,   0, 255,  73,  85, 255,  73, 170, 255,  73, 255,
            255, 109,   0, 255, 109,  85, 255, 109, 170, 255, 109, 255,
            255, 146,   0, 255, 146,  85, 255, 146, 170, 255, 146, 255,
            255, 182,   0, 255, 182,  85, 224, 224, 224, 162, 162, 162,
            131, 131, 131, 255,   0,   0,   0, 255,   0, 255, 255,   0,
              0,   0, 255, 255,   0, 255,   0, 255, 255, 255, 255, 255   };
#pragma data_seg ()


/********************************************************************/
/*  DLL Global Process Instance Data - one copy per each process    */
/********************************************************************/

ULONG     ulBufferLength = 0;


/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME: _DLL_InitTerm                                           */
/*                                                                          */
/* DESCRIPTIVE NAME: DLL initialization/Termination routine                 */
/*                                                                          */
/* FUNCTION: This function is executed by OS/2 at DLL load time and DLL     */
/*           unload time.                                                   */
/*                                                                          */
/* NOTES: None                                                              */
/*                                                                          */
/* ENTRY POINT: _DLL_InitTerm                                               */
/*   LINKAGE:   CALL FAR (00:32)                                            */
/*                                                                          */
/* INPUT:                                                                   */
/*              HMODULE hmod     - DLL module handle                        */
/*              ULONG   fTerm    - Init/Term flag                           */
/*                                                                          */
/* EXIT-NORMAL:                                                             */
/*              TRUE (1)                                                    */
/*                                                                          */
/* EXIT-ERROR:                                                              */
/*              FALSE (0)                                                   */
/*                                                                          */
/* SIDE EFFECTS:                                                            */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
#pragma linkage (_DLL_InitTerm, system)
int _CRT_init(void);

unsigned long _DLL_InitTerm ( ULONG hmod,
                              ULONG fTerm )
{
   LONG   rc;
   ULONG  i;

   if(!fTerm){
      if(_CRT_init()){

         for (i=0; i < MAX_NUM_HVSDS ; i++ ) {
             HVSD_LIST[i] = NULL;                 // Empty

         } /* endfor */

         for (i=0; i < MAX_NUM_PDDS ; i++ ) {
             PDD_Info[i].Use_Count = 0;          // unused
         } /* endfor */
         return(0L);

         }/* end if _CRT */

      }/* end if */

      return (1L); /* True, means success, False means failed. */

}/* end _DLL_InitTerm */
