;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 IBM Sample Audio Virtual Device Driver
;
;******************************************************************************
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM shall not be liable for any damages arising out of your use of
; the sample code, even if they have been advised of the possibility
; of such damages.
;
;
; file: vddstruc.inc
;
; Structure definitions for VDD specific data structures
; Inter-Device Communication (IDC) function codes for calls to PDD
;******************************************************************************

;PDDFUNC_OPENPDD                EQU     0  ; Open request sent to PDD by OS
PDDFUNC_QUERYPROTOCOL           EQU     1  ; Insure PDD & VDD are of same level
PDDFUNC_ASSIGNHANDLE            EQU     2  ; Inform PDD of its IDC handle
PDDFUNC_OPENDEVICE              EQU     3  ; Request adapter owndership
PDDFUNC_CLOSEDEVICE             EQU     4  ; Relinquish HW back to PDD control
PDDFUNC_GETIOPORTINFO           EQU     5  ; Provide address of port I/O info

; Inter-Device Communication (IDC) function
; codes for calls from PDD
VDDFUNC_INTERRUPT               EQU     0  ; PDD calls VDD at interrupt
VDDFUNC_CLOSE                   EQU     1  ; PDD no longer needs hardware

; At initialization, the VDD and PDD establish communciation.
; The PDD is asked to send a DWORD constant which identifies its
; protocol level.  The most significant word is zeros.
; Of the least significant word, the MSB is the highest ulFunc
; that the PDD is willing to access and the LSB is the highest
; ulFunc that the VDD is willing to accept.
; If the two drivers disagree on their capabilities, the effort
; to establish communication is deemed unsuccessful.

IDC_PROTOCOL_LEVEL              EQU     0501h   ; See equates above for values

; At initialization, the PDD returns a pointer to a structure
; of the following type.  The VDD uses this information to
; establish session hooks and to virtualize hardware interrupts.

ADAPTERINFO     STRUCT  4       ; '4' => DWORD align
usIRQlevel      dw      0
usDMAlevel      dw      0
ulNumRanges     dd      0       ; Followed by ulNumPorts repetitions of
                                ; PORTARRAYENTRY structures (array elements)
ADAPTERINFO     ENDS

PORTARRAYENTRY  STRUCT  4       ; '4' => DWORD align
FirstPort       dd      0
NumberPorts     dd      0
PORTARRAYENTRY  ENDS

; For each card, store state information and
; information needed to communicate with the PDD.
; The Pdd Name is listed first to assist debug.

PER_CARD_DATA   STRUCT  4       ; '4' => DWORD align
pszPddName      DB      9 dup(0); Name of corresponding PDD (nul terminated)
PTR_PDD_IDC     DF      0       ; Pointer to PDD IDC entry point (for VDD)
hsemAccessVDM   dd      0       ; Mutex Semaphore - Coordinate DOS sessions
hsemPDDrelease  dd      0       ; Event Semaphore - PDD releases hardware

IRQLevel        dd      0       ; Number of entrys in port array
VIRQHandle      dd      0       ; Handle for VDH Virtual Interrupt Services
NumPortRanges   dd      0       ; Number of entrys in port array
PortArrayPtr    dd      0       ; 0:32 pointer to array of port ranges

hvdm_Owning     dd      0       ; Handle to session owning hardware (or zero)
pdb_Owning      dw      0       ; PDB of application which touched hardware
AdapterNum      dd      0       ; 0..(MAX_NUM_ADAPTERS - 1)  Filled in at init
FalseHWIndex    dd      0       ; Index into state array.  Filled in at init
PendingIRQs     dd      0       ; Number of pending virtual interrupts
PER_CARD_DATA   ENDS

MAX_NUM_ADAPTERS equ 8
