;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 IBM Sample Audio Virtual Device Driver
;
;******************************************************************************
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM shall not be liable for any damages arising out of your use of
; the sample code, even if they have been advised of the possibility
; of such damages.
;
; VDDINIT.asm - Initialization
;
; This file contains the VDD initialization routine.  It is called by the
; loader during system initialization (boot).
; Purpose:
;    Parse config.sys command line
;    Establish communication with Physical Device Driver(s)
;    Hook Virtual DOS Machine events (create session, close session)
;
; After initialization, this segment is discardable.  That is, the OS
; may, at its leasure, throw this segment away.  As VDDs are structured
; like DLLs, the OS locks the .sys file so it can re-load this segment.
; Being initialization code, this segment is never again needed and
; remains permanently discarded.
;
; Note: The OS/2 Virtual Dev Help calls (VDHxxx) preserve
; EBX, EBP, ESI, EDI and the segment regs.  The others are
; fair game.  We need to protect ECX and EDX when it matters.
;******************************************************************************
        .386p

        OPTION  OLDMACROS       ; Needed for OS/2 Toolkit when using MASM 6.
       ;INCL_NONE  EQU     1
        INCL_VDH   EQU     1
        INCLUDE mvdm.inc        ; from OS/2 base toolkit
        INCLUDE basemid.inc     ; from OS/2 base toolkit
        INCLUDE devhelp.inc     ; externs for OS/2 Virtual Dev Help functions
        INCLUDE audiovdd.inc    ; EXTRNS for procedures in audiovdd.asm
        INCLUDE audioreq.inc    ; EXTRNS for procedures in audioreq.asm
        INCLUDE audioeoi.inc    ; EXTRNS for procedures in audioeoi.asm
        INCLUDE vdddata.inc     ; EXTRNS for instance and global variables


                                        ;------------------------- CINIT_DATA -
; Initialization data segment.
; SHARED segment discarded after initialization
;
; The table defined below has a pointer to the EOI handler
; for each adapter.  It is used to simplify opening VIRQ handles.
; The maximum number of adaters is defined via equate.  The table
; below has an entry for each adapter and is therefore dependent
; on the maximum number of adapters (defined in another file).
; That is, the table requires updates if the maximum number of
; adapters changes.  The "errdif" generates a assemble time error
; if the equate has been updated without updating this table.

CINIT_DATA   SEGMENT DWORD USE32 PUBLIC 'CINITDATA'
.errdif <8>, %MAX_NUM_ADAPTERS          ; if MAX_NUM_ADAPTERS != 8 then error
PUBLIC          pfnEOIfuncs             ; Visible to kernel debugger
pfnEOIfuncs     dd      MAX_NUM_ADAPTERS dup (?)
                org     pfnEOIfuncs
                dd      OFFSET FLAT:AVDD_EOIHandler0
                dd      OFFSET FLAT:AVDD_EOIHandler1
                dd      OFFSET FLAT:AVDD_EOIHandler2
                dd      OFFSET FLAT:AVDD_EOIHandler3
                dd      OFFSET FLAT:AVDD_EOIHandler4
                dd      OFFSET FLAT:AVDD_EOIHandler5
                dd      OFFSET FLAT:AVDD_EOIHandler6
                dd      OFFSET FLAT:AVDD_EOIHandler7
CINIT_DATA   ENDS


; Initialization code segment
; discardable (see makefile/.def file)
CINIT_TEXT  SEGMENT  DWORD USE32 PUBLIC 'CODE'
        ASSUME   CS:CINIT_TEXT
        ASSUME   DS:FLAT, SS:FLAT, ES:FLAT

                                        ;------------------------- SkipBlanks -
; Input:
;    esi - Offset of a string that potentially has leading spaces
; Output:
;    esi - Changed to points to first non-space in string

SkipBlanks  PROC NEAR
        push    eax
        xor     eax, eax

  More: mov     al, byte ptr [esi]              ; Read character
        cmp     al, ' '                         ; Characters above ' ' are
        jg      Done                            ; not spacing
        cmp     al, 0                           ; ASCII nul is end of string
        je      Done
        inc     esi
        jmp     More

Done:   pop     eax
        ret
SkipBlanks  ENDP

                                        ;-------------------------- CopyToken -
; Copies characters from source string to destination string
; until a space/token separator is encountered.
; Copy is truncated at maximum number of characters that will
; fit in the PDD name field.  Extra characters are discarded
; and destination field is nul padded to fill entire field.
;
; Input:
;    esi - Offset of source string (non-space character as first element)
;    edi - Offset of destination string, token will be stored followed
;          by a terminating nul.
; Output:
;    esi - Modified to point to first character
;          past final character of source token.
CopyToken PROC NEAR
        push    eax
        push    ecx
        push    edi

        cld                                     ; Clear direction flag

        mov     ecx, sizeof PER_CARD_DATA.pszPddName - 1
        xor     eax, eax

  More: mov     al, byte ptr [esi]              ; Look before copying
        cmp     al, ' '                         ; If see a spacing character,
        jle     Done                            ; then we're done copying
        stosb                                   ; Store non-spacing char
        inc     esi                             ; Poing at next source char
        loop    More                            ; If not full, copy next char

 Trunc: mov     al, byte ptr [esi]              ; Consume remainder of
        cmp     al, ' '                         ; source token.
        jle     Done
        inc     esi
        jmp     Trunc

Done:
        ; nul terminate destination string
        ; Store at least one terminating nul
        xor     al, al                          ; nul terminate
        add     ecx, 1                          ; Number remaining dest chars
        rep     stosb                           ; Store nuls to fill dest str

        pop     edi                             ; Restore registers
        pop     ecx
        pop     eax
        ret
CopyToken   ENDP

                                        ;-------------------------- PadSpaces -
; Input
;    ebx -> PDD table entry
; Output
;    PDDname padded with spaces
;
PadSpaces PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp

        push    eax
        push    edi
        push    ecx

        lea     edi, Adapters[ebx].pszPddName
        xor     eax, eax
        mov     ecx, sizeof PER_CARD_DATA.pszPddName - 1

   Top: cmp     byte ptr [edi], ' '             ; Replace characters below
        jg      Bypass                          ; space with a space.
        mov     byte ptr [edi], ' '
Bypass: inc     edi
        loop    Top

        mov     byte ptr [edi], 0               ; nul terminate

        pop     ecx
        pop     edi
        pop     eax
        leave
        ret
PadSpaces ENDP

                                        ;------------------------ CreateMutex -
; Entry:
;    EBX - Index to Adapters table entry
;
; Return (EAX):
;    TRUE  - Create successful
;    FALSE - failed
;
CreateMutex PROC NEAR
        push    ebp
        mov     ebp, esp

        push    ecx                             ; Preserve callers regs
        push    edx

        lea     eax, Adapters[ebx].hsemAccessVDM; Address of semaphore handle
        push    eax
        push    VDH_MUTEXSEM                    ; Create mutex sem
        call    VDHCreateSem

        pop     edx                             ; Restore callers registers
        pop     ecx
        leave
        ret                                     ; Return eax
CreateMutex ENDP

                                        ;------------------------ CreateEvent -
; Entry:
;    EBX - Index to Adapters table entry
;
; Return (EAX):
;    TRUE  - Create successful
;    FALSE - failed
;
CreateEvent PROC NEAR
        push    ecx                             ; Preserve callers regs
        push    edx

        lea     eax, Adapters[ebx].hsemPDDrelease ; Address of semaphore handle
        push    eax
        push    VDH_EVENTSEM                    ; Create Event sem
        call    VDHCreateSem
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        push    Adapters[ebx].hsemPDDrelease    ; Prepare sem for use
        call    VDHResetEventSem                ; If call fails, system halts
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

Success:mov     eax, TRUE                       ; Indicate success
        jmp     Done
Failed: xor     eax, eax                        ; Indicate failure

Done:   pop     edx                             ; Restore callers registers
        pop     ecx
        ret
CreateEvent ENDP

                                        ;---------------------------- OpenPDD -
; Given index to PDD table, this routine attempts to establish
; communication with the PDD.
; This routines function is to call VDHOpenPDD.
; On this action, the OS matches the name we provide to the
; name by which the PDD registered.
; It returns a status code and if succesful, the address of
; the Physical Device Drivers VDD IDC entry point.
; The OS sends a message to the PDD (message 0) which gives
; our entry point to the PDD.
;
; The string compare is case insensitive, but it has some
; trouble when the PDD registers with a name that is blank padded.
; This routine tries to open the PDD with the name provided.  If
; that fails, it blank pads and retries.
;
; Input:
;    ebx   - Index into PDD table entry
;
; Retuns: eax
;    TRUE  - Open was successful
;
;    FALSE - Open failed
;            PDD table entry cleared
;
OpenPDD PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    ecx
        push    edx
        push    esi
        push    edi


        mov     ecx, 2                          ; Number of tries
 DoOpen:
        push    ecx                             ; OS call overwrites ecx
        lea     eax, Adapters[ebx].pszPddName
        push    eax                             ; Address of PDD Name
        push    cs                              ; Advertise our entry point to
        push    OFFSET FLAT:AVDD_IDCEntry       ; PDD.  Query its entry point.
        call    VDHOpenPdd
        pop     ecx                             ; restore ecx
        or      eax, eax                        ; if eax==0, then OS call
        jz      Badness                         ; failed.  Even if succeeded
        or      dx, dx                          ; we should insure the PDD
        jz      Badness                         ; gave us a valid selector.
        jmp     IsOpen                          ; If that's OK, we're open

Badness:call    PadSpaces                       ; Blank pad the PDD name
        loop    DoOpen                          ; Retry

        ; Open failed
        ; Clear the PDD table - this entry only
        xor     eax, eax                        ; Fill table entry with zeros
        lea     esi, Adapters[ebx]              ; Point to PDD table entry
        mov     ecx, sizeof PER_CARD_DATA       ; Number of bytes to fill
        cld
        rep     stosb
        jmp     Failed

IsOpen: ; ds:[eax] -> PDD IDC Entry point.
        ; Remember as a 48 bit pointer
        mov     DWORD PTR Adapters[ebx+0].PTR_PDD_IDC, eax  ; Offset
        mov      WORD PTR Adapters[ebx+4].PTR_PDD_IDC, dx   ; Selector

        ; The defined VDD-PDD IDC protocol includes this API
        ; which acts as a sanity check on device driver levels.
        ; If the two drivers are using different communication
        ; protocol, then we can't talk to the PDD.

        push    PDDFUNC_QUERYPROTOCOL
        push    IDC_PROTOCOL_LEVEL              ; Give our protocol level
        push    0
        call    Adapters[ebx].PTR_PDD_IDC       ; If PDD is using a different
        cmp     eax, IDC_PROTOCOL_LEVEL         ; level, we can't talk.
        jne     Failed

        ; Give PDD a handle to use for calls to our
        ; IDC entrypoint (handle is adapter table index)
        push    PDDFUNC_ASSIGNHANDLE            ; Give PDD a handle to use
        push    ebx                             ; when calling our IDC entry
        push    0                               ; point.  Note handle
        call    Adapters[ebx].PTR_PDD_IDC       ; is Adapter table index

        ; Create a semaphore to serialize DOS session
        ; access to this adapter.  DOS sessions use this
        ; semaphore to compete for hardware access when
        ; the VDD owns the hardware.

        call    CreateMutex
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        ; Create a semaphore to block DOS session execution
        ; when the PDD won't relinquish the hardware.
        ; When the VDD gains hardware access, this semaphore is
        ; posted.  All awaiting DOS sesions are made runnable,
        ; and compete to gain ownership of the mutex semaphore
        ; created above.

        call    CreateEvent
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        ; Call PDD - Get I/O information for adapter.
        ; This information is used during DOS session creation
        ; to establish hooks and to virtualize hardware interrupts.

        push    PDDFUNC_GETIOPORTINFO
        push    0
        push    0
        call    Adapters[ebx].PTR_PDD_IDC
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        mov     esi, eax                        ; Point to PDD's structure
        xor     eax, eax                        ; Remember adapter information
        mov     ax, [esi].ADAPTERINFO.usIRQlevel
        mov     Adapters[ebx].IRQLevel, eax
        mov     eax, [esi].ADAPTERINFO.ulNumRanges
        mov     Adapters[ebx].NumPortRanges, eax
        add     esi, 8                          ; Point to array of port ranges
        mov     Adapters[ebx].PortArrayPtr, esi ; Remember pointer

        mov     ecx, sizeof PER_CARD_DATA       ; Calculate 0..X adapter number
        xor     edx, edx                        ; based on adapter table index
        mov     eax, ebx                        ; 
        div     ecx                             ; eax=quotient edx=remainder(0)
        mov     Adapters[ebx].AdapterNum, eax   ; 0..(MAX_NUM_ADAPTERS-1)
        shl     eax, 1                          ; Change to word index
        mov     Adapters[ebx].FalseHWIndex, eax ; Remember the index

        mov     eax, Adapters[ebx].AdapterNum   ; 0..(MAX_NUM_ADAPTERS-1)
        shl     eax, 2                          ; eax=eax*4 (dword index)
        push    Adapters[ebx].IRQLevel          ; Open handle for VIRQ services
        push    pfnEOIfuncs[eax]                ; Address of EOI handler
        push    0                               ; IRET handler (none)
        push    -1                              ; No timeout
        push    VPIC_SHARE_IRQ                  ; VDD is willing to share IRQ
        call    VDHOpenVIRQ
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed
        mov     Adapters[ebx].VIRQHandle, eax   ; Remember handle

        mov     eax, TRUE                       ; Indicate success
        jmp     Done
Failed: xor     eax, eax                        ; zero return, indicate failure
Done:   pop     edi                             ; Restore registers and return
        pop     esi
        pop     edx
        pop     ecx
        leave                                   ; Restore stack frame
        ret
OpenPDD ENDP

                                        ;----------------------- CloseAllPDDs -
; This routine is called only when the VDD initialization fails.
; Its purpose is to tell the PDDs that we are going away.
; This is done by "re-opening" the PDDs; but this time, telling
; them that our IDC entry point is NULL.
;
; Returns (nothing)
;
CloseAllPDDs PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        pusha                                   ; Push all general purpose regs

        xor     ebx, ebx                        ; Point to start of PDD table
        mov     ecx, MAX_NUM_ADAPTERS           ; Limit number of PDDs

 Next:  lea     eax, Adapters[ebx].pszPddName   ; If name is null, then
        cmp     byte ptr [eax], 0               ; remainder of table is empty.
        je      Success

        push    ecx                             ; OS call overwrites ecx
        push    eax                             ; Address of PDD Name
        push    0                               ; NULL selector
        push    0                               ; NULL offset
        call    VDHOpenPdd                      ; Call OS, Ignore RC

        mov     eax, Adapters[ebx].VIRQHandle   ; If have a VIRQ handle
        or      eax, eax                        ; then close it
        jz      NoVIRQ
        push    eax
        push    Adapters[ebx].VIRQHandle
        call    VDHCloseVIRQ
     NoVIRQ:
        pop     ecx                             ; Restore ecx

        cmp     Adapters[ebx].hsemAccessVDM, 0  ; Have a semaphore handle?
        je      NoSem1
        push    ecx                             ; OS call overwrites ecx
        push    Adapters[ebx].hsemAccessVDM     ; Destroy this sem.
        call    VDHDestroySem                   ; if fails, system halts
        pop     ecx                             ; Restore ecx
  NoSem1:
        cmp     Adapters[ebx].hsemPDDrelease, 0 ; Have a semaphore handle?
        je      NoSem2
        push    ecx                             ; OS call overwrites ecx
        push    Adapters[ebx].hsemPDDrelease    ; Destroy this sem.
        call    VDHDestroySem                   ; if fails, system halts
        pop     ecx                             ; Restore ecx
  NoSem2:
        add     ebx, sizeof PER_CARD_DATA       ; Bump table index
        loop    Next                            ; Close the next PDD

Success:popa                                    ; Restore callers regs
        leave                                   ; Restore stack frame
        ret
CloseAllPDDs ENDP


                                        ;------------------------ ParseConfig -
; Parse config.sys VDD parameters.
; Command line has list of PDDs that should be opened.
; The PDDs are opened and channels are established for
; VDD-PDD communication.
;
; The command line string (passed in) is ASCII nul terminated.
; Tabs can exist as well as trailing spaces.  Leading spaces normally
; don't exist, but can.
;
; PARMS:
;    [ebp+8] - pointer to command line parameters
;              if no parms, null
;
; REGISTER USE:
;    ebx  -  Index into table of Physical Deivce Drivers (Adapter information)
;    esi  -  Points at command line parameters
;    edi  -  Points to destination of string copies (PDD name)
;    ecx  -  Insures don't exceed table size (force truncation)
;    edx  -  Points to start of present table entry
;
ParseConfig PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    ebx                             ; Save callers regs
        push    ecx
        push    edx
        push    esi
        push    edi

        mov     esi, [ebp+8]                    ; Address of command line parms
        or      esi, esi
        je      Failed                          ; If no parms, error

        ; Copy command line parameters to pszPddName fields
        ; of card information data structure and attempt to
        ; establish communication with the PDDs.

        xor     ebx, ebx                        ; Index to first element
        mov     ecx, MAX_NUM_ADAPTERS           ; Limit number of PDDs

NextToken:
        lea     edi, Adapters[ebx].pszPddName   ; Point to PDD name
        call    SkipBlanks
        cmp     byte ptr [esi], 0               ; End of parms? (if yes, done)
        je      NoMoreParms
        call    CopyToken                       ; Copy token at [esi] to [edi]

        call    OpenPDD                         ; Establish IDC communication
        or      eax, eax                        ; if eax==0, then failed
        jz      NextToken                       ; Parse next token
        add     ebx, sizeof PER_CARD_DATA       ; Otherwise, bump table index
        loop    NextToken                       ; and read next token

NoMoreParms:
        or      ebx, ebx                        ; If table index never changed,
        jz      Failed                          ; then no PDDs were found

        mov     eax, TRUE                       ; Indicate success
        jmp     Done
Failed: xor     eax, eax                        ; zero return, indicate failure

Done:   pop     edi                             ; Restore regs and return
        pop     esi
        pop     edx
        pop     ecx
        pop     ebx
        leave                                   ; Restore stack frame
        ret
ParseConfig ENDP

                                        ;------------------- RegisterProperty -
RegisterProperty PROC NEAR
        push    ecx                             ; Preserve registers
        push    edx

        push    OFFSET FLAT:szPropNameAudio
        push    0                               ; Reserved
        push    0                               ; Reserved
        push    VDMP_ENUM                       ; Property type
        push    VDMP_ORD_OTHER                  ; Custom VDD property
        push    0                               ; Allow change while app runs
        push    OFFSET FLAT:szEnumRequired      ; Default value
        push    OFFSET FLAT:szPropEnumList      ; List of valid choices
        push    OFFSET FLAT:AVDDPropVerify      ; Validation function
        call    VDHRegisterProperty
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

Success:
        jmp     Done
Failed:
        call    VDHGetError                     ; Return error code to caller

Done:   pop     edx                             ; Restore callers registers
        pop     ecx                             ; Pass RC from VDH function
        ret                                     ; through to caller
RegisterProperty ENDP

                                        ;---------------------------- VDDInit -
; VDD initialization entry point.
; Purpose:
;    - Establish communication with Physical Device Driver(s).
;    - Hook DOS session events (establish user hooks).
;
; ENTRY
;    Called from OS/2 loader during system initialization (VDD load)
;
; PARMS:
;    [ebp+8] - pointer to command line parameters from config.sys
;              if no parms, null
;
; Details:
; --------
; PDDs and VDDs communicate via Inter Device Communication (IDC).
; This essentially means they exchange the address of an entrypoint and
; call each other through the exchanged addresses.
; IDC calls are ring-0 with no OS intervention.
;
; The following OS/2 Dev Helps are used by PDDs and VDDs to
; establish Inter Device driver communication (IDC).
;    RegisterPDD - Used by Physical Device Driver to register its
;                    IDC entry point and name.
;    VDHOpenPDD  - Used by Virtual Device Driver to query the PDD's
;                    entry point and to provide the PDD with the
;                    VDD's IDC entry point.
;
; When the PDD is loaded (PDDs get loaded before VDDs), the PDD registers
; its IDC entry point and a name.
; When the VDD loads, it queries the PDDs IDC entrypoint through the
; VDHOpenPDD call.  The VDD must "know" the name that the PDD uses to register.
;
; This VDD is written somewhat generically as it can support multiple
; phyiscal device drivers, the names of which are specified as parameters
; on the VDD's command line (in config.sys)
; With a consistent API on the part of the PDDs, and similar hardware,
; it is possible for this single VDD to support multiple
; hardware devices.
;
VDDInit PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    ebx                             ; Save callers registers
        push    esi
        push    edi

        call    RegisterProperty
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        push    [ebp+8]                         ; Address of command line parms
        call    ParseConfig                     ; Opens Physical Device Drivers
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        push    VDM_TERMINATE                   ; Be informed every time a
        push    OFFSET FLAT:AVDDTerminate       ; DOS session terminates.
        call    VDHInstallUserHook              ; 
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        push    VDM_CREATE                      ; Be informed every time a
        push    OFFSET FLAT:AVDDCreate          ; DOS session is opened/created
        call    VDHInstallUserHook              ; 
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        push    VDM_PDB_CHANGE                  ; Be informed every time a VDM
        push    OFFSET FLAT:AVDDPDBChange       ; executes an application.
        call    VDHInstallUserHook              ; (or changes applications)
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        push    VDM_PDB_DESTROY                 ; Be informed every time a
        push    OFFSET FLAT:AVDDPDBDestroy      ; DOS application terminates.
        call    VDHInstallUserHook              ; 
        or      eax, eax                        ; if eax==0, then failed
        jz      Failed

        lea     eax, FLAT:ByteInputHook         ; Fill in hook table with
        mov     DWORD PTR iohHookInfo+0, eax    ; 0:32 address of our
        lea     eax, FLAT:ByteOutputHook        ; hook functions.
        mov     DWORD PTR iohHookInfo+4, eax

Success:
        mov     eax, TRUE                       ; Tell the loader we're happy
        jmp     Done

Failed: ; Inform any open PDDs that we're going away
        ; by re-opening - this time with NULL IDC entry point.
        call    CloseAllPDDs                    ; Clean up all open PDDs
        xor     eax, eax                        ; zero return, indicate failure

Done:   pop     edi                             ; Restore callers registers
        pop     esi
        pop     ebx
        leave
        ret
VDDInit ENDP

CINIT_TEXT ENDS                 ; End of discardable code segment
END     VDDInit                 ; Define VDD entry point (for initialization)
