;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 IBM Sample Audio Virtual Device Driver
;
;******************************************************************************
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM shall not be liable for any damages arising out of your use of
; the sample code, even if they have been advised of the possibility
; of such damages.
;
; INSTDATA.asm - Per DOS session instance data segment
;
; Define instance data segment.
; Segment is initialized to default initial value each time a DOS session
; is created.  The system loads the segment to the same virtual address,
; but backs the segment with separate physical memory.
;
; The variables are declared here (in a separate source file) to issolate
; the segment definitions and to enable separate assembly.
;
; The include file with the same name as this file (with .inc extension)
; defines all the variables declared in this file as externs.
; This makes the variables declared in this file visable through all
; VDD source files.
;******************************************************************************
        .386p

        PUBLIC  AVDD_INSTDATA
        PUBLIC  HVDM_Current
        PUBLIC  PDB_Current
        PUBLIC  FalseHWArray

        INCLUDE vddstruc.inc ; Module specific data structure definitions

                                        ;----------------------- MVDMINSTDATA -
; This segment is allocated for every MVDM session.
; The data in this segment have separate backing memory
; for each VDD instance/DOS session.

MVDMINSTDATA    SEGMENT  DWORD USE32 PUBLIC 'MIDATA'
AVDD_INSTDATA   equ     $                       ; Start of instance data seg

HVDM_Current    dd      0                       ; Handle to the DOS session
PDB_Current     dw      0                       ; Id of current application

; Define array (one element for each adapter)
; Elements can be set to reflect ignore state in
; which case, all port access to the adapter will be
; virtualized to indicate the hardware is not installed.
; Behavior stops when using DOS application terminates.

FalseHWArray    dw MAX_NUM_ADAPTERS dup (0)     ; PDB of DOS app which first
                                                ; touched H/W (then ignored)
MVDMINSTDATA    ENDS
                END
