;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 IBM Sample Audio Virtual Device Driver
;
;******************************************************************************
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM shall not be liable for any damages arising out of your use of
; the sample code, even if they have been advised of the possibility
; of such damages.
;
; GLOBDATA.asm - Virtual Device Driver global data segment
;
; Define global data segment.
; Variables declared here are shared (common) between all MVDM sessions.
;
; The variables are declared here (in a separate source file) to issolate
; the segment definitions and to enable separate assembly.
;
; The include file with the same name as this file (with .inc extension)
; defines all the variables declared in this file as externs.
; This makes the variables declared in this file visable through all
; VDD source files.
;******************************************************************************
        .386p

        OPTION  OLDMACROS       ; Needed for OS/2 Toolkit when using MASM 6.
       ;INCL_NONE  EQU     1
        INCL_VDH   EQU     1
        INCLUDE mvdm.inc        ; from OS/2 base toolkit
        INCLUDE vddstruc.inc    ; Module specific data structure definitions
        INCLUDE audiovdd.inc    ; For address of I/O hook routines

        PUBLIC  AVDD_GLOBDATA
        PUBLIC  Adapters
        PUBLIC  dwTemp
        PUBLIC  SemState
        PUBLIC  iohHookInfo
        PUBLIC  szPropNameAudio
        PUBLIC  szPropEnumList
        PUBLIC  szEnumIfAvail
        PUBLIC  szEnumRequired
        PUBLIC  szEnumPrevent

                                        ;------------------------------ _DATA -
; This segment is allocated once for the life of the VDD.
; The data stored here is common and always accessable.
; The Adapters field stores state information for each of
; the installed Physical Device Drivers/hardware cards.

_DATA           SEGMENT  DWORD USE32 PUBLIC 'DATA'
AVDD_GLOBDATA   equ     $                       ; Start of global data seg
Adapters        PER_CARD_DATA   MAX_NUM_ADAPTERS dup (<>)

dwTemp          dd      0                       ; Temporary variables
SemState        VDHSemState_s   <>

iohHookInfo     ioh_s   <>                      ; Filled in at
                                                ; initialization

                ; Define text for property name (DOS properties screen)
                ; Also define text for possible values (enumeration list).
                ; Shell references this list for display and selection
                ; of value for selected DOS property.

szPropNameAudio db      "AUDIO_ADAPTER_SHARING", 0

szPropEnumList  equ     $
szEnumPrevent   db      "None", 0
szEnumIfAvail   db      "Optional", 0
szEnumRequired  db      "Required", 0
                db      0                       ; End list

_DATA           ENDS
                END
